/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.limewire.ui.support.FatalBugManager;
import org.limewire.ui.swing.Initializer;
import org.limewire.ui.swing.util.GuiUtils;

final class GuiLoader {
    GuiLoader() {
    }

    public void load(String[] args, Frame splashFrame, Image splashImage) {
        try {
            Initializer initializer = new Initializer();
            initializer.initialize(args, splashFrame, splashImage);
        }
        catch (Throwable err) {
            GuiUtils.hideAndDisposeAllWindows();
            try {
                FatalBugManager.handleFatalBug(err);
            }
            catch (Throwable t) {
                Throwable error = err;
                try {
                    t.initCause(err);
                    error = t;
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                GuiLoader.showCorruptionError(error);
                System.exit(1);
            }
        }
    }

    private static final void showCorruptionError(Throwable err) {
        err.printStackTrace();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("LimeWire version 5.4.6");
        pw.print("Java version ");
        pw.print(System.getProperty("java.version", "?"));
        pw.print(" from ");
        pw.println(System.getProperty("java.vendor", "?"));
        pw.print(System.getProperty("os.name", "?"));
        pw.print(" v. ");
        pw.print(System.getProperty("os.version", "?"));
        pw.print(" on ");
        pw.println(System.getProperty("os.arch", "?"));
        Runtime runtime = Runtime.getRuntime();
        pw.println("Free/total memory: " + runtime.freeMemory() + "/" + runtime.totalMemory());
        pw.println();
        err.printStackTrace(pw);
        pw.println();
        pw.println("STARTUP ERROR!");
        pw.println();
        pw.flush();
        GuiLoader.displayError(sw.toString());
    }

    private static final void displayError(String error) {
        System.out.println("Error: " + error);
        final JDialog DIALOG = new JDialog();
        DIALOG.setModal(true);
        Dimension DIALOG_DIMENSION = new Dimension(350, 200);
        Dimension INNER_SIZE = new Dimension(300, 150);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BorderLayout());
        String instr0 = "One or more necessary files appear to be invalid.";
        String instr1 = "This is generally caused by a corrupted installation.";
        String instr2 = "Please try downloading and installing LimeWire again.";
        String instr3 = "If the problem persists, please visit www.limewire.com ";
        String instr4 = "and click the 'Support' link.  ";
        String instr5 = "Thank you.";
        JLabel label0 = new JLabel(instr0);
        JLabel label1 = new JLabel(instr1);
        JLabel label2 = new JLabel(instr2);
        JLabel label3 = new JLabel(instr3);
        JLabel label4 = new JLabel(instr4);
        JLabel label5 = new JLabel(instr5);
        JPanel labelPanel = new JPanel();
        JPanel innerLabelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        innerLabelPanel.setLayout(new BoxLayout(innerLabelPanel, 1));
        innerLabelPanel.add(label0);
        innerLabelPanel.add(label1);
        innerLabelPanel.add(label2);
        innerLabelPanel.add(label3);
        innerLabelPanel.add(label4);
        innerLabelPanel.add(label5);
        innerLabelPanel.add(Box.createVerticalStrut(6));
        labelPanel.add(innerLabelPanel);
        labelPanel.add(Box.createHorizontalGlue());
        final JTextArea textArea = new JTextArea(error);
        textArea.selectAll();
        textArea.copy();
        textArea.setColumns(50);
        textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setBorder(BorderFactory.createEtchedBorder());
        scroller.setPreferredSize(INNER_SIZE);
        JPanel buttonPanel = new JPanel();
        JButton copyButton = new JButton("Copy Report");
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textArea.selectAll();
                textArea.copy();
            }
        });
        JButton quitButton = new JButton("Ok");
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
            }
        });
        buttonPanel.add(copyButton);
        buttonPanel.add(quitButton);
        mainPanel.add((Component)labelPanel, "North");
        mainPanel.add((Component)scroller, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        DIALOG.getContentPane().add(mainPanel);
        DIALOG.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = DIALOG.getSize();
        DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        DIALOG.setVisible(true);
    }
}

