/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.support;

import com.google.inject.Inject;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.core.api.Application;
import org.limewire.core.api.support.LocalClientInfo;
import org.limewire.core.api.support.LocalClientInfoFactory;
import org.limewire.core.impl.support.LocalClientInfoImpl;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IOUtils;
import org.limewire.ui.support.NoSessionInfo;
import org.limewire.ui.support.RemoteClientInfo;
import org.limewire.ui.support.ServletAccessor;
import org.limewire.ui.swing.action.UrlAction;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.settings.BugSettings;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;
import org.limewire.util.NotImplementedException;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

public final class BugManager {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;
    @Inject
    private static volatile Application application;
    private final int DIALOG_BOX_WIDTH = 300;
    private final int DIALOG_BOX_HEIGHT = 100;
    private final ExecutorService BUGS_QUEUE = ExecutorsHelper.newProcessingQueue(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "BugProcessor");
            t.setDaemon(true);
            return t;
        }
    });
    private final Map<String, Long> BUG_TIMES = Collections.synchronizedMap(new HashMap());
    private final Object WRITE_LOCK = new Object();
    private final byte[] SEPARATOR = "-----------------\n".getBytes();
    private volatile long _nextAllowedTime = 0L;
    private volatile int _dialogsShowing = 0;
    private final int MAX_DIALOGS = 3;
    private boolean dirty = false;
    @InspectionPoint(value="bug report")
    private static final Inspectable INSPECTABLE;

    public BugManager() {
        this.loadOldBugs();
    }

    public void shutdown() {
        this.writeBugsToDisk();
    }

    public void handleBug(Throwable bug, String threadName, String detail) {
        if (bug instanceof ThreadDeath) {
            throw (ThreadDeath)bug;
        }
        if (bug instanceof IOException && IOUtils.handleException((IOException)bug, IOUtils.ErrorType.GENERIC)) {
            return;
        }
        bug.printStackTrace();
        LocalClientInfo info = localClientInfoFactory == null ? new LocalClientInfoImpl(bug, threadName, detail, false, new NoSessionInfo()) : localClientInfoFactory.createLocalClientInfo(bug, threadName, detail, false);
        if (BugSettings.LOG_BUGS_LOCALLY.getValue()) {
            this.logBugLocally(info);
        }
        boolean sent = false;
        if (!LimeWireUtils.isTestingVersion()) {
            if (!BugSettings.REPORT_BUGS.getValue()) {
                return;
            }
            if (!this.shouldInform(info)) {
                return;
            }
            if (this.isSendableVersion() && (LimeWireUtils.isAlphaRelease() || !BugSettings.SHOW_BUGS.getValue())) {
                sent = true;
            }
            if (sent) {
                this.sendToServlet(info);
            }
        }
        if (!sent && this._dialogsShowing < 3) {
            this.reviewBug(info, bug instanceof NotImplementedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void logBugLocally(LocalClientInfo info) {
        File f = BugSettings.BUG_LOG_FILE.get();
        FileUtils.setWriteable(f);
        BufferedOutputStream os = null;
        try {
            Object object = this.WRITE_LOCK;
            synchronized (object) {
                if (f.length() > (long)BugSettings.MAX_BUGFILE_SIZE.getValue()) {
                    f.delete();
                }
                os = new BufferedOutputStream(new FileOutputStream(f.getPath(), true));
                ((OutputStream)os).write((new Date().toString() + "\n").getBytes());
                ((OutputStream)os).write(info.toBugReport().getBytes());
                ((OutputStream)os).write(this.SEPARATOR);
                ((OutputStream)os).flush();
            }
        }
        catch (IOException ignored) {
            IOUtils.close(os);
            catch (Throwable throwable) {
                IOUtils.close(os);
                throw throwable;
            }
        }
        IOUtils.close(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadOldBugs() {
        ObjectInputStream in;
        block6: {
            in = null;
            File f = BugSettings.BUG_INFO_FILE.get();
            try {
                in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
                String version = (String)in.readObject();
                long nextTime = in.readLong();
                if (version.equals(LimeWireUtils.getLimeWireVersion())) {
                    Map<String, Long> bugs = GenericsUtils.scanForMap(in.readObject(), String.class, Long.class, GenericsUtils.ScanMode.REMOVE);
                    this._nextAllowedTime = nextTime;
                    long now = System.currentTimeMillis();
                    for (Map.Entry<String, Long> entry : bugs.entrySet()) {
                        Long allowed = entry.getValue();
                        if (allowed == null || now >= allowed) continue;
                        this.BUG_TIMES.put(entry.getKey(), allowed);
                    }
                    break block6;
                }
                if (BugSettings.REPORT_BUGS.getValue()) break block6;
                BugSettings.REPORT_BUGS.setValue(true);
                BugSettings.SHOW_BUGS.setValue(true);
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                catch (Throwable throwable2) {
                    IOUtils.close(in);
                    throw throwable2;
                }
            }
        }
        IOUtils.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeBugsToDisk() {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            if (!this.dirty) {
                return;
            }
            ObjectOutputStream out = null;
            try {
                File f = BugSettings.BUG_INFO_FILE.get();
                out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
                String version = LimeWireUtils.getLimeWireVersion();
                out.writeObject(version);
                out.writeLong(this._nextAllowedTime);
                out.writeObject(this.BUG_TIMES);
                out.flush();
            }
            catch (Exception exception) {
                IOUtils.close(out);
                catch (Throwable throwable) {
                    IOUtils.close(out);
                    throw throwable;
                }
            }
            IOUtils.close(out);
            this.dirty = false;
        }
    }

    private boolean shouldInform(LocalClientInfo info) {
        long now = System.currentTimeMillis();
        if (now < this._nextAllowedTime) {
            return false;
        }
        Long allowed = this.BUG_TIMES.get(info.getParsedBug());
        return allowed == null || now >= allowed;
    }

    private boolean isSendableVersion() {
        Version lastVersion;
        Version myVersion;
        try {
            myVersion = new Version(LimeWireUtils.getLimeWireVersion());
            lastVersion = new Version(BugSettings.LAST_ACCEPTABLE_VERSION.get());
        }
        catch (VersionFormatException vfe) {
            return false;
        }
        return myVersion.compareTo(lastVersion) >= 0;
    }

    private void reviewBug(final LocalClientInfo info, boolean notImplemented) {
        ++this._dialogsShowing;
        String title = notImplemented ? I18n.tr("Oops!") : I18n.tr("A problem occurred...");
        final LimeJDialog DIALOG = new LimeJDialog((Window)GuiUtils.getMainFrame(), title, Dialog.ModalityType.APPLICATION_MODAL);
        Dimension DIALOG_DIMENSION = new Dimension(300, 100);
        DIALOG.setSize(DIALOG_DIMENSION);
        DIALOG.setResizable(false);
        DIALOG.setDefaultCloseOperation(2);
        DIALOG.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                BugManager.this._dialogsShowing--;
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new GridBagLayout());
        boolean sendable = this.isSendableVersion();
        String msg = notImplemented ? (sendable ? I18n.tr("Oops!  You did something we haven't written yet.  Sorry about that.  LimeWire's still going to run just fine, but please click 'Send Bug' to remind us to write this.  If you want, you can click 'Show Bug' to look at the information that will be sent. Thanks!") : I18n.tr("Oops!  You did something we haven't written yet.  Sorry about that.  LimeWire's still going to run just fine, so don't worry.  If you want, you can click 'Show Bug' to look at the information about the error.")) : (sendable ? I18n.tr("Sorry, LimeWire ran into a problem.  LimeWire's still going to run just fine, but you should send us the bug so we can fix it.") : I18n.tr("LimeWire has encountered an internal error. It is possible for LimeWire to recover and continue running normally. To continue using LimeWire, close this window. If desired, you can click 'Show Bug' to look at the information about the error."));
        MultiLineLabel label = new MultiLineLabel(msg, 500);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        labelPanel.add((Component)label, constraints);
        final JPanel bugSpecificsPanel = new JPanel();
        bugSpecificsPanel.setLayout(new GridBagLayout());
        bugSpecificsPanel.setVisible(false);
        JTextArea showBug = new JTextArea(info.toBugReport());
        showBug.setColumns(50);
        showBug.setEditable(false);
        showBug.setCaretPosition(0);
        showBug.setLineWrap(true);
        showBug.setWrapStyleWord(true);
        JScrollPane showBugScroller = new JScrollPane(showBug);
        showBugScroller.setBorder(BorderFactory.createEtchedBorder());
        showBugScroller.setPreferredSize(new Dimension(500, 200));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        bugSpecificsPanel.add((Component)showBugScroller, constraints);
        final String defaultDesc = I18n.tr("Tell us what you were doing before LimeWire ran into this problem.");
        final JTextArea userCommentsTextArea = new JTextArea(defaultDesc);
        userCommentsTextArea.setLineWrap(true);
        userCommentsTextArea.setWrapStyleWord(true);
        userCommentsTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (userCommentsTextArea.getText().equals(defaultDesc)) {
                    userCommentsTextArea.selectAll();
                }
            }
        });
        JScrollPane userCommentsScrollPane = new JScrollPane(userCommentsTextArea);
        userCommentsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        userCommentsScrollPane.setPreferredSize(new Dimension(500, 60));
        if (sendable) {
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.insets = new Insets(10, 0, 0, 0);
            bugSpecificsPanel.add((Component)userCommentsScrollPane, constraints);
        }
        final HyperlinkButton showHideBugLink = new HyperlinkButton(I18n.tr("Show Bug"));
        showHideBugLink.addActionListener(new AbstractAction(){
            boolean panelVisible = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.panelVisible) {
                    bugSpecificsPanel.setVisible(false);
                    showHideBugLink.setText(I18n.tr("Show Bug"));
                    DIALOG.pack();
                } else {
                    bugSpecificsPanel.setVisible(true);
                    showHideBugLink.setText(I18n.tr("Hide Bug"));
                }
                DIALOG.pack();
                this.panelVisible = !this.panelVisible;
            }
        });
        HyperlinkButton helpLink = new HyperlinkButton(I18n.tr("Ask for help on the forums"));
        String url = LimeWireUtils.isAlphaRelease() || LimeWireUtils.isBetaRelease() ? "http://www.limewire.com/client_redirect/?page=betaTesting" : "http://www.limewire.com/client_redirect/?page=usingLimeWire5";
        if (application != null) {
            helpLink.addActionListener(new UrlAction(url, application));
        } else {
            helpLink.addActionListener(new UrlAction(url));
        }
        final JCheckBox alwaysuseThisAnswer = new JCheckBox(I18n.tr("Send bugs without asking me in the future"));
        alwaysuseThisAnswer.setSelected(false);
        JButton sendButton = new JButton(I18n.tr("Send Bug"));
        sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String userComments;
                if (alwaysuseThisAnswer.isSelected()) {
                    BugSettings.SHOW_BUGS.setValue(false);
                }
                if (!(userComments = userCommentsTextArea.getText()).equals(defaultDesc)) {
                    info.addUserComments(userComments);
                }
                BugManager.this.sendToServlet(info);
                DIALOG.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        mainPanel.add((Component)labelPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.anchor = 21;
        mainPanel.add((Component)showHideBugLink, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.anchor = 22;
        mainPanel.add((Component)helpLink, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(30, 0, 6, 0);
        mainPanel.add((Component)bugSpecificsPanel, constraints);
        if (sendable) {
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(10, 0, 0, 0);
            mainPanel.add((Component)alwaysuseThisAnswer, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.gridwidth = 2;
            mainPanel.add((Component)sendButton, constraints);
        }
        mainPanel.validate();
        DIALOG.getContentPane().add(mainPanel);
        DIALOG.pack();
        sendButton.requestFocusInWindow();
        DIALOG.setLocationRelativeTo(GuiUtils.getMainFrame());
        try {
            DIALOG.setVisible(true);
        }
        catch (InternalError ie) {
        }
        catch (ArrayIndexOutOfBoundsException npe) {
            // empty catch block
        }
    }

    private void servletSendFailed(LocalClientInfo info) {
        ++this._dialogsShowing;
        final LimeJDialog DIALOG = new LimeJDialog((Window)GuiUtils.getMainFrame(), I18n.tr("Internal Error"), Dialog.ModalityType.APPLICATION_MODAL);
        Dimension DIALOG_DIMENSION = new Dimension(350, 300);
        Dimension ERROR_DIMENSION = new Dimension(300, 200);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        MultiLineLabel label = new MultiLineLabel(I18n.tr("LimeWire was unable to connect to the bug server in order to send the below bug report. For further help and to aid with debugging, please visit www.limewire.com and click 'Support'. Thank you."), 400);
        JPanel labelPanel = new JPanel();
        JPanel innerPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.add(label);
        innerPanel.add(Box.createVerticalStrut(6));
        labelPanel.add(innerPanel);
        labelPanel.add(Box.createHorizontalGlue());
        String bugInfo = info.toBugReport().trim() + "\n\n" + "FILES IN CURRENT DIRECTORY NOT LISTED.\n" + "SIZE: 0";
        final JTextArea textArea = new JTextArea(bugInfo);
        textArea.selectAll();
        textArea.copy();
        textArea.setColumns(50);
        textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setBorder(BorderFactory.createEtchedBorder());
        scroller.setPreferredSize(ERROR_DIMENSION);
        JPanel buttonPanel = new JPanel();
        JButton copyButton = new JButton(I18n.tr("Copy Report"));
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textArea.selectAll();
                textArea.copy();
                textArea.setCaretPosition(0);
            }
        });
        JButton quitButton = new JButton(I18n.tr("OK"));
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        buttonPanel.add(copyButton);
        buttonPanel.add(quitButton);
        mainPanel.add(labelPanel);
        mainPanel.add(scroller);
        mainPanel.add(buttonPanel);
        DIALOG.getContentPane().add(mainPanel);
        try {
            DIALOG.pack();
        }
        catch (OutOfMemoryError oome) {
            return;
        }
        DIALOG.setLocationRelativeTo(GuiUtils.getMainFrame());
        DIALOG.setVisible(true);
    }

    private void sendToServlet(LocalClientInfo info) {
        this.BUGS_QUEUE.execute(new ServletSender(info));
    }

    static {
        INSPECTABLE = new Inspectable(){

            @Override
            public Object inspect() {
                if (!SwingUiSettings.USAGE_STATS.getValue() && !LimeWireUtils.isAlphaRelease()) {
                    return "Denied";
                }
                Exception e = new Exception();
                e.setStackTrace(new StackTraceElement[0]);
                LocalClientInfo info = localClientInfoFactory.createLocalClientInfo(e, "", "", false);
                return info.getShortParamList();
            }
        };
    }

    private class ServletSender
    implements Runnable {
        final LocalClientInfo INFO;

        ServletSender(LocalClientInfo info) {
            this.INFO = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RemoteClientInfo remoteInfo = new ServletAccessor().getRemoteBugInfo(this.INFO);
            if (remoteInfo == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BugManager.this.servletSendFailed(ServletSender.this.INFO);
                    }
                });
                return;
            }
            long now = System.currentTimeMillis();
            long thisNextTime = remoteInfo.getNextThisBugTime();
            long anyNextTime = remoteInfo.getNextAnyBugTime();
            Object object = BugManager.this.WRITE_LOCK;
            synchronized (object) {
                if (anyNextTime != 0L) {
                    BugManager.this._nextAllowedTime = now + thisNextTime;
                    BugManager.this.dirty = true;
                }
                if (thisNextTime != 0L) {
                    BugManager.this.BUG_TIMES.put(this.INFO.getParsedBug(), now + thisNextTime);
                    BugManager.this.dirty = true;
                }
                BugManager.this.writeBugsToDisk();
            }
        }
    }
}

