/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.limewire.collection.Range;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.nio.ByteBufferCache;
import org.limewire.swarm.SwarmContent;
import org.limewire.swarm.SwarmCoordinator;
import org.limewire.swarm.SwarmWriteJob;
import org.limewire.swarm.SwarmWriteJobControl;

public class SwarmWriteJobImpl
implements SwarmWriteJob {
    private static final Log LOG = LogFactory.getLog(SwarmWriteJobImpl.class);
    private final ExecutorService jobScheduler;
    private final SwarmCoordinator fileCoordinator;
    private final Object scheduleLock = new Object();
    private Future<Void> scheduledJob;
    private final Range range;
    private Range writeRange = null;
    private final SwarmWriteJobControl callback;
    private final ByteBufferCache byteBufferCache;
    private static final int BUFFER_SIZE = 16384;

    public SwarmWriteJobImpl(Range range, SwarmCoordinator fileCoordinator, ExecutorService jobScheduler, SwarmWriteJobControl callback) {
        this.jobScheduler = jobScheduler;
        this.fileCoordinator = fileCoordinator;
        this.range = range;
        this.writeRange = range;
        this.callback = callback;
        this.byteBufferCache = new ByteBufferCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.scheduleLock;
        synchronized (object) {
            LOG.debug("Cancelling Write Job");
            if (this.scheduledJob != null) {
                this.scheduledJob.cancel(false);
                this.scheduledJob = null;
            }
            this.fileCoordinator.unpending(this.range);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(SwarmContent content) throws IOException {
        long written = 0L;
        Object object = this.scheduleLock;
        synchronized (object) {
            final ByteBuffer networkUnblockingBuffer = this.byteBufferCache.getHeap(16384);
            content.read(networkUnblockingBuffer);
            networkUnblockingBuffer.flip();
            written = networkUnblockingBuffer.limit();
            LOG.tracef("Going to write: {0} bytes.", (Object)written);
            this.scheduledJob = this.jobScheduler.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SwarmWriteJobImpl.this.writeData(SwarmWriteJobImpl.this.range, networkUnblockingBuffer);
                    return null;
                }
            });
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(Range range, ByteBuffer buffer) throws IOException {
        Object object = this.scheduleLock;
        synchronized (object) {
            try {
                long bytesWritten = 0L;
                long totalWritten = 0L;
                do {
                    bytesWritten = this.fileCoordinator.write(this.writeRange, buffer);
                    long newLow = this.writeRange.getLow() + bytesWritten;
                    long newHigh = this.writeRange.getHigh();
                    LOG.trace("Re-requesting I/O");
                    this.callback.resume();
                    if (newLow <= newHigh) {
                        Range newRange;
                        this.writeRange = newRange = Range.createRange(newLow, newHigh);
                    }
                    totalWritten += bytesWritten;
                } while (buffer.hasRemaining());
                LOG.tracef("wrote: {0} bytes", (Object)totalWritten);
            }
            finally {
                this.byteBufferCache.release(buffer);
                this.callback.resume();
            }
        }
    }
}

