/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Properties;
import org.limewire.setting.AbstractNumberSetting;

public final class IntSetting
extends AbstractNumberSetting<Integer> {
    private int value;

    IntSetting(Properties defaultProps, Properties props, String key, int defaultInt) {
        super(defaultProps, props, key, String.valueOf(defaultInt), false, null, null);
    }

    IntSetting(Properties defaultProps, Properties props, String key, int defaultInt, int minRemoteVal, int maxRemoteVal) {
        super(defaultProps, props, key, String.valueOf(defaultInt), true, minRemoteVal, maxRemoteVal);
    }

    @Override
    public Integer get() {
        return this.getValue();
    }

    @Override
    public void set(Integer newValue) {
        this.setValue(newValue);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.setValueInternal(String.valueOf(value));
    }

    @Override
    protected void loadValue(String sValue) {
        try {
            this.value = Integer.parseInt(sValue.trim());
        }
        catch (NumberFormatException nfe) {
            this.revertToDefault();
        }
    }

    @Override
    protected Comparable<Integer> convertToComparable(String value) {
        return new Integer(value);
    }

    @Override
    public IntSetting setAlwaysSave(boolean alwaysSave) {
        return (IntSetting)super.setAlwaysSave(alwaysSave);
    }
}

