/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.listener.EventBroadcaster;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.rudp.AbstractNBSocketChannel;
import org.limewire.rudp.ChunkReleaser;
import org.limewire.rudp.DataRecord;
import org.limewire.rudp.DataWindow;
import org.limewire.rudp.DefaultRUDPContext;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.UDPConnection;
import org.limewire.rudp.UDPConnectionProcessor;
import org.limewire.rudp.UDPSocketChannelConnectionEvent;
import org.limewire.rudp.messages.DataMessage;
import org.limewire.rudp.messages.SynMessage;
import org.limewire.util.BufferUtils;

public class UDPSocketChannel
extends AbstractNBSocketChannel
implements InterestReadableByteChannel,
InterestWritableByteChannel,
ChunkReleaser {
    private static final Log LOG = LogFactory.getLog(UDPSocketChannel.class);
    private final UDPConnectionProcessor processor;
    private final RUDPContext context;
    private final AbstractNBSocket socket;
    private final DataWindow readData;
    private volatile WriteObserver writer;
    private final ArrayList<ByteBuffer> chunks;
    private ByteBuffer activeChunk;
    private boolean writeHandled = false;
    private final Object writeLock = new Object();
    private boolean shutdown = false;
    private final SynMessage.Role role;
    long last = 0L;

    protected UDPSocketChannel(SelectorProvider provider, RUDPContext context, SynMessage.Role role, EventBroadcaster<UDPSocketChannelConnectionEvent> connectionStateEventBroadcaster) {
        super(provider);
        this.context = context;
        this.role = role;
        this.processor = new UDPConnectionProcessor(this, context, role, connectionStateEventBroadcaster);
        this.readData = this.processor.getReadWindow();
        this.chunks = new ArrayList(5);
        this.socket = new UDPConnection(context, this);
        this.allocateNewChunk();
        try {
            this.configureBlocking(false);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    UDPSocketChannel(UDPConnectionProcessor processor, SynMessage.Role role) {
        super(null);
        this.role = role;
        this.context = new DefaultRUDPContext();
        this.processor = processor;
        this.readData = processor.getReadWindow();
        this.chunks = new ArrayList(5);
        this.socket = new UDPConnection(this.context, this);
        this.allocateNewChunk();
        try {
            this.configureBlocking(false);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public boolean isForMe(InetSocketAddress address, SynMessage message) {
        if (!this.getRemoteSocketAddress().equals(address)) {
            return false;
        }
        if (!this.role.canConnectTo(message.getRole())) {
            return false;
        }
        byte theirConnectionId = this.processor.getTheirConnectionID();
        return theirConnectionId == 0 || theirConnectionId == message.getSenderConnectionID();
    }

    UDPConnectionProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void interestRead(boolean status) {
        NIODispatcher.instance().interestRead(this, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer to) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        UDPConnectionProcessor uDPConnectionProcessor = this.processor;
        synchronized (uDPConnectionProcessor) {
            int cleared;
            int priorSpace = this.readData.getWindowSpace();
            int read = 0;
            DataRecord currentRecord = this.readData.getReadableBlock();
            while (currentRecord != null) {
                read += this.transfer(currentRecord, to);
                if (!to.hasRemaining()) break;
                currentRecord = this.readData.getReadableBlock();
            }
            if ((cleared = this.readData.clearEarlyReadBlocks()) > 0 && priorSpace == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending aritifial keep alive: cleared=" + cleared + ", priorSpace=" + priorSpace + ", read=" + read + ", windowSpace=" + this.readData.getWindowSpace() + ", windowStart=" + this.readData.getWindowStart());
                }
                this.processor.sendKeepAlive();
            }
            if (read == 0 && this.processor.isClosed()) {
                return -1;
            }
            return read;
        }
    }

    private int transfer(DataRecord record, ByteBuffer to) {
        DataMessage msg = record.msg;
        int read = 0;
        ByteBuffer chunk = msg.getData1Chunk();
        if (chunk.hasRemaining()) {
            read += BufferUtils.transfer(chunk, to, false);
        }
        if (chunk.hasRemaining()) {
            return read;
        }
        chunk = msg.getData2Chunk();
        read += BufferUtils.transfer(chunk, to, false);
        if (!chunk.hasRemaining()) {
            record.read = true;
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.isOpen() || this.processor.isClosed()) {
            throw new ClosedChannelException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            if (this.getNumberOfPendingChunks() == 0) {
                this.processor.wakeupWriteEvent(!this.writeHandled);
            }
            this.writeHandled = true;
            int wrote = 0;
            while (src.hasRemaining()) {
                if (this.activeChunk.hasRemaining()) {
                    wrote += BufferUtils.transfer(src, this.activeChunk, false);
                    continue;
                }
                if (this.chunks.size() < this.processor.getChunkLimit()) {
                    this.chunks.add(this.activeChunk);
                    this.allocateNewChunk();
                    continue;
                }
                return wrote;
            }
            return wrote;
        }
    }

    private void allocateNewChunk() {
        this.activeChunk = NIODispatcher.instance().getBufferCache().getHeap(512);
    }

    @Override
    public void releaseChunk(ByteBuffer chunk) {
        NIODispatcher.instance().getBufferCache().release(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getNextChunk() {
        Object object = this.writeLock;
        synchronized (object) {
            ByteBuffer rChunk;
            if (this.chunks.size() > 0) {
                rChunk = this.chunks.remove(0);
                rChunk.flip();
            } else if (this.activeChunk.position() > 0) {
                rChunk = this.activeChunk;
                rChunk.flip();
                this.allocateNewChunk();
            } else {
                rChunk = null;
            }
            return rChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfPendingChunks() {
        Object object = this.writeLock;
        synchronized (object) {
            int count = this.chunks.size();
            if (this.activeChunk.position() > 0) {
                ++count;
            }
            return count;
        }
    }

    Object writeLock() {
        return this.writeLock;
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.processor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        UDPSocketChannel uDPSocketChannel = this;
        synchronized (uDPSocketChannel) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        WriteObserver chain = this.writer;
        if (chain != null) {
            chain.shutdown();
        }
        this.writer = null;
    }

    @Override
    public void interestWrite(WriteObserver observer, boolean status) {
        if (this.isOpen()) {
            this.writer = observer;
            NIODispatcher.instance().interestWrite(this, status);
        }
    }

    @Override
    public boolean handleWrite() throws IOException {
        WriteObserver chain = this.writer;
        if (chain != null) {
            return chain.handleWrite();
        }
        return false;
    }

    @Override
    public void handleIOException(IOException iox) {
        throw new UnsupportedOperationException();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.processor.getSocketAddress();
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        this.processor.connect((InetSocketAddress)remote);
        return false;
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.processor.prepareOpenConnection();
    }

    @Override
    public boolean isConnected() {
        return this.processor.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.processor.isConnecting();
    }

    @Override
    public AbstractNBSocket socket() {
        return this.socket;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new IOException("unsupported");
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new IOException("unsupported");
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
    }

    void eventPending() {
        this.context.getTransportListener().eventPending();
    }

    @Override
    public boolean hasBufferedOutput() {
        return this.getNumberOfPendingChunks() > 0;
    }

    public String toString() {
        InetSocketAddress addr = this.getRemoteSocketAddress();
        if (addr == null) {
            return "[disconnected]";
        }
        return addr.toString();
    }
}

