/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class ScheduledFutureTask<V>
extends FutureTask<V>
implements ScheduledFuture<V> {
    private static final long NANO_ORIGIN = System.nanoTime();
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private final long sequenceNumber;
    private long time;

    ScheduledFutureTask(Runnable r, V result, long ns) {
        super(r, result);
        this.time = ns + this.now();
        this.sequenceNumber = sequencer.getAndIncrement();
    }

    ScheduledFutureTask(Callable<V> callable, long ns) {
        super(callable);
        this.time = ns + this.now();
        this.sequenceNumber = sequencer.getAndIncrement();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long d = unit.convert(this.time - this.now(), TimeUnit.NANOSECONDS);
        return d;
    }

    private final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        ScheduledFutureTask x = (ScheduledFutureTask)other;
        long diff = this.time - x.time;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        if (this.sequenceNumber < x.sequenceNumber) {
            return -1;
        }
        return 1;
    }
}

