/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.exceptions.DHTTimeoutException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.Result;
import org.limewire.mojito.settings.ContextSettings;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.mojito.util.ContactUtils;

public abstract class AbstractResponseHandler<V extends Result>
implements ResponseHandler,
DHTTask<V> {
    private static final Log LOG = LogFactory.getLog(AbstractResponseHandler.class);
    private int errors = 0;
    private long elapsedTime;
    private long timeout;
    private int maxErrors;
    protected final Context context;
    private volatile OnewayExchanger<V, ExecutionException> exchanger;
    protected long lastResponseTime = 0L;

    public AbstractResponseHandler(Context context) {
        this(context, -1L, -1);
    }

    public AbstractResponseHandler(Context context, long timeout) {
        this(context, timeout, -1);
    }

    public AbstractResponseHandler(Context context, int maxErrors) {
        this(context, -1L, maxErrors);
    }

    public AbstractResponseHandler(Context context, long timeout, int maxErrors) {
        this.context = context;
        this.setTimeout(timeout);
        this.setMaxErrors(maxErrors);
    }

    protected Object getLock() {
        OnewayExchanger<V, ExecutionException> lock = this.exchanger;
        if (lock == null) {
            throw new IllegalStateException("Lock is null");
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(OnewayExchanger<V, ExecutionException> exchanger) {
        if (exchanger == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Starting ResponseHandler without an OnewayExchanger");
            }
            exchanger = new OnewayExchanger(true);
        }
        this.exchanger = exchanger;
        Object object = this.getLock();
        synchronized (object) {
            if (this.isDone() || this.isCancelled()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Cannot start " + this + " because it's already done");
                }
                return;
            }
            try {
                this.start();
            }
            catch (DHTException t) {
                this.setException(t);
            }
        }
    }

    protected abstract void start() throws DHTException;

    @Override
    public void cancel() {
        this.exchanger.cancel();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout < 0L ? NetworkSettings.DEFAULT_TIMEOUT.getValue() : timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    protected long getElapsedTime() {
        return this.elapsedTime;
    }

    protected long getLastResponseTime() {
        return this.lastResponseTime;
    }

    protected void resetErrors() {
        this.errors = 0;
    }

    protected int getErrors() {
        return this.errors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors < 0 ? NetworkSettings.MAX_ERRORS.getValue() : maxErrors;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    @Override
    public long getWaitOnLockTimeout() {
        return ContextSettings.getWaitOnLock(this.getTimeout());
    }

    protected abstract void response(ResponseMessage var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(ResponseMessage response, long time) throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isCancelled() || this.isDone()) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received " + response + " from " + response.getContact() + " after " + this.getErrors() + " errors and a total time of " + this.getElapsedTime() + "ms");
            }
            this.elapsedTime += time;
            this.lastResponseTime = System.currentTimeMillis();
            this.response(response, time);
        }
    }

    protected abstract void timeout(KUID var1, SocketAddress var2, RequestMessage var3, long var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTimeout(KUID nodeId, SocketAddress dst, RequestMessage request, long time) throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isCancelled() || this.isDone()) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(request + " to " + ContactUtils.toString(nodeId, dst) + " failed after " + time + "ms");
            }
            this.elapsedTime += time;
            try {
                if (this.errors < this.maxErrors) {
                    this.resend(nodeId, dst, request);
                } else {
                    this.timeout(nodeId, dst, request, this.getElapsedTime());
                }
            }
            finally {
                ++this.errors;
            }
        }
    }

    protected void resend(KUID nodeId, SocketAddress dst, RequestMessage message) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Re-sending " + message + " to " + ContactUtils.toString(nodeId, dst));
        }
        this.context.getMessageDispatcher().send(nodeId, dst, message, this);
    }

    protected abstract void error(KUID var1, SocketAddress var2, RequestMessage var3, IOException var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(KUID nodeId, SocketAddress dst, RequestMessage message, IOException e) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isCancelled() || this.isDone()) {
                return;
            }
            if (LOG.isErrorEnabled()) {
                LOG.error("Sending a " + message + " to " + ContactUtils.toString(nodeId, dst) + " failed", e);
            }
            this.error(nodeId, dst, message, e);
        }
    }

    protected void tick() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTick() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isCancelled() || this.isDone()) {
                return;
            }
            this.tick();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.exchanger.isCancelled();
    }

    public boolean isDone() {
        return this.exchanger.isDone();
    }

    protected void setReturnValue(V value) {
        this.exchanger.setValue(value);
    }

    protected void setException(DHTException ex) {
        ExecutionException e = new ExecutionException(ex);
        e.setStackTrace(ex.getStackTrace());
        this.exchanger.setException(e);
    }

    protected void fireTimeoutException(KUID nodeId, SocketAddress address, RequestMessage request, long time) {
        this.setException(this.createTimeoutException(nodeId, address, request, time));
    }

    protected DHTTimeoutException createTimeoutException(KUID nodeId, SocketAddress address, RequestMessage request, long time) {
        return new DHTTimeoutException(nodeId, address, request, time);
    }
}

