/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.lifecycle;

import com.google.inject.Inject;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceScheduler;
import org.limewire.lifecycle.StagedRegisterBuilder;

class ServiceSchedulerImpl
implements ServiceScheduler {
    private final ServiceRegistry serviceRegistry;

    @Inject
    ServiceSchedulerImpl(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public StagedRegisterBuilder scheduleAtFixedRate(String commandName, Runnable command, long initialDelay, long period, TimeUnit unit, ScheduledExecutorService service) {
        return this.serviceRegistry.register(new ScheduledService(commandName, true, command, initialDelay, period, unit, service));
    }

    @Override
    public StagedRegisterBuilder scheduleWithFixedDelay(String commandName, Runnable command, long initialDelay, long delay, TimeUnit unit, ScheduledExecutorService service) {
        return this.serviceRegistry.register(new ScheduledService(commandName, false, command, initialDelay, delay, unit, service));
    }

    private static class ScheduledService
    implements Service {
        private final String commandName;
        private final boolean fixedRate;
        private final Runnable command;
        private final long initialDelay;
        private final long delayOrPeriod;
        private final TimeUnit timeUnit;
        private final ScheduledExecutorService service;
        private volatile ScheduledFuture<?> future;

        public ScheduledService(String commandName, boolean fixedRate, Runnable command, long initialDelay, long delayOrPeriod, TimeUnit timeUnit, ScheduledExecutorService service) {
            this.commandName = commandName;
            this.fixedRate = fixedRate;
            this.command = command;
            this.initialDelay = initialDelay;
            this.delayOrPeriod = delayOrPeriod;
            this.timeUnit = timeUnit;
            this.service = service;
        }

        @Override
        public String getServiceName() {
            return this.commandName;
        }

        @Override
        public void initialize() {
        }

        @Override
        public void start() {
            this.future = this.fixedRate ? this.service.scheduleAtFixedRate(this.command, this.initialDelay, this.delayOrPeriod, this.timeUnit) : this.service.scheduleWithFixedDelay(this.command, this.initialDelay, this.delayOrPeriod, this.timeUnit);
        }

        @Override
        public void stop() {
            ScheduledFuture<?> localFuture = this.future;
            if (localFuture != null) {
                localFuture.cancel(false);
                this.future = null;
            }
        }
    }
}

