/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.geocode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.limewire.geocode.GeoLocation;
import org.limewire.geocode.GeocodeInformation;
import org.limewire.geocode.Geocoder;
import org.limewire.inject.EagerSingleton;
import org.limewire.inject.MutableProvider;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Join;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.BlockingEvent;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ExternalIP;
import org.limewire.net.address.AddressEvent;

@EagerSingleton
public class CachedGeoLocationImpl
implements Provider<GeocodeInformation>,
Service {
    private static final Log LOG = LogFactory.getLog(CachedGeoLocationImpl.class);
    private final MutableProvider<Properties> settingGeo;
    private final Provider<Geocoder> geocoder;
    private volatile GeocodeInformation currentGeo = GeocodeInformation.EMPTY_GEO_INFO;
    private final Provider<byte[]> externalAddress;
    private final AtomicInteger ipAddressChangeCount = new AtomicInteger(0);

    @Inject
    public CachedGeoLocationImpl(@GeoLocation MutableProvider<Properties> settingLocation, Provider<Geocoder> geocoder, @ExternalIP Provider<byte[]> externalAddress) {
        this.settingGeo = settingLocation;
        this.geocoder = geocoder;
        this.externalAddress = externalAddress;
    }

    @Inject
    void register(ServiceRegistry serviceRegistry) {
        serviceRegistry.register(this);
    }

    @Inject
    void register(ListenerSupport<AddressEvent> addressListenerSupport) {
        addressListenerSupport.addListener(new EventListener<AddressEvent>(){

            @Override
            @BlockingEvent(queueName="fetch-geo-location")
            public void handleEvent(AddressEvent event) {
                if (CachedGeoLocationImpl.this.ipAddressChanged() && CachedGeoLocationImpl.this.ipAddressChangeCount.incrementAndGet() < 4) {
                    CachedGeoLocationImpl.this.fetchNewGeoCodeInformation();
                }
            }
        });
    }

    @Override
    public GeocodeInformation get() {
        return this.currentGeo;
    }

    private boolean ipAddressChanged() {
        String lastAddress = this.currentGeo.getProperty(GeocodeInformation.Property.Ip);
        if (lastAddress == null) {
            LOG.debug("no address in saved geolocation");
            return false;
        }
        byte[] currentAddress = this.externalAddress.get();
        if (!NetworkUtils.isValidAddress(currentAddress)) {
            LOG.debug("external address not available yet");
            return false;
        }
        try {
            byte[] lastIp = InetAddress.getByName(lastAddress).getAddress();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("comparing addresses: {0} and {1}", (Object)lastAddress, (Object)NetworkUtils.ip2string(currentAddress));
            }
            if (!NetworkUtils.isCloseIP(currentAddress, lastIp)) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to get host by name", e);
        }
        return false;
    }

    @Override
    public void initialize() {
        this.currentGeo = GeocodeInformation.fromProperties((Properties)this.settingGeo.get());
        LOG.debugf("geo location from settings: {0}", (Object)this.currentGeo);
        if (this.currentGeo.getProperty(GeocodeInformation.Property.Ip) == null) {
            this.currentGeo = GeocodeInformation.EMPTY_GEO_INFO;
        }
    }

    @Override
    public String getServiceName() {
        return "GeocodeLocation";
    }

    private void fetchNewGeoCodeInformation() {
        LOG.debug("fetching new geo location");
        Geocoder coder = this.geocoder.get();
        this.currentGeo = coder.getGeocodeInformation();
        this.settingGeo.set(this.currentGeo.toProperties());
        LOG.debugf("new geolocation: {0}", (Object)this.currentGeo);
    }

    @Override
    @Asynchronous(join=Join.NONE)
    public void start() {
        if (this.currentGeo.isEmpty()) {
            this.fetchNewGeoCodeInformation();
        }
    }

    @Override
    public void stop() {
    }
}

