/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.mozilla;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import com.limegroup.mozilla.MozillaDownload;
import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.limewire.core.api.mozilla.LimeMozillaDownloadManagerListener;
import org.limewire.core.api.mozilla.LimeMozillaDownloadProgressListener;
import org.limewire.core.impl.mozilla.SimpleBandwidthTracker;
import org.limewire.core.impl.mozilla.XPComUtility;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.Objects;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDownload;
import org.mozilla.interfaces.nsIDownloadManager;
import org.mozilla.interfaces.nsIDownloadProgressListener;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class LimeMozillaDownloadProgressListenerImpl
implements nsIDownloadProgressListener,
MozillaDownload,
LimeMozillaDownloadProgressListener {
    private static final Log LOG = LogFactory.getLog(LimeMozillaDownloadProgressListenerImpl.class);
    private final long downloadId;
    private final AtomicInteger state;
    private final AtomicLong totalProgress;
    private final SimpleBandwidthTracker down;
    private final File incompleteFile;
    private final AtomicLong contentLength;
    private final LimeMozillaDownloadManagerListener manager;
    private final EventListenerList<DownloadStateEvent> listeners;
    private final BlockingQueue<DownloadStateEvent> statusEvents;
    private final ScheduledExecutorService backgroundExecutor;
    private final XPComUtility xpComUtility;
    private CoreDownloader downloader;

    public LimeMozillaDownloadProgressListenerImpl(LimeMozillaDownloadManagerListener manager, ScheduledExecutorService backgroundExecutor, nsIDownload download, XPComUtility xpComUtility) {
        this.manager = Objects.nonNull(manager, "manager");
        this.backgroundExecutor = Objects.nonNull(backgroundExecutor, "backgroundExecutor");
        Objects.nonNull(download, "download");
        this.listeners = new EventListenerList();
        this.downloadId = download.getId();
        this.state = new AtomicInteger();
        this.statusEvents = new LinkedBlockingQueue<DownloadStateEvent>();
        this.totalProgress = new AtomicLong();
        this.down = new SimpleBandwidthTracker();
        this.incompleteFile = new File(download.getTargetFile().getPath());
        this.contentLength = new AtomicLong(download.getSize());
        this.xpComUtility = xpComUtility;
    }

    @Override
    public synchronized void onDownloadStateChange(short state, nsIDownload download) {
        if (this.downloadId == download.getId()) {
            this.changeState(state);
        }
    }

    public void init(CoreDownloader coreDownloader, short state) {
        this.downloader = coreDownloader;
        this.changeState(state);
    }

    private synchronized void changeState(short state) {
        if (state != this.state.get()) {
            this.state.set(state);
            Downloader.DownloadState downloadStatus = this.getDownloadStatus();
            DownloadStateEvent downloadStatusEvent = new DownloadStateEvent(this.downloader, downloadStatus);
            this.statusEvents.add(downloadStatusEvent);
            this.backgroundExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EventListenerList eventListenerList = LimeMozillaDownloadProgressListenerImpl.this.listeners;
                    synchronized (eventListenerList) {
                        DownloadStateEvent event = (DownloadStateEvent)LimeMozillaDownloadProgressListenerImpl.this.statusEvents.poll();
                        if (event != null) {
                            LimeMozillaDownloadProgressListenerImpl.this.listeners.broadcast(event);
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized void onProgressChange(nsIWebProgress webProgress, nsIRequest request, long curSelfProgress, long maxSelfProgress, long curTotalProgress, long maxTotalProgress, nsIDownload download) {
        if (this.downloadId == download.getId()) {
            int diff = (int)(curTotalProgress - this.totalProgress.longValue());
            this.down.count(diff);
            if (!this.isPaused()) {
                short state = download.getState();
                this.changeState(state);
            }
            this.totalProgress.set(curTotalProgress);
            this.contentLength.set(download.getSize());
        }
    }

    @Override
    public synchronized void onSecurityChange(nsIWebProgress webProgress, nsIRequest request, long state, nsIDownload download) {
    }

    @Override
    public synchronized void onStateChange(nsIWebProgress webProgress, nsIRequest request, long stateFlags, long status, nsIDownload download) {
        if (this.downloadId == download.getId()) {
            this.changeState(download.getState());
            if (this.state.get() == 1) {
                this.contentLength.set(download.getSize());
                this.totalProgress.set(this.contentLength.get());
            }
        }
    }

    @Override
    public void setDocument(nsIDOMDocument document) {
    }

    @Override
    public nsIDOMDocument getDocument() {
        return null;
    }

    @Override
    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface(this, uuid);
    }

    @Override
    public long getDownloadId() {
        return this.downloadId;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.down.getAverageBandwidth();
    }

    @Override
    public synchronized float getMeasuredBandwidth() {
        try {
            return this.down.getMeasuredBandwidth();
        }
        catch (InsufficientDataException e) {
            return 0.0f;
        }
    }

    @Override
    public synchronized void measureBandwidth() {
        this.down.measureBandwidth();
    }

    @Override
    public synchronized boolean isCompleted() {
        return this.state.get() == 1;
    }

    @Override
    public synchronized boolean isPaused() {
        int myState = this.state.get();
        boolean paused = myState == 4;
        return paused;
    }

    @Override
    public synchronized Downloader.DownloadState getDownloadStatus() {
        switch (this.state.get()) {
            case 7: {
                return Downloader.DownloadState.RESUMING;
            }
            case 0: {
                return Downloader.DownloadState.DOWNLOADING;
            }
            case 1: {
                return Downloader.DownloadState.COMPLETE;
            }
            case 5: {
                return Downloader.DownloadState.QUEUED;
            }
            case 4: {
                return Downloader.DownloadState.PAUSED;
            }
            case -1: {
                return Downloader.DownloadState.PAUSED;
            }
            case 3: {
                return Downloader.DownloadState.ABORTED;
            }
            case 6: {
                return Downloader.DownloadState.INVALID;
            }
            case 9: {
                return Downloader.DownloadState.INVALID;
            }
            case 8: {
                return Downloader.DownloadState.INVALID;
            }
            case 2: {
                return Downloader.DownloadState.INVALID;
            }
        }
        throw new IllegalStateException("unknown mozilla state");
    }

    @Override
    public File getIncompleteFile() {
        return this.incompleteFile;
    }

    @Override
    public synchronized boolean isInactive() {
        boolean inactive = this.state.get() != 0 && this.state.get() != 7;
        return inactive;
    }

    @Override
    public synchronized long getAmountDownloaded() {
        return this.totalProgress.get();
    }

    @Override
    public synchronized long getAmountPending() {
        return this.getContentLength() - this.getAmountDownloaded();
    }

    @Override
    public synchronized long getContentLength() {
        return this.contentLength.get();
    }

    @Override
    public void cancelDownload() {
        MozillaExecutor.mozSyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!LimeMozillaDownloadProgressListenerImpl.this.isCancelled()) {
                    try {
                        LimeMozillaDownloadProgressListenerImpl limeMozillaDownloadProgressListenerImpl = LimeMozillaDownloadProgressListenerImpl.this;
                        synchronized (limeMozillaDownloadProgressListenerImpl) {
                            LimeMozillaDownloadProgressListenerImpl.this.getDownloadManager().cancelDownload(LimeMozillaDownloadProgressListenerImpl.this.downloadId);
                        }
                    }
                    catch (XPCOMException e) {
                        LOG.debug(e.getMessage(), e);
                    }
                }
            }
        });
    }

    @Override
    public void pauseDownload() {
        MozillaExecutor.mozSyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LimeMozillaDownloadProgressListenerImpl limeMozillaDownloadProgressListenerImpl = LimeMozillaDownloadProgressListenerImpl.this;
                synchronized (limeMozillaDownloadProgressListenerImpl) {
                    if (!LimeMozillaDownloadProgressListenerImpl.this.isPaused()) {
                        try {
                            LimeMozillaDownloadProgressListenerImpl.this.getDownloadManager().pauseDownload(LimeMozillaDownloadProgressListenerImpl.this.downloadId);
                        }
                        catch (XPCOMException e) {
                            LOG.debug(e.getMessage(), e);
                        }
                        LimeMozillaDownloadProgressListenerImpl.this.changeState((short)4);
                    }
                }
            }
        });
    }

    @Override
    public void removeDownload() {
        MozillaExecutor.mozSyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LimeMozillaDownloadProgressListenerImpl limeMozillaDownloadProgressListenerImpl = LimeMozillaDownloadProgressListenerImpl.this;
                synchronized (limeMozillaDownloadProgressListenerImpl) {
                    LimeMozillaDownloadProgressListenerImpl.this.manager.removeListener(LimeMozillaDownloadProgressListenerImpl.this);
                    if (LimeMozillaDownloadProgressListenerImpl.this.state.get() != 1) {
                        LimeMozillaDownloadProgressListenerImpl.this.changeState((short)3);
                    }
                }
            }
        });
    }

    @Override
    public void resumeDownload() {
        MozillaExecutor.mozSyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LimeMozillaDownloadProgressListenerImpl limeMozillaDownloadProgressListenerImpl = LimeMozillaDownloadProgressListenerImpl.this;
                synchronized (limeMozillaDownloadProgressListenerImpl) {
                    if (LimeMozillaDownloadProgressListenerImpl.this.isPaused() || LimeMozillaDownloadProgressListenerImpl.this.isQueued()) {
                        try {
                            LimeMozillaDownloadProgressListenerImpl.this.getDownloadManager().resumeDownload(LimeMozillaDownloadProgressListenerImpl.this.downloadId);
                        }
                        catch (XPCOMException e) {
                            LOG.debug(e.getMessage(), e);
                        }
                    }
                }
            }
        });
    }

    private nsIDownloadManager getDownloadManager() {
        nsIDownloadManager downloadManager = this.xpComUtility.getServiceProxy("@mozilla.org/download-manager;1", nsIDownloadManager.class);
        return downloadManager;
    }

    @Override
    public void addListener(EventListener<DownloadStateEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<DownloadStateEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    @Override
    public synchronized boolean isQueued() {
        boolean queued = this.state.get() == 5;
        return queued;
    }

    @Override
    public synchronized boolean isCancelled() {
        Downloader.DownloadState downloadStatus = this.getDownloadStatus();
        boolean cancelled = downloadStatus == Downloader.DownloadState.ABORTED || downloadStatus == Downloader.DownloadState.INVALID;
        return cancelled;
    }

    @Override
    public synchronized void setDiskError() {
        this.state.set(8);
    }
}

