/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.browser.MagnetOptions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.core.api.library.FileItem;
import org.limewire.core.api.library.MagnetLinkFactory;
import org.limewire.core.impl.library.CoreLocalFileItem;

@Singleton
public class MagnetLinkFactoryImpl
implements MagnetLinkFactory {
    private NetworkManager networkManager;
    private ApplicationServices applicationServices;

    @Inject
    public MagnetLinkFactoryImpl(NetworkManager networkManager, ApplicationServices applicationServices) {
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
    }

    @Override
    public String createMagnetLink(FileItem fileItem) {
        if (fileItem instanceof CoreLocalFileItem) {
            return this.createMagnetLink((CoreLocalFileItem)fileItem);
        }
        throw new IllegalArgumentException("FileItem must be instance of CoreLocalFileItem or CoreRemoteFileItem: " + fileItem);
    }

    private String createMagnetLink(CoreLocalFileItem fileItem) {
        return MagnetOptions.createMagnet(fileItem.getFileDetails(), this.getInetSocketAddress(), this.applicationServices.getMyGUID()).toExternalForm();
    }

    private InetSocketAddress getInetSocketAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByAddress(this.networkManager.getAddress()), this.networkManager.getPort());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

