/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.friend;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.limewire.core.settings.SearchSettings;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.AuthToken;
import org.limewire.friend.api.feature.AuthTokenFeature;
import org.limewire.friend.impl.address.FriendAddress;
import org.limewire.friend.impl.address.FriendAddressResolver;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.net.address.AddressFactory;
import org.limewire.security.SecureMessage;
import org.limewire.util.Objects;
import org.limewire.util.StringUtils;

public class FriendRemoteFileDesc
implements RemoteFileDesc {
    static final String TYPE = "XMPPRFD";
    private final FriendAddress address;
    private final long index;
    private final String filename;
    private final long size;
    private final byte[] clientGUID;
    private final int speed;
    private final int quality;
    private final LimeXMLDocument xmlDoc;
    private final Set<URN> urns;
    private final String vendor;
    private final long createTime;
    private final AddressFactory addressFactory;
    private boolean http11;
    private final FriendAddressResolver addressResolver;
    private int hashCode = -1;
    private float spamRating = 0.0f;

    public FriendRemoteFileDesc(FriendAddress address, long index, String filename, long size, byte[] clientGUID, int speed, int quality, LimeXMLDocument xmlDoc, Set<? extends URN> urns, String vendor, long createTime, boolean http11, AddressFactory addressFactory, FriendAddressResolver addressResolver) {
        this.address = address;
        this.index = index;
        this.filename = filename;
        this.size = size;
        this.clientGUID = Objects.nonNull(clientGUID, "clientGUID");
        this.speed = speed;
        this.quality = quality;
        this.xmlDoc = xmlDoc;
        this.urns = Collections.unmodifiableSet(urns);
        this.vendor = vendor;
        this.createTime = createTime;
        this.http11 = http11;
        this.addressResolver = addressResolver;
        this.addressFactory = addressFactory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FriendRemoteFileDesc)) {
            return false;
        }
        FriendRemoteFileDesc other = (FriendRemoteFileDesc)obj;
        if (!Arrays.equals(this.clientGUID, other.clientGUID)) {
            return false;
        }
        if (!this.address.equals(other.address)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return ((Object)this.urns).equals(other.urns);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == -1) {
            h = this.address.hashCode();
            h = 31 * h + (int)this.size;
            h = 31 * h + new GUID(this.clientGUID).hashCode();
            this.hashCode = h = 31 * h + ((Object)this.urns).hashCode();
        }
        return h;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public Credentials getCredentials() {
        FriendPresence presence = this.addressResolver.getPresence(this.address);
        if (presence == null) {
            return null;
        }
        AuthTokenFeature authTokenFeature = (AuthTokenFeature)presence.getFeature(AuthTokenFeature.ID);
        if (authTokenFeature == null) {
            return null;
        }
        return new UsernamePasswordCredentials(presence.getFriend().getNetwork().getCanonicalizedLocalID(), StringUtils.toUTF8String(((AuthToken)authTokenFeature.getFeature()).getToken()));
    }

    @Override
    public SecureMessage.Status getSecureStatus() {
        return SecureMessage.Status.INSECURE;
    }

    @Override
    public float getSpamRating() {
        return this.spamRating;
    }

    @Override
    public String getUrlPath() {
        URN sha1Urn = this.getSHA1Urn();
        FriendPresence presence = this.addressResolver.getPresence(this.address);
        if (presence == null) {
            return "/uri-res/N2R?" + sha1Urn.httpStringValue();
        }
        try {
            return "/friend/download/" + URLEncoder.encode(presence.getFriend().getNetwork().getCanonicalizedLocalID(), "UTF-8") + "/uri-res/N2R?" + sha1Urn.httpStringValue();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isAltLocCapable() {
        return false;
    }

    @Override
    public boolean isFromAlternateLocation() {
        return false;
    }

    @Override
    public boolean isMe(byte[] myClientGUID) {
        return Arrays.equals(this.clientGUID, myClientGUID);
    }

    @Override
    public boolean isSpam() {
        return this.getSpamRating() >= SearchSettings.FILTER_SPAM_RESULTS.getValue();
    }

    @Override
    public void setSecureStatus(SecureMessage.Status secureStatus) {
    }

    @Override
    public void setSpamRating(float rating) {
        this.spamRating = rating;
    }

    @Override
    public RemoteHostMemento toMemento() {
        return new RemoteHostMemento(this.address, this.filename, this.index, this.clientGUID, this.speed, this.size, this.quality, this.isReplyToMulticast(), this.getXml(), this.urns, this.isBrowseHostEnabled(), this.vendor, this.http11, TYPE, this.addressFactory);
    }

    private String getXml() {
        return this.xmlDoc != null ? this.xmlDoc.getXMLString() : null;
    }

    @Override
    public long getCreationTime() {
        return this.createTime;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public URN getSHA1Urn() {
        URN sha1Urn = UrnSet.getSha1(this.urns);
        if (sha1Urn == null) {
            throw new IllegalArgumentException(this.urns + " should have sha1");
        }
        return sha1Urn;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public Set<URN> getUrns() {
        return this.urns;
    }

    @Override
    public LimeXMLDocument getXMLDocument() {
        return this.xmlDoc;
    }

    @Override
    public byte[] getClientGUID() {
        return this.clientGUID;
    }

    @Override
    public byte[] getQueryGUID() {
        return null;
    }

    @Override
    public int getQuality() {
        return this.quality;
    }

    @Override
    public int getSpeed() {
        return this.speed;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public boolean isBrowseHostEnabled() {
        return true;
    }

    @Override
    public boolean isHTTP11() {
        return this.http11;
    }

    @Override
    public boolean isReplyToMulticast() {
        return false;
    }

    @Override
    public void setHTTP11(boolean http11) {
        this.http11 = http11;
    }

    public String toString() {
        return StringUtils.toString(this, this.filename, this.address);
    }

    @Override
    public float getRelevance(String query) {
        return QueryUtils.calculateRelevance(this.filename, this.xmlDoc, query);
    }
}

