/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.download;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import com.limegroup.gnutella.downloader.StoreDownloader;
import com.limegroup.gnutella.malware.VirusDefinitionDownloader;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.limewire.concurrent.ManagedThread;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadPiecesInfo;
import org.limewire.core.api.download.DownloadPropertyKey;
import org.limewire.core.api.download.DownloadSourceInfo;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.impl.RemoteHostRFD;
import org.limewire.core.impl.download.QueueTimeCalculator;
import org.limewire.core.impl.friend.GnutellaPresence;
import org.limewire.core.impl.util.FilePropertyKeyPopulator;
import org.limewire.friend.api.FriendManager;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.impl.address.FriendAddress;
import org.limewire.io.Address;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingSafePropertyChangeSupport;
import org.limewire.util.FileUtils;

class CoreDownloadItem
implements DownloadItem,
Downloader.ScanListener {
    private final PropertyChangeSupport support = new SwingSafePropertyChangeSupport(this);
    private final Downloader downloader;
    private volatile int hashCode = 0;
    private volatile long cachedSize;
    private volatile boolean cancelled = false;
    private volatile boolean scanningFragment = false;
    private final QueueTimeCalculator queueTimeCalculator;
    private final FriendManager friendManager;
    private final DownloadItem.DownloadItemType downloadItemType;
    private final CategoryManager categoryManager;

    @Inject
    public CoreDownloadItem(@Assisted Downloader downloader, @Assisted QueueTimeCalculator queueTimeCalculator, FriendManager friendManager, CategoryManager categoryManager) {
        this.downloader = downloader;
        this.queueTimeCalculator = queueTimeCalculator;
        this.friendManager = friendManager;
        this.categoryManager = categoryManager;
        this.downloadItemType = downloader instanceof BTDownloader ? DownloadItem.DownloadItemType.BITTORRENT : (downloader instanceof VirusDefinitionDownloader ? DownloadItem.DownloadItemType.ANTIVIRUS : DownloadItem.DownloadItemType.GNUTELLA);
        downloader.addListener(new EventListener<DownloadStateEvent>(){

            @Override
            public void handleEvent(DownloadStateEvent event) {
                CoreDownloadItem.this.fireDataChanged();
                if (event.getType() == Downloader.DownloadState.ABORTED) {
                    CoreDownloadItem.this.downloader.deleteIncompleteFiles();
                }
            }
        });
    }

    @Override
    public DownloadItem.DownloadItemType getDownloadItemType() {
        return this.downloadItemType;
    }

    void fireDataChanged() {
        this.cachedSize = this.downloader.getAmountRead();
        this.support.firePropertyChange("state", null, (Object)this.getState());
    }

    private Downloader getDownloader() {
        return this.downloader;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.support.firePropertyChange("state", null, (Object)this.getState());
        new ManagedThread(new Runnable(){

            @Override
            public void run() {
                CoreDownloadItem.this.downloader.stop();
                CoreDownloadItem.this.downloader.deleteIncompleteFiles();
            }
        }, "CoreDownloadItem.cancel").start();
    }

    @Override
    public Category getCategory() {
        File file = this.downloader.getFile();
        if (file != null) {
            return this.categoryManager.getCategoryForFile(file);
        }
        return this.categoryManager.getCategoryForFile(this.downloader.getSaveFile());
    }

    @Override
    public long getCurrentSize() {
        DownloadState state = this.getState();
        if (state == DownloadState.SCANNING || state.isFinished()) {
            return this.getTotalSize();
        }
        return this.cachedSize;
    }

    @Override
    public long getAmountVerified() {
        return this.downloader.getAmountVerified();
    }

    @Override
    public long getAmountLost() {
        return this.downloader.getAmountLost();
    }

    @Override
    public List<Address> getSources() {
        return this.downloader.getSourcesAsAddresses();
    }

    @Override
    public List<DownloadSourceInfo> getSourcesDetails() {
        return this.downloader.getSourcesDetails();
    }

    @Override
    public DownloadPiecesInfo getPiecesInfo() {
        return this.downloader.getPieceInfo();
    }

    @Override
    public Collection<RemoteHost> getRemoteHosts() {
        List<RemoteFileDesc> remoteFiles = this.downloader.getRemoteFileDescs();
        if (remoteFiles.size() > 0) {
            ArrayList<RemoteHost> remoteHosts = new ArrayList<RemoteHost>(remoteFiles.size());
            for (RemoteFileDesc rfd : remoteFiles) {
                remoteHosts.add(new RemoteHostRFD(rfd, this.getFriendPresence(rfd)));
            }
            return remoteHosts;
        }
        return Collections.emptyList();
    }

    private FriendPresence getFriendPresence(RemoteFileDesc rfd) {
        FriendPresence friendPresence = null;
        if (rfd.getAddress() instanceof FriendAddress) {
            friendPresence = this.friendManager.getMostRelevantFriendPresence(((FriendAddress)rfd.getAddress()).getId());
        }
        if (friendPresence == null) {
            friendPresence = new GnutellaPresence.GnutellaPresenceWithGuid(rfd.getAddress(), rfd.getClientGUID());
        }
        return friendPresence;
    }

    @Override
    public int getDownloadSourceCount() {
        return this.downloader.getNumHosts();
    }

    @Override
    public int getPercentComplete() {
        DownloadState state = this.getState();
        if (state == DownloadState.FINISHING || state == DownloadState.SCANNING || state.isFinished()) {
            return 100;
        }
        if (this.getTotalSize() == 0L) {
            return 0;
        }
        return (int)(100L * this.getCurrentSize() / this.getTotalSize());
    }

    @Override
    public long getRemainingDownloadTime() {
        double remaining = (double)(this.getTotalSize() - this.getCurrentSize()) / 1024.0;
        float speed = this.getDownloadSpeed();
        if (speed > 0.0f) {
            return (long)(remaining / (double)speed);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public float getDownloadSpeed() {
        try {
            return this.downloader.getMeasuredBandwidth();
        }
        catch (InsufficientDataException e) {
            return 0.0f;
        }
    }

    @Override
    public DownloadState getState() {
        if (this.cancelled) {
            return DownloadState.CANCELLED;
        }
        if (this.scanningFragment) {
            return DownloadState.SCANNING_FRAGMENT;
        }
        return this.convertState(this.downloader.getState());
    }

    @Override
    public String getTitle() {
        return this.downloader.getSaveFile().getName();
    }

    @Override
    public long getTotalSize() {
        return this.downloader.getContentLength();
    }

    @Override
    public void pause() {
        this.downloader.pause();
    }

    @Override
    public void resume() {
        this.downloader.resume();
    }

    @Override
    public int getRemoteQueuePosition() {
        if (this.downloader.getState() == Downloader.DownloadState.REMOTE_QUEUED) {
            return this.downloader.getQueuePosition();
        }
        return -1;
    }

    private DownloadState convertState(Downloader.DownloadState state) {
        switch (state) {
            case RESUMING: {
                return DownloadState.RESUMING;
            }
            case SAVING: 
            case HASHING: {
                if (this.getTotalSize() > 0L) {
                    return DownloadState.FINISHING;
                }
                return DownloadState.DONE;
            }
            case DOWNLOADING: {
                return DownloadState.DOWNLOADING;
            }
            case CONNECTING: 
            case INITIALIZING: 
            case WAITING_FOR_CONNECTIONS: {
                return DownloadState.CONNECTING;
            }
            case COMPLETE: {
                return DownloadState.DONE;
            }
            case REMOTE_QUEUED: 
            case BUSY: {
                return DownloadState.REMOTE_QUEUED;
            }
            case QUEUED: {
                return DownloadState.LOCAL_QUEUED;
            }
            case PAUSED: {
                return DownloadState.PAUSED;
            }
            case WAITING_FOR_GNET_RESULTS: 
            case ITERATIVE_GUESSING: 
            case QUERYING_DHT: {
                return DownloadState.TRYING_AGAIN;
            }
            case WAITING_FOR_USER: 
            case GAVE_UP: {
                return DownloadState.STALLED;
            }
            case ABORTED: {
                return DownloadState.CANCELLED;
            }
            case DISK_PROBLEM: 
            case CORRUPT_FILE: 
            case INVALID: 
            case UNABLE_TO_CONNECT: {
                return DownloadState.ERROR;
            }
            case DANGEROUS: {
                return DownloadState.DANGEROUS;
            }
            case SCANNING: {
                return DownloadState.SCANNING;
            }
            case THREAT_FOUND: {
                return DownloadState.THREAT_FOUND;
            }
            case SCAN_FAILED: {
                return DownloadState.SCAN_FAILED;
            }
            case SCAN_FAILED_DOWNLOADING_DEFINITIONS: {
                return DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS;
            }
        }
        throw new IllegalStateException("Unknown State: " + (Object)((Object)state));
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CoreDownloadItem)) {
            return false;
        }
        return this.getDownloader().equals(((CoreDownloadItem)o).getDownloader());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * this.getDownloader().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public DownloadItem.ErrorState getErrorState() {
        switch (this.downloader.getState()) {
            case CORRUPT_FILE: {
                return DownloadItem.ErrorState.CORRUPT_FILE;
            }
            case DISK_PROBLEM: {
                return DownloadItem.ErrorState.DISK_PROBLEM;
            }
            case INVALID: {
                return DownloadItem.ErrorState.INVALID;
            }
            case UNABLE_TO_CONNECT: {
                return DownloadItem.ErrorState.UNABLE_TO_CONNECT;
            }
        }
        return DownloadItem.ErrorState.NONE;
    }

    @Override
    public boolean isTryAgainEnabled() {
        return DownloadItem.DownloadItemType.BITTORRENT == this.downloadItemType || this.downloader.getState() == Downloader.DownloadState.WAITING_FOR_USER;
    }

    @Override
    public long getRemainingTimeInState() {
        long remaining = this.downloader.getRemainingStateTime();
        switch (this.downloader.getState()) {
            case QUEUED: {
                remaining = this.queueTimeCalculator.getRemainingQueueTime(this);
                break;
            }
            case QUERYING_DHT: {
                remaining = Long.MAX_VALUE;
            }
        }
        if (remaining == Integer.MAX_VALUE) {
            remaining = Long.MAX_VALUE;
        }
        return remaining;
    }

    @Override
    public int getLocalQueuePriority() {
        return this.downloader.getInactivePriority();
    }

    @Override
    public boolean isLaunchable() {
        return this.downloader.isLaunchable();
    }

    @Override
    public File getDownloadingFile() {
        return this.downloader.getFile();
    }

    @Override
    public File getLaunchableFile() {
        return this.downloader.getDownloadFragment(this);
    }

    @Override
    public void scanStarted() {
        this.scanningFragment = true;
    }

    @Override
    public void scanStopped() {
        this.scanningFragment = false;
    }

    @Override
    public org.limewire.core.api.URN getUrn() {
        URN urn = this.downloader.getSha1Urn();
        return urn;
    }

    @Override
    public String getFileName() {
        return this.downloader.getSaveFile().getName();
    }

    @Override
    public void setSaveFile(File saveFile, boolean overwrite) throws DownloadException {
        File saveDir = null;
        String fileName = null;
        if (saveFile != null) {
            if (saveFile.isDirectory()) {
                saveDir = saveFile;
                fileName = this.getFileName();
            } else {
                saveDir = saveFile.getParentFile();
                fileName = saveFile.getName();
            }
        }
        this.downloader.setSaveFile(saveDir, fileName, overwrite);
    }

    @Override
    public File getSaveFile() {
        return this.downloader.getSaveFile();
    }

    @Override
    public Object getProperty(FilePropertyKey property) {
        switch (property) {
            case NAME: {
                return FileUtils.getFilenameNoExtension(this.getFileName());
            }
            case DATE_CREATED: {
                File file = this.downloader.getFile();
                long ct = -1L;
                if (file != null) {
                    ct = file.lastModified();
                }
                return ct == -1L ? null : Long.valueOf(ct);
            }
            case FILE_SIZE: {
                return this.getTotalSize();
            }
        }
        LimeXMLDocument doc = (LimeXMLDocument)this.downloader.getAttribute("LimeXMLDocument");
        if (doc != null) {
            Category category = this.categoryManager.getCategoryForFile(this.getSaveFile());
            return FilePropertyKeyPopulator.get(category, property, doc);
        }
        return null;
    }

    @Override
    public String getPropertyString(FilePropertyKey key) {
        Object value = this.getProperty(key);
        if (value != null) {
            String stringValue = value.toString();
            return stringValue;
        }
        return null;
    }

    @Override
    public Date getStartDate() {
        return (Date)this.downloader.getAttribute("limewire.download.startDate");
    }

    @Override
    public boolean isStoreDownload() {
        return this.downloader instanceof StoreDownloader;
    }

    @Override
    public boolean isRelocatable() {
        return this.downloader.isRelocatable();
    }

    @Override
    public Collection<File> getCompleteFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.downloader instanceof BTDownloader) {
            BTDownloader btDownloader = (BTDownloader)this.downloader;
            files.addAll(btDownloader.getCompleteFiles());
        } else {
            files.add(this.downloader.getSaveFile());
        }
        return files;
    }

    @Override
    public Object getDownloadProperty(DownloadPropertyKey key) {
        if (key == DownloadPropertyKey.TORRENT && DownloadItem.DownloadItemType.BITTORRENT == this.downloadItemType) {
            BTDownloader btDownloader = (BTDownloader)this.downloader;
            return btDownloader.getTorrent();
        }
        return null;
    }

    static interface Factory {
        public CoreDownloadItem create(Downloader var1, QueueTimeCalculator var2);
    }
}

