/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.api.search;

import java.util.EnumMap;
import org.limewire.core.api.Category;

public enum SearchCategory {
    ALL(null, 0),
    AUDIO(Category.AUDIO, 1),
    VIDEO(Category.VIDEO, 2),
    IMAGE(Category.IMAGE, 3),
    DOCUMENT(Category.DOCUMENT, 4),
    PROGRAM(Category.PROGRAM, 5),
    OTHER(Category.OTHER, 6);

    private static final EnumMap<Category, SearchCategory> perCategory;
    private final Category category;
    private final int id;

    private SearchCategory(Category category, int id) {
        this.id = id;
        this.category = category;
    }

    public static SearchCategory forCategory(Category category) {
        return perCategory.get((Object)category);
    }

    public static SearchCategory forId(Integer id) {
        for (SearchCategory category : SearchCategory.values()) {
            if (!id.equals(category.id)) continue;
            return category;
        }
        return ALL;
    }

    public int getId() {
        return this.id;
    }

    public Category getCategory() {
        return this.category;
    }

    static {
        perCategory = new EnumMap(Category.class);
        for (SearchCategory searchCategory : SearchCategory.values()) {
            if (searchCategory.category == null) continue;
            perCategory.put(searchCategory.category, searchCategory);
        }
    }
}

