/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class LIFOSet<E>
implements Set<E> {
    private final Set<E> set;
    private final List<E> list;

    public LIFOSet() {
        this(50, 0.75f);
    }

    public LIFOSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LIFOSet(int initialCapacity, float loadFactor) {
        this.set = new HashSet(initialCapacity, loadFactor);
        this.list = new ArrayList(initialCapacity);
    }

    @Override
    public boolean add(E o) {
        if (this.set.add(o)) {
            this.list.add(o);
            return true;
        }
        this.list.remove(o);
        this.list.add(o);
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ret = false;
        for (E e : c) {
            ret |= this.add(e);
        }
        return ret;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new LIFOSetIterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.set.remove(o)) {
            this.list.remove(o);
            return true;
        }
        return false;
    }

    protected boolean removeEldest() {
        if (this.list.isEmpty()) {
            return false;
        }
        return this.remove(0);
    }

    protected boolean removeNewest() {
        if (this.list.isEmpty()) {
            return false;
        }
        return this.remove(this.list.size() - 1);
    }

    protected boolean remove(int index) {
        return this.set.remove(this.list.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.list.removeAll(c);
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.list.retainAll(c);
        return this.set.retainAll(c);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> reverse = new ArrayList<E>(this.list);
        Collections.reverse(reverse);
        return reverse.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<E> reverse = new ArrayList<E>(this.list);
        Collections.reverse(reverse);
        return reverse.toArray(a);
    }

    public String toString() {
        ArrayList<E> reverse = new ArrayList<E>(this.list);
        Collections.reverse(reverse);
        return ((Object)reverse).toString();
    }

    private class LIFOSetIterator
    implements Iterator<E> {
        private E current;
        private int index = 0;

        public LIFOSetIterator() {
            this.index = LIFOSet.this.list.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public E next() {
            if (this.index < 0) {
                throw new NoSuchElementException();
            }
            this.current = LIFOSet.this.list.get(this.index);
            --this.index;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.index == LIFOSet.this.list.size() - 1) {
                throw new IllegalStateException();
            }
            LIFOSet.this.set.remove(this.current);
            Object removed = LIFOSet.this.list.remove(this.index + 1);
            if (removed != this.current) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
        }
    }
}

