/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.UnmodifiableIterator;

public class DoublyLinkedList<E>
implements Iterable<ListElement<E>> {
    private ListElement<E> start = new ListElement<Object>(null);
    private ListElement<E> last = new ListElement<Object>(null);

    public DoublyLinkedList() {
        this.start.next = this.last;
        this.last.prev = this.start;
    }

    public ListElement<E> addLast(E value) {
        ListElement<E> element = new ListElement<E>(value);
        element.prev = this.last.prev;
        element.next = this.last;
        element.prev.next = element;
        this.last.prev = element;
        return element;
    }

    public ListElement<E> removeFirst() {
        if (this.start.next == this.last) {
            return null;
        }
        ListElement removed = this.start.next;
        this.start.next = this.start.next.next;
        this.start.next.prev = this.start;
        return removed;
    }

    public void remove(ListElement<E> element) {
        if (element == null || element.prev == null || element.next == null) {
            return;
        }
        if (element == this.start || element == this.last) {
            return;
        }
        element.prev.next = element.next;
        element.next.prev = element.prev;
    }

    public void clear() {
        this.start.next = this.last;
        this.last.prev = this.start;
    }

    @Override
    public Iterator<ListElement<E>> iterator() {
        return new DoublyLinkedListIterator();
    }

    public boolean contains(ListElement<E> e) {
        for (ListElement<E> e2 : this) {
            if (!e.equals(e2)) continue;
            return true;
        }
        return false;
    }

    public static class ListElement<E> {
        E key;
        ListElement<E> prev;
        ListElement<E> next;

        ListElement(E key) {
            this.key = key;
            this.prev = null;
            this.next = null;
        }

        public E getKey() {
            return this.key;
        }
    }

    private class DoublyLinkedListIterator
    extends UnmodifiableIterator<ListElement<E>> {
        private ListElement<E> next;

        private DoublyLinkedListIterator() {
            this.next = ((DoublyLinkedList)DoublyLinkedList.this).start.next;
        }

        @Override
        public boolean hasNext() {
            return this.next != DoublyLinkedList.this.last;
        }

        @Override
        public ListElement<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ListElement ret = this.next;
            this.next = this.next.next;
            return ret;
        }
    }
}

