/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v1FieldKey;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v1TagField;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTALB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCON;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;

public class ID3v11Tag
extends ID3v1Tag {
    protected static final String TYPE_TRACK = "track";
    protected static final int TRACK_UNDEFINED = 0;
    protected static final int TRACK_MAX_VALUE = 255;
    protected static final int TRACK_MIN_VALUE = 1;
    protected static final int FIELD_COMMENT_LENGTH = 28;
    protected static final int FIELD_COMMENT_POS = 97;
    protected static final int FIELD_TRACK_INDICATOR_LENGTH = 1;
    protected static final int FIELD_TRACK_INDICATOR_POS = 125;
    protected static final int FIELD_TRACK_LENGTH = 1;
    protected static final int FIELD_TRACK_POS = 126;
    protected byte track = 0;
    private static final byte RELEASE = 1;
    private static final byte MAJOR_VERSION = 1;
    private static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 1;
    }

    @Override
    public byte getMajorVersion() {
        return 1;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public ID3v11Tag() {
    }

    @Override
    public int getFieldCount() {
        return 7;
    }

    public ID3v11Tag(ID3v11Tag copyObject) {
        super(copyObject);
        this.track = copyObject.track;
    }

    public ID3v11Tag(AbstractTag mp3tag) {
        if (mp3tag != null) {
            if (mp3tag instanceof ID3v1Tag) {
                if (mp3tag instanceof ID3v11Tag) {
                    throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
                }
                if (mp3tag instanceof ID3v1Tag) {
                    ID3v1Tag id3old = (ID3v1Tag)mp3tag;
                    this.title = new String(id3old.title);
                    this.artist = new String(id3old.artist);
                    this.album = new String(id3old.album);
                    this.comment = new String(id3old.comment);
                    this.year = new String(id3old.year);
                    this.genre = id3old.genre;
                }
            } else {
                String text;
                ID3v24Frame frame;
                ID3v24Tag id3tag = !(mp3tag instanceof ID3v24Tag) ? new ID3v24Tag(mp3tag) : (ID3v24Tag)mp3tag;
                if (id3tag.hasFrame("TIT2")) {
                    frame = (ID3v24Frame)id3tag.getFrame("TIT2");
                    text = ((FrameBodyTIT2)frame.getBody()).getText();
                    this.title = ID3Tags.truncate(text, 30);
                }
                if (id3tag.hasFrame("TPE1")) {
                    frame = (ID3v24Frame)id3tag.getFrame("TPE1");
                    text = ((FrameBodyTPE1)frame.getBody()).getText();
                    this.artist = ID3Tags.truncate(text, 30);
                }
                if (id3tag.hasFrame("TALB")) {
                    frame = (ID3v24Frame)id3tag.getFrame("TALB");
                    text = ((FrameBodyTALB)frame.getBody()).getText();
                    this.album = ID3Tags.truncate(text, 30);
                }
                if (id3tag.hasFrame("TDRC")) {
                    frame = (ID3v24Frame)id3tag.getFrame("TDRC");
                    text = ((FrameBodyTDRC)frame.getBody()).getText();
                    this.year = ID3Tags.truncate(text, 4);
                }
                if (id3tag.hasFrame("COMM")) {
                    Iterator iterator = id3tag.getFrameOfType("COMM");
                    text = "";
                    while (iterator.hasNext()) {
                        frame = (ID3v24Frame)iterator.next();
                        text = text + ((FrameBodyCOMM)frame.getBody()).getText() + " ";
                    }
                    this.comment = ID3Tags.truncate(text, 28);
                }
                if (id3tag.hasFrame("TCON")) {
                    frame = (ID3v24Frame)id3tag.getFrame("TCON");
                    text = ((FrameBodyTCON)frame.getBody()).getText();
                    try {
                        this.genre = (byte)ID3Tags.findNumber(text);
                    }
                    catch (TagException ex) {
                        this.genre = (byte)-1;
                    }
                }
                if (id3tag.hasFrame("TRCK")) {
                    frame = (ID3v24Frame)id3tag.getFrame("TRCK");
                    text = ((FrameBodyTRCK)frame.getBody()).getText();
                    try {
                        this.track = (byte)ID3Tags.findNumber(text);
                    }
                    catch (TagException ex) {
                        this.track = 0;
                    }
                }
            }
        }
    }

    public ID3v11Tag(RandomAccessFile file, String loggingFilename) throws TagNotFoundException, IOException {
        this.setLoggingFilename(loggingFilename);
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        FileChannel fc = file.getChannel();
        fc.position(file.length() - 128L);
        byteBuffer = ByteBuffer.allocate(128);
        fc.read(byteBuffer);
        byteBuffer.flip();
        this.read(byteBuffer);
    }

    public ID3v11Tag(RandomAccessFile file) throws TagNotFoundException, IOException {
        this(file, "");
    }

    @Override
    public void setComment(String comment) {
        if (comment == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.comment = ID3Tags.truncate(comment, 28);
    }

    @Override
    public String getFirstComment() {
        return this.comment;
    }

    @Override
    public void setTrack(String trackValue) {
        int trackAsInt;
        try {
            trackAsInt = Integer.parseInt(trackValue);
        }
        catch (NumberFormatException e) {
            trackAsInt = 0;
        }
        this.track = trackAsInt > 255 || trackAsInt < 1 ? (byte)0 : (byte)Integer.parseInt(trackValue);
    }

    @Override
    public String getFirstTrack() {
        return String.valueOf(this.track & 0xFF);
    }

    @Override
    public void addTrack(String track) {
        this.setTrack(track);
    }

    @Override
    public List<TagField> getTrack() {
        if (this.getFirstTrack().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.TRACK.name(), this.getFirstTrack());
            return this.returnFieldToList(field);
        }
        return new ArrayList<TagField>();
    }

    @Override
    public void set(TagField field) {
        TagFieldKey genericKey = TagFieldKey.valueOf(field.getId());
        if (genericKey == TagFieldKey.TRACK) {
            this.setTrack(((Object)field).toString());
        } else {
            super.set(field);
        }
    }

    @Override
    public List<TagField> get(TagFieldKey genericKey) {
        if (genericKey == TagFieldKey.TRACK) {
            return this.getTrack();
        }
        return super.get(genericKey);
    }

    @Override
    public TagField getFirstField(String id) {
        List<TagField> results = null;
        if (TagFieldKey.TRACK.name().equals(id)) {
            results = this.getTrack();
            if (results != null && results.size() > 0) {
                return results.get(0);
            }
            return null;
        }
        return super.getFirstField(id);
    }

    @Override
    public boolean isEmpty() {
        if (this.track > 0) {
            return false;
        }
        return super.isEmpty();
    }

    @Override
    public void deleteTagField(TagFieldKey genericKey) {
        if (genericKey == TagFieldKey.TRACK) {
            this.track = 0;
        } else {
            super.deleteTagField(genericKey);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v11Tag)) {
            return false;
        }
        ID3v11Tag object = (ID3v11Tag)obj;
        if (this.track != object.track) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        byte[] buffer = new byte[3];
        byteBuffer.get(buffer, 0, 3);
        if (!Arrays.equals(buffer, TAG_ID)) {
            return false;
        }
        byteBuffer.position(125);
        if (byteBuffer.get() != 0) {
            return false;
        }
        return byteBuffer.get() != 0;
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagNotFoundException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException("ID3v1 tag not found");
        }
        byte[] dataBuffer = new byte[128];
        byteBuffer.position(0);
        byteBuffer.get(dataBuffer, 0, 128);
        this.title = Utils.getString(dataBuffer, 3, 30, "ISO-8859-1").trim();
        Matcher m = this.endofStringPattern.matcher(this.title);
        if (m.find()) {
            this.title = this.title.substring(0, m.start());
        }
        this.artist = Utils.getString(dataBuffer, 33, 30, "ISO-8859-1").trim();
        m = this.endofStringPattern.matcher(this.artist);
        if (m.find()) {
            this.artist = this.artist.substring(0, m.start());
        }
        this.album = Utils.getString(dataBuffer, 63, 30, "ISO-8859-1").trim();
        m = this.endofStringPattern.matcher(this.album);
        if (m.find()) {
            this.album = this.album.substring(0, m.start());
        }
        this.year = Utils.getString(dataBuffer, 93, 4, "ISO-8859-1").trim();
        m = this.endofStringPattern.matcher(this.year);
        if (m.find()) {
            this.year = this.year.substring(0, m.start());
        }
        this.comment = Utils.getString(dataBuffer, 97, 28, "ISO-8859-1").trim();
        m = this.endofStringPattern.matcher(this.comment);
        if (m.find()) {
            this.comment = this.comment.substring(0, m.start());
        }
        this.track = dataBuffer[126];
        this.genre = dataBuffer[127];
    }

    @Override
    public void write(RandomAccessFile file) throws IOException {
        int i;
        String str;
        byte[] buffer = new byte[128];
        this.delete(file);
        file.seek(file.length());
        System.arraycopy(TAG_ID, 0, buffer, 0, TAG_ID.length);
        int offset = 3;
        if (TagOptionSingleton.getInstance().isId3v1SaveTitle()) {
            str = ID3Tags.truncate(this.title, 30);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset = 33;
        if (TagOptionSingleton.getInstance().isId3v1SaveArtist()) {
            str = ID3Tags.truncate(this.artist, 30);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset = 63;
        if (TagOptionSingleton.getInstance().isId3v1SaveAlbum()) {
            str = ID3Tags.truncate(this.album, 30);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset = 93;
        if (TagOptionSingleton.getInstance().isId3v1SaveYear()) {
            str = ID3Tags.truncate(this.year, 4);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset = 97;
        if (TagOptionSingleton.getInstance().isId3v1SaveComment()) {
            str = ID3Tags.truncate(this.comment, 28);
            for (i = 0; i < str.length(); ++i) {
                buffer[i + offset] = (byte)str.charAt(i);
            }
        }
        offset = 126;
        buffer[offset] = this.track;
        offset = 127;
        if (TagOptionSingleton.getInstance().isId3v1SaveGenre()) {
            buffer[offset] = this.genre;
        }
        file.write(buffer);
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("title", this.title);
        MP3File.getStructureFormatter().addElement("artist", this.artist);
        MP3File.getStructureFormatter().addElement("album", this.album);
        MP3File.getStructureFormatter().addElement("year", this.year);
        MP3File.getStructureFormatter().addElement("comment", this.comment);
        MP3File.getStructureFormatter().addElement(TYPE_TRACK, this.track);
        MP3File.getStructureFormatter().addElement("genre", this.genre);
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }
}

