/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.ogg.util.VorbisHeader;
import org.jaudiotagger.audio.ogg.util.VorbisPacketType;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentCreator;

public class OggVorbisCommentTagCreator {
    public static final int FIELD_FRAMING_BIT_LENGTH = 1;
    public static final byte FRAMING_BIT_VALID_VALUE = 1;
    private VorbisCommentCreator creator = new VorbisCommentCreator();

    public ByteBuffer convert(Tag tag) throws UnsupportedEncodingException {
        ByteBuffer ogg = this.creator.convert(tag);
        int tagLength = ogg.capacity() + 1 + 6 + 1;
        ByteBuffer buf = ByteBuffer.allocate(tagLength);
        buf.put((byte)VorbisPacketType.COMMENT_HEADER.getType());
        buf.put(VorbisHeader.CAPTURE_PATTERN_AS_BYTES);
        buf.put(ogg);
        buf.put((byte)1);
        buf.rewind();
        return buf;
    }
}

