/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.datatype.Artwork;

public abstract class AbstractTag
implements Tag {
    protected int commonNumber = 0;
    protected Map<String, List<TagField>> fields = new LinkedHashMap<String, List<TagField>>();

    @Override
    public void add(TagField field) {
        if (field == null) {
            return;
        }
        List<TagField> list = this.fields.get(field.getId());
        if (list == null) {
            list = new ArrayList<TagField>();
            list.add(field);
            this.fields.put(field.getId(), list);
            if (field.isCommon()) {
                ++this.commonNumber;
            }
        } else {
            list.add(field);
        }
    }

    @Override
    public void addAlbum(String s) {
        this.add(this.createAlbumField(s));
    }

    @Override
    public void addArtist(String s) {
        this.add(this.createArtistField(s));
    }

    @Override
    public void addComment(String s) {
        this.add(this.createCommentField(s));
    }

    @Override
    public void addGenre(String s) {
        this.add(this.createGenreField(s));
    }

    @Override
    public void addTitle(String s) {
        this.add(this.createTitleField(s));
    }

    @Override
    public void addTrack(String s) throws FieldDataInvalidException {
        this.add(this.createTrackField(s));
    }

    @Override
    public void addYear(String s) {
        this.add(this.createYearField(s));
    }

    @Override
    public List<TagField> get(String id) {
        List<TagField> list = this.fields.get(id);
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    @Override
    public List<TagField> get(TagFieldKey id) throws KeyNotFoundException {
        List<TagField> list = this.fields.get(id.name());
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    @Override
    public String getFirst(String id) {
        List<TagField> l = this.get(id);
        return l.size() != 0 ? ((Object)l.get(0)).toString() : "";
    }

    @Override
    public TagField getFirstField(String id) {
        List<TagField> l = this.get(id);
        return l.size() != 0 ? l.get(0) : null;
    }

    @Override
    public List<TagField> getAlbum() {
        return this.get(this.getAlbumId());
    }

    protected abstract String getAlbumId();

    @Override
    public List<TagField> getArtist() {
        return this.get(this.getArtistId());
    }

    protected abstract String getArtistId();

    @Override
    public List<TagField> getComment() {
        return this.get(this.getCommentId());
    }

    protected abstract String getCommentId();

    @Override
    public Iterator<TagField> getFields() {
        final Iterator<Map.Entry<String, List<TagField>>> it = this.fields.entrySet().iterator();
        return new Iterator<TagField>(){
            private Iterator<TagField> fieldsIt;

            private void changeIt() {
                if (!it.hasNext()) {
                    return;
                }
                Map.Entry e = (Map.Entry)it.next();
                List l = (List)e.getValue();
                this.fieldsIt = l.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.fieldsIt == null) {
                    this.changeIt();
                }
                return it.hasNext() || this.fieldsIt != null && this.fieldsIt.hasNext();
            }

            @Override
            public TagField next() {
                if (!this.fieldsIt.hasNext()) {
                    this.changeIt();
                }
                return this.fieldsIt.next();
            }

            @Override
            public void remove() {
                this.fieldsIt.remove();
            }
        };
    }

    @Override
    public int getFieldCount() {
        Iterator<TagField> it = this.getFields();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    @Override
    public String getFirstAlbum() {
        List<TagField> l = this.getAlbum();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstArtist() {
        List<TagField> l = this.getArtist();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstComment() {
        List<TagField> l = this.getComment();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstGenre() {
        List<TagField> l = this.getGenre();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstTitle() {
        List<TagField> l = this.getTitle();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstTrack() {
        List<TagField> l = this.getTrack();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstYear() {
        List<TagField> l = this.getYear();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public List<TagField> getGenre() {
        return this.get(this.getGenreId());
    }

    protected abstract String getGenreId();

    @Override
    public List<TagField> getTitle() {
        return this.get(this.getTitleId());
    }

    protected abstract String getTitleId();

    @Override
    public List<TagField> getTrack() {
        return this.get(this.getTrackId());
    }

    protected abstract String getTrackId();

    @Override
    public List<TagField> getYear() {
        return this.get(this.getYearId());
    }

    protected abstract String getYearId();

    @Override
    public boolean hasCommonFields() {
        return this.commonNumber != 0;
    }

    @Override
    public boolean hasField(String id) {
        return this.get(id).size() != 0;
    }

    protected abstract boolean isAllowedEncoding(String var1);

    @Override
    public boolean isEmpty() {
        return this.fields.size() == 0;
    }

    @Override
    public void set(TagField field) {
        if (field == null) {
            return;
        }
        List<TagField> list = this.fields.get(field.getId());
        if (list != null) {
            list.set(0, field);
            return;
        }
        list = new ArrayList<TagField>();
        list.add(field);
        this.fields.put(field.getId(), list);
        if (field.isCommon()) {
            ++this.commonNumber;
        }
    }

    @Override
    public void setAlbum(String s) {
        this.set(this.createAlbumField(s));
    }

    @Override
    public void setArtist(String s) {
        this.set(this.createArtistField(s));
    }

    @Override
    public void setComment(String s) {
        this.set(this.createCommentField(s));
    }

    @Override
    public boolean setEncoding(String enc) {
        if (!this.isAllowedEncoding(enc)) {
            return false;
        }
        Iterator<TagField> it = this.getFields();
        while (it.hasNext()) {
            TagField field = it.next();
            if (!(field instanceof TagTextField)) continue;
            ((TagTextField)field).setEncoding(enc);
        }
        return true;
    }

    @Override
    public void setGenre(String s) {
        this.set(this.createGenreField(s));
    }

    @Override
    public void setTitle(String s) {
        this.set(this.createTitleField(s));
    }

    @Override
    public void setTrack(String s) throws FieldDataInvalidException {
        this.set(this.createTrackField(s));
    }

    @Override
    public void setYear(String s) {
        this.set(this.createYearField(s));
    }

    @Override
    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Tag content:\n");
        Iterator<TagField> it = this.getFields();
        while (it.hasNext()) {
            TagField field = it.next();
            out.append("\t");
            out.append(field.getId());
            out.append(":");
            out.append(((Object)field).toString());
            out.append("\n");
        }
        return out.toString().substring(0, out.length() - 1);
    }

    @Override
    public abstract TagField createTagField(TagFieldKey var1, String var2) throws KeyNotFoundException, FieldDataInvalidException;

    @Override
    public abstract String getFirst(TagFieldKey var1) throws KeyNotFoundException;

    @Override
    public abstract TagField getFirstField(TagFieldKey var1) throws KeyNotFoundException;

    @Override
    public abstract void deleteTagField(TagFieldKey var1) throws KeyNotFoundException;

    protected void deleteField(String key) {
        List<TagField> removed = this.fields.remove(key);
    }

    public abstract TagField createAlbumField(String var1);

    public abstract TagField createArtistField(String var1);

    public abstract TagField createCommentField(String var1);

    public abstract TagField createGenreField(String var1);

    public abstract TagField createTitleField(String var1);

    public abstract TagField createTrackField(String var1) throws FieldDataInvalidException;

    public abstract TagField createYearField(String var1);

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> artwork = this.getArtworkList();
        if (artwork.size() > 0) {
            return artwork.get(0);
        }
        return null;
    }

    @Override
    public void createAndSetArtworkField(Artwork artwork) throws FieldDataInvalidException {
        this.set(this.createArtworkField(artwork));
    }
}

