/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.tag;

import java.util.HashMap;

public enum AsfFieldKey {
    AUTHOR("AUTHOR", false),
    TITLE("TITLE", false),
    RATING("RATING", false),
    COPYRIGHT("COPYRIGHT", false),
    DESCRIPTION("DESCRIPTION", false),
    ALBUM("WM/AlbumTitle", false),
    ALBUM_ARTIST("WM/AlbumArtist", true),
    ALBUM_ARTIST_SORT("WM/AlbumArtistSortOrder", false),
    ALBUM_SORT("WM/AlbumSortOrder", false),
    AMAZON_ID("ASIN", false),
    ARTIST_SORT("WM/ArtistSortOrder", false),
    BARCODE("WM/Barcode", false),
    BPM("WM/BeatsPerMinute", false),
    CATALOG_NO("WM/CatalogNo", false),
    CATEGORY("WM/Category", true),
    COMPOSER("WM/Composer", true),
    COMPOSER_SORT("WM/ComposerSort", false),
    CONDUCTOR("WM/Conductor", true),
    COVER_ART("WM/Picture", true),
    COVER_ART_URL("WM/AlbumCoverURL", true),
    DIRECTOR("WM/Director", true),
    DISC_NO("WM/PartOfSet", false),
    ENCODER("WM/ToolName", false),
    ENCODED_BY("WM/EncodedBy", false),
    GENRE("WM/Genre", true),
    GENRE_ID("WM/GenreID", true),
    GROUPING("WM/ContentGroupDescription", false),
    INITIAL_KEY("WM/InitialKey", false),
    IS_COMPILATION("WM/IsCompilation", false),
    ISRC("WM/ISRC", false),
    ISVBR("IsVBR", false),
    LANGUAGE("WM/Language", true),
    LYRICIST("WM/Writer", true),
    LYRICS("WM/Lyrics", false),
    LYRICS_SYNCHRONISED("WM/Lyrics_Synchronised", true),
    MEDIA("WM/Media", false),
    MOOD("WM/Mood", true),
    MUSICBRAINZ_ARTISTID("MusicBrainz/Artist Id", false),
    MUSICBRAINZ_DISC_ID("MusicBrainz/Disc Id", false),
    MUSICBRAINZ_RELEASE_COUNTRY("MusicBrainz/Album Release Country", false),
    MUSICBRAINZ_RELEASE_STATUS("MusicBrainz/Album Status", false),
    MUSICBRAINZ_RELEASE_TYPE("MusicBrainz/Album Type", false),
    MUSICBRAINZ_RELEASEARTISTID("MusicBrainz/Album Artist Id", false),
    MUSICBRAINZ_RELEASEID("MusicBrainz/Album Id", false),
    MUSICBRAINZ_TRACK_ID("MusicBrainz/Track Id", false),
    MUSICIP_ID("MusicIP/PUID", false),
    PRODUCER("WM/Producer", false),
    RECORD_LABEL("WM/Publisher", false),
    REMIXER("WM/ModifiedBy", false),
    SUBTITLE("WM/SubTitle", false),
    TITLE_SORT("WM/TitleSortOrder", false),
    TRACK("WM/TrackNumber", false),
    URL_DISCOGS_ARTIST_SITE("WM/DiscogsArtistUrl", false),
    URL_DISCOGS_RELEASE_SITE("WM/DiscogsReleaseUrl", false),
    URL_OFFICIAL_ARTIST_SITE("WM/AuthorURL", false),
    URL_OFFICIAL_RELEASE_SITE("WM/OfficialReleaseUrl", false),
    URL_PROMOTIONAL_SITE("WM/PromotionURL", true),
    URL_WIKIPEDIA_ARTIST_SITE("WM/WikipediaArtistUrl", false),
    URL_WIKIPEDIA_RELEASE_SITE("WM/WikipediaReleaseUrl", false),
    YEAR("WM/Year", false);

    private static final HashMap<String, AsfFieldKey> FIELD_ID_MAP;
    private String fieldName;
    private boolean multiValued;

    public static AsfFieldKey getAsfFieldKey(String fieldName) {
        return FIELD_ID_MAP.get(fieldName);
    }

    public static boolean isMultiValued(String id) {
        boolean result = false;
        AsfFieldKey fieldKey = AsfFieldKey.getAsfFieldKey(id);
        if (fieldKey != null) {
            result = fieldKey.isMultiValued();
        }
        return result;
    }

    private AsfFieldKey(String asfFieldId, boolean multiValue) {
        this.fieldName = asfFieldId;
        this.multiValued = multiValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public String toString() {
        return this.getFieldName();
    }

    static {
        FIELD_ID_MAP = new HashMap(AsfFieldKey.values().length);
        for (AsfFieldKey curr : AsfFieldKey.values()) {
            FIELD_ID_MAP.put(curr.getFieldName(), curr);
        }
    }
}

