/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.event;

import org.cybergarage.http.HTTP;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.http.HTTPResponse;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.event.Subscription;
import org.cybergarage.upnp.event.SubscriptionResponse;

public class SubscriptionRequest
extends HTTPRequest {
    private static final String CALLBACK_START_WITH = "<";
    private static final String CALLBACK_END_WITH = ">";

    public SubscriptionRequest() {
    }

    public SubscriptionRequest(HTTPRequest httpReq) {
        this.set(httpReq);
    }

    private void setService(Service service) {
        Device rootDev;
        String eventSubURL = service.getEventSubURL();
        this.setURI(eventSubURL, true);
        String urlBaseStr = "";
        Device dev = service.getDevice();
        if (dev != null) {
            urlBaseStr = dev.getURLBase();
        }
        if ((urlBaseStr == null || urlBaseStr.length() <= 0) && (rootDev = service.getRootDevice()) != null) {
            urlBaseStr = rootDev.getURLBase();
        }
        if ((urlBaseStr == null || urlBaseStr.length() <= 0) && (rootDev = service.getRootDevice()) != null) {
            urlBaseStr = rootDev.getLocation();
        }
        if ((urlBaseStr == null || urlBaseStr.length() <= 0) && HTTP.isAbsoluteURL(eventSubURL)) {
            urlBaseStr = eventSubURL;
        }
        String reqHost = HTTP.getHost(urlBaseStr);
        int reqPort = HTTP.getPort(urlBaseStr);
        this.setHost(reqHost, reqPort);
        this.setRequestHost(reqHost);
        this.setRequestPort(reqPort);
    }

    public void setSubscribeRequest(Service service, String callback, long timeout) {
        this.setMethod("SUBSCRIBE");
        this.setService(service);
        this.setCallback(callback);
        this.setNT("upnp:event");
        this.setTimeout(timeout);
    }

    public void setRenewRequest(Service service, String uuid, long timeout) {
        this.setMethod("SUBSCRIBE");
        this.setService(service);
        this.setSID(uuid);
        this.setTimeout(timeout);
    }

    public void setUnsubscribeRequest(Service service) {
        this.setMethod("UNSUBSCRIBE");
        this.setService(service);
        this.setSID(service.getSID());
    }

    public void setNT(String value) {
        this.setHeader("NT", value);
    }

    public String getNT() {
        return this.getHeaderValue("NT");
    }

    public boolean hasNT() {
        String nt = this.getNT();
        return nt != null && 0 < nt.length();
    }

    public void setCallback(String value) {
        this.setStringHeader("CALLBACK", value, CALLBACK_START_WITH, CALLBACK_END_WITH);
    }

    public String getCallback() {
        return this.getStringHeaderValue("CALLBACK", CALLBACK_START_WITH, CALLBACK_END_WITH);
    }

    public boolean hasCallback() {
        String callback = this.getCallback();
        return callback != null && 0 < callback.length();
    }

    public void setSID(String id) {
        this.setHeader("SID", Subscription.toSIDHeaderString(id));
    }

    public String getSID() {
        if (!this.hasSID()) {
            return "";
        }
        return Subscription.getSID(this.getHeaderValue("SID"));
    }

    public boolean hasSID() {
        String sid = this.getSID();
        return sid != null && 0 < sid.length();
    }

    public final void setTimeout(long value) {
        this.setHeader("TIMEOUT", Subscription.toTimeoutHeaderString(value));
    }

    public long getTimeout() {
        return Subscription.getTimeout(this.getHeaderValue("TIMEOUT"));
    }

    public void post(SubscriptionResponse subRes) {
        super.post(subRes);
    }

    public SubscriptionResponse post() {
        HTTPResponse httpRes = this.post(this.getRequestHost(), this.getRequestPort());
        return new SubscriptionResponse(httpRes);
    }
}

