/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.ProxySubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;

public abstract class AbstractProxySubscriber
implements ProxySubscriber {
    private Object proxiedSubscriber;
    private Method subscriptionMethod;
    private ReferenceStrength referenceStrength;
    private EventService eventService;

    protected AbstractProxySubscriber(Object object, Method method, ReferenceStrength referenceStrength, EventService eventService) {
        this.referenceStrength = referenceStrength;
        this.eventService = eventService;
        if (object == null) {
            throw new IllegalArgumentException("The realSubscriber cannot be null when constructing a proxy subscriber.");
        }
        if (method == null) {
            throw new IllegalArgumentException("The subscriptionMethod cannot be null when constructing a proxy subscriber.");
        }
        this.proxiedSubscriber = ReferenceStrength.WEAK.equals((Object)referenceStrength) ? new WeakReference<Object>(object) : object;
        this.subscriptionMethod = method;
    }

    public Object getProxiedSubscriber() {
        if (this.proxiedSubscriber instanceof WeakReference) {
            return ((WeakReference)this.proxiedSubscriber).get();
        }
        return this.proxiedSubscriber;
    }

    public Method getSubscriptionMethod() {
        return this.subscriptionMethod;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public ReferenceStrength getReferenceStrength() {
        return this.referenceStrength;
    }

    public void proxyUnsubscribed() {
        this.proxiedSubscriber = null;
    }

    public final int hashCode() {
        throw new RuntimeException("Proxy subscribers are not allowed in Hash Maps, since the underlying values use Weak References thatmay disappear, the calculations may not be the same insuccessive calls as required by hashCode.");
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractProxySubscriber) {
            AbstractProxySubscriber abstractProxySubscriber = (AbstractProxySubscriber)object;
            if (this.referenceStrength != abstractProxySubscriber.referenceStrength) {
                return false;
            }
            if (this.subscriptionMethod != abstractProxySubscriber.subscriptionMethod) {
                return false;
            }
            if (ReferenceStrength.WEAK == this.referenceStrength ? ((WeakReference)this.proxiedSubscriber).get() != ((WeakReference)abstractProxySubscriber.proxiedSubscriber).get() : this.proxiedSubscriber != abstractProxySubscriber.proxiedSubscriber) {
                return false;
            }
            return this.eventService == abstractProxySubscriber.eventService;
        }
        return false;
    }

    public String toString() {
        return "AbstractProxySubscriber{realSubscriber=" + (this.proxiedSubscriber instanceof WeakReference ? ((WeakReference)this.proxiedSubscriber).get() : this.proxiedSubscriber) + ", subscriptionMethod=" + this.subscriptionMethod + ", referenceStrength=" + (Object)((Object)this.referenceStrength) + ", eventService=" + this.eventService + '}';
    }
}

