/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import net.sf.fmj.media.rtp.RTPReceptionStats;

public class RTPBuffer {
    private static int MIN_SEQUENTIAL = 2;
    private static int MAX_MISORDER = 100;
    private static int MAX_DROPOUT = 3000;
    private RTPBuffer firstItem;
    private RTPBuffer lastItem;
    private int itemCount;
    private int maxItems;
    private long duration;
    private long lastSequenceNumber = -1L;
    private long firstSequenceNumber = -1L;
    private RTPReceptionStats receptionStats;
    private int probation = MIN_SEQUENTIAL;
    private long received;
    private int cycles;
    private RTPBuffer previousBuffer;
    private RTPBuffer nextBuffer;
    private Buffer buffer;

    private RTPBuffer() {
    }

    public RTPBuffer(int maxItems, RTPReceptionStats receptionStats) {
        this.maxItems = maxItems;
        this.receptionStats = receptionStats;
    }

    public RTPBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public synchronized void resize(int maxItems) {
        this.maxItems = maxItems;
    }

    public synchronized void clear() throws InterruptedException {
        while (null != this.firstItem) {
            this.remove();
        }
    }

    public synchronized int getMaxItems() {
        return this.maxItems;
    }

    public synchronized int getItemCount() {
        return this.itemCount;
    }

    public synchronized long getDuration() {
        return this.duration;
    }

    public synchronized long getExtendedHighestSequenceNumber() {
        if (this.lastSequenceNumber != -1L) {
            return (long)(this.cycles << 16) + (this.lastSequenceNumber & 0xFFFFL);
        }
        return -1L;
    }

    public synchronized int getCumulativePacketLoss() {
        long extendedHighestSequenceNumber = this.getExtendedHighestSequenceNumber();
        if (extendedHighestSequenceNumber != -1L && this.firstSequenceNumber != -1L) {
            long packetsExpected = extendedHighestSequenceNumber - this.firstSequenceNumber + 1L;
            long cumulativePacketLoss = packetsExpected - this.received;
            if (cumulativePacketLoss > 0x7FFFFFL) {
                cumulativePacketLoss = 0x7FFFFFL;
            } else if (cumulativePacketLoss < -8388608L) {
                cumulativePacketLoss = -8388608L;
            }
            return (int)cumulativePacketLoss;
        }
        return -1;
    }

    public synchronized void addWait(Buffer buffer) throws InterruptedException {
        if (null != this.firstItem) {
            this.wait();
        }
        this.firstItem = this.lastItem = new RTPBuffer(buffer);
        this.itemCount = 1;
        this.duration = buffer.getDuration();
        long seq = buffer.getSequenceNumber() & 0xFFFFL;
        if (this.lastSequenceNumber != -1L) {
            long udelta = (short)seq - (short)this.lastSequenceNumber & 0xFFFF;
            if (seq < this.lastSequenceNumber) {
                ++this.cycles;
                if (null != this.receptionStats) {
                    this.receptionStats.addSequenceWrap();
                }
            }
        }
        if (-1L == this.firstSequenceNumber) {
            this.firstSequenceNumber = seq;
        }
        if (null != this.receptionStats) {
            this.receptionStats.addPDUProcessed();
        }
        ++this.received;
        this.lastSequenceNumber = seq;
        this.notifyAll();
    }

    public synchronized Buffer removeWait() throws InterruptedException {
        if (null == this.firstItem) {
            this.wait();
        }
        Buffer aBuffer = null;
        RTPBuffer aRTPBuffer = this.firstItem;
        this.lastItem = null;
        this.firstItem = null;
        this.itemCount = 0;
        this.duration = 0L;
        aBuffer = aRTPBuffer.buffer;
        this.notifyAll();
        return aBuffer;
    }

    private void addImpl(Buffer buffer) {
        RTPBuffer aRTPBuffer = new RTPBuffer(buffer);
        if (null == this.firstItem) {
            this.firstItem = this.lastItem = aRTPBuffer;
            this.itemCount = 1;
            this.duration = buffer.getDuration();
        } else {
            this.lastItem.nextBuffer = aRTPBuffer;
            aRTPBuffer.previousBuffer = this.lastItem;
            this.lastItem = aRTPBuffer;
            ++this.itemCount;
            this.duration += buffer.getDuration();
        }
        if (null != this.receptionStats) {
            this.receptionStats.addPDUProcessed();
        }
    }

    public synchronized boolean add(Buffer buffer) {
        boolean fBufferOverrun = false;
        long seq = buffer.getSequenceNumber() & 0xFFFFL;
        if (-1L == this.lastSequenceNumber) {
            this.lastSequenceNumber = seq;
        }
        if (this.probation > 0) {
            if (seq == (this.lastSequenceNumber + 1L & 0xFFFFL)) {
                --this.probation;
                if (0 == this.probation) {
                    this.firstSequenceNumber = seq;
                    this.addImpl(buffer);
                    ++this.received;
                }
            } else {
                this.probation = MIN_SEQUENTIAL - 1;
            }
            this.lastSequenceNumber = seq;
        } else {
            long udelta = (short)seq - (short)this.lastSequenceNumber & 0xFFFF;
            if (udelta < (long)MAX_DROPOUT) {
                if (seq < this.lastSequenceNumber) {
                    ++this.cycles;
                    if (null != this.receptionStats) {
                        this.receptionStats.addSequenceWrap();
                    }
                }
                this.addImpl(buffer);
                ++this.received;
                this.lastSequenceNumber = seq;
            } else {
                ++this.received;
            }
        }
        while (this.itemCount > this.maxItems) {
            try {
                this.remove();
                fBufferOverrun = true;
            }
            catch (Exception dontcare) {}
        }
        this.notifyAll();
        return fBufferOverrun;
    }

    public synchronized Buffer remove() throws InterruptedException {
        RTPBuffer aRTPBuffer;
        if (null == this.firstItem) {
            this.wait();
        }
        if (null != (aRTPBuffer = this.firstItem)) {
            if (this.lastItem == this.firstItem) {
                this.lastItem = null;
            }
            this.firstItem = aRTPBuffer.nextBuffer;
            if (null != this.firstItem) {
                this.firstItem.previousBuffer = null;
            }
            Buffer aBuffer = aRTPBuffer.buffer;
            aRTPBuffer.nextBuffer = null;
            aRTPBuffer.previousBuffer = null;
            aRTPBuffer.buffer = null;
            --this.itemCount;
            this.duration -= aBuffer.getDuration();
            return aBuffer;
        }
        return null;
    }
}

