/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.media.SleepHelper;
import net.sf.fmj.media.multiplexer.RawBufferMux;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.utility.LoggerSingleton;

public class RTPSyncBufferMux
extends RawBufferMux {
    private static final Logger logger = LoggerSingleton.logger;
    private final SleepHelper sleepHelper = new SleepHelper();

    public RTPSyncBufferMux() {
        super(new ContentDescriptor("raw.rtp"));
    }

    public String getName() {
        return "RTP Sync Buffer Multiplexer";
    }

    public Format setInputFormat(Format format, int trackID) {
        if (!RTPSessionMgr.formatSupported(format)) {
            return null;
        }
        return super.setInputFormat(format, trackID);
    }

    public void open() throws ResourceUnavailableException {
        super.open();
        this.sleepHelper.reset();
    }

    public int process(Buffer buffer, int trackID) {
        int result = super.process(buffer, trackID);
        return result;
    }
}

