/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import com.lti.utils.UnsignedUtils;
import net.sf.fmj.media.codec.video.jpeg.RFC2035;
import net.sf.fmj.utility.ArrayUtility;

public class JpegRTPHeader {
    public static final int HEADER_SIZE = 8;
    private final byte typeSpecific;
    private final int fragmentOffset;
    private final byte type;
    private final byte q;
    private final byte width;
    private final byte height;
    private static final int BITS_PER_BYTE = 8;
    private static final int MAX_SIGNED_BYTE = 127;
    private static final int MAX_BYTE = 255;
    private static final int MAX_BYTE_PLUS1 = 256;

    public JpegRTPHeader(byte typeSpecific, int fragmentOffset, byte type, byte q, byte width, byte height) {
        this.typeSpecific = typeSpecific;
        this.fragmentOffset = fragmentOffset;
        this.type = type;
        this.q = q;
        this.width = width;
        this.height = height;
    }

    public static JpegRTPHeader parse(byte[] data, int offset) {
        int i = offset;
        byte typeSpecific = data[i++];
        int fragmentOffset = 0;
        for (int j = 0; j < 3; ++j) {
            fragmentOffset <<= 8;
            fragmentOffset += data[i++] & 0xFF;
        }
        byte type = data[i++];
        byte q = data[i++];
        byte width = data[i++];
        byte height = data[i++];
        return new JpegRTPHeader(typeSpecific, fragmentOffset, type, q, width, height);
    }

    public byte[] toBytes() {
        byte[] data = new byte[8];
        int i = 0;
        data[i++] = this.typeSpecific;
        JpegRTPHeader.encode3ByteIntBE(this.fragmentOffset, data, i);
        i += 3;
        data[i++] = this.type;
        data[i++] = this.q;
        data[i++] = this.width;
        data[i++] = this.height;
        return data;
    }

    private static void encode3ByteIntBE(int value, byte[] ba, int offset) {
        int length = 3;
        for (int i = 0; i < length; ++i) {
            int byteValue = value & 0xFF;
            if (byteValue > 127) {
                byteValue -= 256;
            }
            ba[offset + (length - i - 1)] = (byte)byteValue;
            value >>= 8;
        }
    }

    public static byte[] createQHeader(int length, int[] lqt, int[] cqt) {
        int qHeaderLength = 4 + length;
        byte[] data = new byte[qHeaderLength];
        int i = 0;
        byte mbz = 0;
        byte precision = 0;
        data[i++] = mbz;
        data[i++] = precision;
        data[i++] = (byte)(length >> 8 & 0xFF);
        data[i++] = (byte)length;
        if (length != 0) {
            int[] zzLqt = RFC2035.createZigZag(lqt);
            int[] zzCqt = RFC2035.createZigZag(cqt);
            System.arraycopy(ArrayUtility.intArrayToByteArray(zzLqt), 0, data, i, lqt.length);
            System.arraycopy(ArrayUtility.intArrayToByteArray(zzCqt), 0, data, i += lqt.length, cqt.length);
            i += cqt.length;
        }
        return data;
    }

    public int getWidthInPixels() {
        return UnsignedUtils.uByteToInt(this.width) * 8;
    }

    public int getHeightInPixels() {
        return UnsignedUtils.uByteToInt(this.height) * 8;
    }

    public int getWidthInBlocks() {
        return UnsignedUtils.uByteToInt(this.width);
    }

    public int getHeightInBlocks() {
        return UnsignedUtils.uByteToInt(this.height);
    }

    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    public int getQ() {
        return UnsignedUtils.uByteToInt(this.q);
    }

    public int getType() {
        return UnsignedUtils.uByteToInt(this.type);
    }

    public int getTypeSpecific() {
        return UnsignedUtils.uByteToInt(this.typeSpecific);
    }

    public String toString() {
        return "typeSpecific=" + this.getTypeSpecific() + " fragmentOffset=" + this.getFragmentOffset() + " type=" + this.getType() + " q=" + this.getQ() + " w=" + this.getWidthInPixels() + " h=" + this.getHeightInPixels();
    }

    public static byte[] createRstHeader(int dri, int f, int l, int count) {
        byte[] data = new byte[4];
        int i = 0;
        data[i++] = (byte)(dri >> 8 & 0xFF);
        data[i++] = (byte)dri;
        data[i] = (byte)((f & 1) << 7);
        int n = i;
        data[n] = (byte)(data[n] | (byte)((l & 1) << 6));
        int n2 = i++;
        data[n2] = (byte)(data[n2] | (byte)(count >> 8 & 0xFF) & 0x3F);
        data[i] = (byte)count;
        return data;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JpegRTPHeader)) {
            return false;
        }
        JpegRTPHeader oCast = (JpegRTPHeader)o;
        return this.typeSpecific == oCast.typeSpecific && this.fragmentOffset == oCast.fragmentOffset && this.type == oCast.type && this.q == oCast.q && this.width == oCast.width && this.height == oCast.height;
    }

    public int hashCode() {
        return this.typeSpecific + this.fragmentOffset + this.type + this.q + this.width + this.height;
    }
}

