/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.ulaw;

import com.lti.utils.UnsignedUtils;

public class MuLawEncoderUtil {
    public static final int BIAS = 132;
    public static final int MAX = 32635;
    private static byte[] pcmToMuLawMap = new byte[65536];

    public boolean getZeroTrap() {
        return pcmToMuLawMap[33000] != 0;
    }

    public void setZeroTrap(boolean value) {
        byte val = (byte)(value ? 2 : 0);
        for (int i = 32768; i <= 33924; ++i) {
            MuLawEncoderUtil.pcmToMuLawMap[i] = val;
        }
    }

    private static byte encode(int pcm) {
        int sign = (pcm & 0x8000) >> 8;
        if (sign != 0) {
            pcm = -pcm;
        }
        if (pcm > 32635) {
            pcm = 32635;
        }
        pcm += 132;
        int exponent = 7;
        int expMask = 16384;
        while ((pcm & expMask) == 0) {
            --exponent;
            expMask >>= 1;
        }
        int mantissa = pcm >> exponent + 3 & 0xF;
        byte mulaw = (byte)(sign | exponent << 4 | mantissa);
        return ~mulaw;
    }

    public static byte muLawEncode(int pcm) {
        return pcmToMuLawMap[pcm & 0xFFFF];
    }

    public static byte muLawEncode(short pcm) {
        return pcmToMuLawMap[UnsignedUtils.uShortToInt(pcm)];
    }

    public static void muLawEncodeLittleEndian(byte[] data, int offset, int len, byte[] target) {
        int size = len / 2;
        for (int i = 0; i < size; ++i) {
            target[i] = MuLawEncoderUtil.muLawEncode((data[offset + 2 * i + 1] & 0xFF) << 8 | data[offset + 2 * i] & 0xFF);
        }
    }

    public static void muLawEncodeBigEndian(byte[] data, int offset, int len, byte[] target) {
        int size = len / 2;
        for (int i = 0; i < size; ++i) {
            target[i] = MuLawEncoderUtil.muLawEncode(data[offset + 2 * i + 1] & 0xFF | (data[offset + 2 * i] & 0xFF) << 8);
        }
    }

    public static void muLawEncode(boolean bigEndian, byte[] data, int offset, int len, byte[] target) {
        if (bigEndian) {
            MuLawEncoderUtil.muLawEncodeBigEndian(data, offset, len, target);
        } else {
            MuLawEncoderUtil.muLawEncodeLittleEndian(data, offset, len, target);
        }
    }

    static {
        for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
            MuLawEncoderUtil.pcmToMuLawMap[UnsignedUtils.uShortToInt((short)((short)i))] = MuLawEncoderUtil.encode(i);
        }
    }
}

