/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceCloneable;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.AsyncSourceTransferHandlerNotifier;
import net.sf.fmj.media.BufferQueueInputStream;
import net.sf.fmj.utility.LoggerSingleton;

public class CloneablePushDataSource
extends PushDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    private final PushDataSource source;
    private PushSourceStream[] streams;
    private final ClonedDataSource firstClonedDataSource;
    private List<ClonedDataSource> clones = new ArrayList<ClonedDataSource>();
    private boolean sourceConnected = false;
    private boolean sourceStarted = false;
    private static final int READ_BUFFER_SIZE = 2000;

    public CloneablePushDataSource(PushDataSource source) {
        this.source = source;
        this.firstClonedDataSource = (ClonedDataSource)this.createClone();
    }

    public PushSourceStream[] getStreams() {
        return this.firstClonedDataSource.getStreams();
    }

    public void connect() throws IOException {
        this.firstClonedDataSource.connect();
    }

    public void disconnect() {
        this.firstClonedDataSource.disconnect();
    }

    public String getContentType() {
        return this.firstClonedDataSource.getContentType();
    }

    public Object getControl(String controlType) {
        return this.firstClonedDataSource.getControl(controlType);
    }

    public Object[] getControls() {
        return this.firstClonedDataSource.getControls();
    }

    public Time getDuration() {
        return this.firstClonedDataSource.getDuration();
    }

    public void start() throws IOException {
        this.firstClonedDataSource.start();
    }

    public void stop() throws IOException {
        this.firstClonedDataSource.stop();
    }

    public synchronized DataSource createClone() {
        ClonedDataSource result = new ClonedDataSource();
        this.clones.add(result);
        return result;
    }

    static /* synthetic */ PushSourceStream[] access$302(CloneablePushDataSource x0, PushSourceStream[] x1) {
        x0.streams = x1;
        return x1;
    }

    private class ClonedDataSource
    extends PushDataSource {
        private ClonedPushSourceStream[] clonedStreams;
        private boolean cloneConnected;
        private boolean cloneStarted;

        private ClonedDataSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PushSourceStream[] getStreams() {
            CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
            synchronized (cloneablePushDataSource) {
                if (this.clonedStreams == null) {
                    this.clonedStreams = new ClonedPushSourceStream[CloneablePushDataSource.this.streams.length];
                    for (int i = 0; i < CloneablePushDataSource.this.streams.length; ++i) {
                        this.clonedStreams[i] = new ClonedPushSourceStream(CloneablePushDataSource.this.streams[i]);
                    }
                }
                return this.clonedStreams;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect() throws IOException {
            CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
            synchronized (cloneablePushDataSource) {
                if (this.cloneConnected) {
                    return;
                }
                if (!CloneablePushDataSource.this.sourceConnected) {
                    CloneablePushDataSource.this.source.connect();
                    CloneablePushDataSource.this.sourceConnected = true;
                }
                this.cloneConnected = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            boolean disposeAllClones = false;
            CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
            synchronized (cloneablePushDataSource) {
                if (!this.cloneConnected) {
                    return;
                }
                this.cloneConnected = false;
                if (CloneablePushDataSource.this.sourceConnected) {
                    for (ClonedDataSource clone : CloneablePushDataSource.this.clones) {
                        if (!clone.cloneConnected) continue;
                        return;
                    }
                    CloneablePushDataSource.this.source.disconnect();
                    for (ClonedDataSource clone : CloneablePushDataSource.this.clones) {
                        clone.disposeAsync();
                    }
                    CloneablePushDataSource.this.sourceConnected = false;
                }
            }
            if (disposeAllClones) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getContentType() {
            CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
            synchronized (cloneablePushDataSource) {
                return CloneablePushDataSource.this.source.getContentType();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getControl(String controlType) {
            CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
            synchronized (cloneablePushDataSource) {
                return CloneablePushDataSource.this.source.getControl(controlType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getControls() {
            CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
            synchronized (cloneablePushDataSource) {
                return CloneablePushDataSource.this.source.getControls();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Time getDuration() {
            CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
            synchronized (cloneablePushDataSource) {
                return CloneablePushDataSource.this.source.getDuration();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws IOException {
            CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
            synchronized (cloneablePushDataSource) {
                if (this.cloneStarted) {
                    return;
                }
                if (!CloneablePushDataSource.this.sourceStarted) {
                    CloneablePushDataSource.access$302(CloneablePushDataSource.this, CloneablePushDataSource.this.source.getStreams());
                    for (int i = 0; i < CloneablePushDataSource.this.streams.length; ++i) {
                        CloneablePushDataSource.this.streams[i].setTransferHandler(new MySourceTransferHandler(i));
                    }
                    CloneablePushDataSource.this.source.start();
                    CloneablePushDataSource.this.sourceStarted = true;
                }
                this.cloneStarted = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws IOException {
            CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
            synchronized (cloneablePushDataSource) {
                if (!this.cloneStarted) {
                    return;
                }
                this.cloneStarted = false;
                if (CloneablePushDataSource.this.sourceStarted) {
                    for (ClonedDataSource clone : CloneablePushDataSource.this.clones) {
                        if (!clone.cloneStarted) continue;
                        return;
                    }
                    CloneablePushDataSource.this.source.stop();
                    CloneablePushDataSource.this.sourceStarted = false;
                }
            }
        }

        public void disposeAsync() {
            for (ClonedPushSourceStream clonedStream : this.clonedStreams) {
                clonedStream.disposeAsync();
            }
        }

        class ClonedPushSourceStream
        implements PushSourceStream {
            private final PushSourceStream stream;
            private final ProducerConsumerQueue bufferQueue = new ProducerConsumerQueue();
            private final BufferQueueInputStream bufferQueueInputStream = new BufferQueueInputStream(this.bufferQueue);
            private boolean eos = false;
            private final AsyncSourceTransferHandlerNotifier asyncSourceTransferHandlerNotifier = new AsyncSourceTransferHandlerNotifier(this);

            public ClonedPushSourceStream(PushSourceStream stream) {
                this.stream = stream;
            }

            ProducerConsumerQueue getBufferQueue() {
                return this.bufferQueue;
            }

            public boolean endOfStream() {
                return this.eos;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ContentDescriptor getContentDescriptor() {
                CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
                synchronized (cloneablePushDataSource) {
                    return this.stream.getContentDescriptor();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long getContentLength() {
                CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
                synchronized (cloneablePushDataSource) {
                    return this.stream.getContentLength();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getMinimumTransferSize() {
                CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
                synchronized (cloneablePushDataSource) {
                    return this.stream.getMinimumTransferSize();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getControl(String controlType) {
                CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
                synchronized (cloneablePushDataSource) {
                    return this.stream.getControl(controlType);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object[] getControls() {
                CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
                synchronized (cloneablePushDataSource) {
                    return this.stream.getControls();
                }
            }

            public int read(byte[] buffer, int offset, int length) throws IOException {
                if (this.bufferQueue.isEmpty()) {
                    return 0;
                }
                return this.bufferQueueInputStream.read(buffer, offset, length);
            }

            public void setTransferHandler(SourceTransferHandler transferHandler) {
                this.asyncSourceTransferHandlerNotifier.setTransferHandler(transferHandler);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notifyTransferHandlerAsync() throws InterruptedException {
                CloneablePushDataSource cloneablePushDataSource = CloneablePushDataSource.this;
                synchronized (cloneablePushDataSource) {
                    if (!ClonedDataSource.this.cloneStarted) {
                        return;
                    }
                    this.asyncSourceTransferHandlerNotifier.notifyTransferHandlerAsync();
                }
            }

            public void dispose() {
                this.asyncSourceTransferHandlerNotifier.dispose();
            }

            public void disposeAsync() {
                this.asyncSourceTransferHandlerNotifier.disposeAsync();
            }
        }
    }

    private class MySourceTransferHandler
    implements SourceTransferHandler {
        private final int streamIndex;

        public MySourceTransferHandler(int streamIndex) {
            this.streamIndex = streamIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferData(PushSourceStream stream) {
            Buffer originalBuffer;
            block12: {
                originalBuffer = new Buffer();
                try {
                    byte[] originalBufferData = new byte[2000];
                    originalBuffer.setData(originalBufferData);
                    int numRead = stream.read(originalBufferData, 0, originalBufferData.length);
                    if (numRead < 0) {
                        originalBuffer.setEOM(true);
                    } else {
                        originalBuffer.setLength(numRead);
                    }
                }
                catch (IOException e) {
                    originalBuffer.setEOM(true);
                    originalBuffer.setDiscard(true);
                    originalBuffer.setLength(0);
                    if (e instanceof InterruptedIOException) break block12;
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
            ArrayList<ClonedDataSource.ClonedPushSourceStream> clonedStreams = new ArrayList<ClonedDataSource.ClonedPushSourceStream>();
            CloneablePushDataSource numRead = CloneablePushDataSource.this;
            synchronized (numRead) {
                for (ClonedDataSource clone : CloneablePushDataSource.this.clones) {
                    ClonedDataSource.ClonedPushSourceStream clonedStream = (ClonedDataSource.ClonedPushSourceStream)clone.getStreams()[this.streamIndex];
                    clonedStreams.add(clonedStream);
                }
            }
            try {
                for (ClonedDataSource.ClonedPushSourceStream clonedStream : clonedStreams) {
                    clonedStream.getBufferQueue().put(originalBuffer.clone());
                }
                for (ClonedDataSource.ClonedPushSourceStream clonedStream : clonedStreams) {
                    clonedStream.notifyTransferHandlerAsync();
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
                return;
            }
        }
    }
}

