/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.media.Controller;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import javax.swing.SwingUtilities;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractGainControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.GainMeter;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

public class StandardGainMeterControl
extends AbstractGainControl
implements GainChangeListener {
    public StandardGainMeterControl(Skin skin, Controller controller) {
        super(skin, controller);
    }

    public StandardGainMeterControl(Skin skin) {
        super(skin);
    }

    protected void setControllerHook(Controller newController) {
        super.setControllerHook(newController);
        if (this.isOperational()) {
            GainControl gc = this.getGainControl();
            this.setLevel(gc.getLevel());
            this.setMute(gc.getMute());
            gc.addGainChangeListener(this);
        }
    }

    protected Component createControlComponent(Skin skin) {
        return skin.createGainMeterButton();
    }

    public void setLevel(float level) {
        ((GainMeter)((Object)this.getControlComponent())).setLevel(level);
    }

    public void setMute(boolean muted) {
        ((GainMeter)((Object)this.getControlComponent())).setMute(muted);
    }

    protected EventListener createControlListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GainControl gc;
                boolean muted = (gc = StandardGainMeterControl.this.getGainControl()).getMute();
                gc.setMute(!muted);
                StandardGainMeterControl.this.setMute(!muted);
            }
        };
    }

    public void gainChange(GainChangeEvent gce) {
        float level = gce.getSourceGainControl().getLevel();
        SwingUtilities.invokeLater(new SetLevelThread(level));
    }

    class SetLevelThread
    implements Runnable {
        private float level;

        public SetLevelThread(float level) {
            this.level = level;
        }

        public void run() {
            StandardGainMeterControl.this.setLevel(this.level);
        }
    }
}

