/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.ilbc;

import com.ibm.media.codec.audio.AudioCodec;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import net.java.sip.communicator.impl.media.codec.Constants;
import net.java.sip.communicator.impl.media.codec.audio.Utils;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_constants;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_encoder;

public class JavaEncoder
extends AudioCodec {
    private Format lastFormat = null;
    private ilbc_encoder enc = null;
    private int ILBC_NO_OF_BYTES = 0;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, 0, 1)};
        this.PLUGIN_NAME = "pcm to iLbc converter";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        int mode = Constants.ILBC_MODE;
        this.enc = new ilbc_encoder(mode);
        if (mode == 20) {
            this.ILBC_NO_OF_BYTES = ilbc_constants.NO_OF_BYTES_20MS;
        } else if (mode == 30) {
            this.ILBC_NO_OF_BYTES = ilbc_constants.NO_OF_BYTES_30MS;
        }
    }

    public void close() {
    }

    private void initConverter(AudioFormat inFormat) {
        this.lastFormat = inFormat;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        Format newFormat = inputBuffer.getFormat();
        if (this.lastFormat != newFormat) {
            this.initConverter((AudioFormat)newFormat);
        }
        int inpLength = inputBuffer.getLength();
        int inOffset = inputBuffer.getOffset();
        byte[] inpData = (byte[])inputBuffer.getData();
        if (inpLength == 0) {
            return 4;
        }
        if (inpLength < this.enc.ULP_inst.blockl * 2) {
            return 4;
        }
        short[] encoded_data = new short[this.ILBC_NO_OF_BYTES / 2];
        int outLength = this.ILBC_NO_OF_BYTES;
        byte[] outdata = this.validateByteArraySize(outputBuffer, outLength);
        short[] data = Utils.byteToShortArray(inpData, inOffset, inpLength, true);
        this.enc.encode(encoded_data, data);
        Utils.shortArrToByteArr(encoded_data, outdata, false);
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        inputBuffer.setLength(inpLength - this.enc.ULP_inst.blockl * 2);
        inputBuffer.setOffset(inOffset + this.enc.ULP_inst.blockl * 2);
        return 2;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }
}

