/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec.io;

import com.onionnetworks.util.Util;

public class FECParameters {
    protected final int n;
    protected final int k;
    protected final int packetSize;
    protected final int numBlocks;
    protected final int firstGapStripe;
    protected final long fileSize;

    public long getFileSize() {
        return this.fileSize;
    }

    public int getK() {
        return this.k;
    }

    public int getN() {
        return this.n;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public int getMaxStripeSize() {
        return this.packetSize * this.numBlocks;
    }

    public int getUnexpandedBlockSize() {
        return this.k * this.packetSize;
    }

    public int getExpandedBlockSize() {
        return this.n * this.packetSize;
    }

    public int getBlockCount() {
        return this.numBlocks;
    }

    public int getNumStripes() {
        return this.n;
    }

    public int getUnexpandedPacketCount() {
        return Util.divideCeil(this.fileSize, (long)this.packetSize);
    }

    public int getUnexpandedPacketCount(int blockNum) {
        return Util.divideCeil(this.getUnexpandedBlockSize(blockNum), this.packetSize);
    }

    public int getStripePacketCount(int whichStripe) {
        if (whichStripe >= this.firstGapStripe && whichStripe < this.k) {
            return this.numBlocks - 1;
        }
        return this.numBlocks;
    }

    public int getPacketSize(int whichBlock, int whichStripe) {
        if (whichBlock == this.numBlocks - 1) {
            if (whichStripe >= this.firstGapStripe && whichStripe < this.k) {
                return 0;
            }
            if (whichStripe == this.firstGapStripe - 1) {
                return (int)this.fileSize % this.packetSize;
            }
        }
        return this.packetSize;
    }

    public long getStripeSize(int whichStripe) {
        if (this.getStripePacketCount(whichStripe) == this.numBlocks - 1) {
            return this.packetSize * (this.numBlocks - 1);
        }
        if (whichStripe == this.firstGapStripe - 1 && this.fileSize % (long)this.packetSize != 0L) {
            return (long)(this.packetSize * (this.numBlocks - 1)) + this.fileSize % (long)this.packetSize;
        }
        return this.packetSize * this.numBlocks;
    }

    public int getUnexpandedBlockSize(int whichBlock) {
        if (whichBlock == this.numBlocks - 1) {
            if (this.numBlocks == 1) {
                return (int)this.fileSize;
            }
            return (int)this.fileSize - this.k * (this.numBlocks - 1) * this.packetSize;
        }
        return this.k * this.packetSize;
    }

    public boolean isPaddingPacket(int blockNum, int stripeNum) {
        return blockNum == this.numBlocks - 1 && stripeNum >= this.getUnexpandedPacketCount(blockNum) && stripeNum < this.k;
    }

    public int hashCode() {
        return this.k * this.n * (int)this.fileSize * this.packetSize;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FECParameters) {
            FECParameters f2 = (FECParameters)obj;
            if (f2.k == this.k && f2.n == this.n && f2.fileSize == this.fileSize && f2.packetSize == this.packetSize) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "FECParameters(k=" + this.k + ",n=" + this.n + ",packetSize=" + this.packetSize + ",fileSize=" + this.fileSize + ")";
    }

    public FECParameters(int k, int n, int packetSize, long fileSize) {
        if (k <= 0 || n < k || packetSize <= 0 || fileSize <= 0L) {
            throw new IllegalArgumentException("Argument is < 0 or n < k :k=" + k + ",n=" + n + ",packetSize=" + packetSize + ",fileSize=" + fileSize);
        }
        this.k = k;
        this.n = n;
        this.packetSize = packetSize;
        this.fileSize = fileSize;
        this.numBlocks = Util.divideCeil(fileSize, (long)(packetSize * k));
        this.firstGapStripe = Util.divideCeil(this.getUnexpandedBlockSize(this.numBlocks - 1), packetSize);
    }
}

