/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.DownloadInformation;
import com.limegroup.gnutella.version.UpdateCollection;
import com.limegroup.gnutella.version.UpdateCollectionFactory;
import com.limegroup.gnutella.version.UpdateData;
import com.limegroup.gnutella.version.UpdateEvent;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.version.UpdateInformation;
import com.limegroup.gnutella.version.UpdateMessageVerifier;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.UpdateSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IOUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.ListenerSupport;
import org.limewire.util.Base32;
import org.limewire.util.Clock;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;
import org.limewire.util.VersionUtils;

@EagerSingleton
public class UpdateHandlerImpl
implements UpdateHandler,
EventListener<LibraryStatusEvent>,
Service {
    private static final Log LOG = LogFactory.getLog(UpdateHandlerImpl.class);
    private static final long THREE_DAYS = 259200000L;
    private static final long ONE_MONTH = 2592000000L;
    private static final String FILENAME = "version.xml";
    protected static final int IGNORE_ID = Integer.MAX_VALUE;
    private static final Random RANDOM = new Random();
    private final Clock clock;
    private volatile UpdateInformation _updateInfo;
    private volatile List<DownloadInformation> _updatesToDownload;
    private volatile int _lastId;
    private volatile byte[] _lastBytes;
    private long _lastTimestamp;
    private long _nextDownloadTime;
    private boolean _killingObsoleteNecessary;
    private final HttpRequestControl httpRequestControl = new HttpRequestControl();
    private final ScheduledExecutorService backgroundExecutor;
    private final ConnectionServices connectionServices;
    private final Provider<HttpExecutor> httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<DownloadManager> downloadManager;
    private final Library library;
    private final FileView gnutellaFileView;
    private final ApplicationServices applicationServices;
    private final UpdateCollectionFactory updateCollectionFactory;
    private final UpdateMessageVerifier updateMessageVerifier;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final EventListenerList<UpdateEvent> listeners;
    private volatile String timeoutUpdateLocation = "http://update0.limewire.com/v2/update.def";
    private volatile List<String> maxedUpdateList = Arrays.asList("http://update1.limewire.com/v2/update.def", "http://update2.limewire.com/v2/update.def", "http://update3.limewire.com/v2/update.def", "http://update4.limewire.com/v2/update.def", "http://update5.limewire.com/v2/update.def", "http://update6.limewire.com/v2/update.def", "http://update7.limewire.com/v2/update.def", "http://update8.limewire.com/v2/update.def", "http://update9.limewire.com/v2/update.def", "http://update10.limewire.com/v2/update.def");
    private volatile int minMaxHttpRequestDelay = 60000;
    private volatile int maxMaxHttpRequestDelay = 1800000;
    private volatile int silentPeriodForMaxHttpRequest = 300000;
    private volatile UpdateCollection updateCollection;

    @Inject
    UpdateHandlerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, ConnectionServices connectionServices, Provider<HttpExecutor> httpExecutor, @Named(value="defaults") Provider<HttpParams> defaultParams, Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker, CapabilitiesVMFactory capabilitiesVMFactory, Provider<ConnectionManager> connectionManager, Provider<DownloadManager> downloadManager, ApplicationServices applicationServices, UpdateCollectionFactory updateCollectionFactory, Clock clock, UpdateMessageVerifier updateMessageVerifier, RemoteFileDescFactory remoteFileDescFactory, @GnutellaFiles FileView gnutellaFileView, Library library) {
        this.backgroundExecutor = backgroundExecutor;
        this.connectionServices = connectionServices;
        this.httpExecutor = httpExecutor;
        this.defaultParams = defaultParams;
        this.networkUpdateSanityChecker = networkUpdateSanityChecker;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.connectionManager = connectionManager;
        this.downloadManager = downloadManager;
        this.library = library;
        this.applicationServices = applicationServices;
        this.updateCollectionFactory = updateCollectionFactory;
        this.clock = clock;
        this.updateMessageVerifier = updateMessageVerifier;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.gnutellaFileView = gnutellaFileView;
        this.listeners = new EventListenerList();
    }

    @Inject
    void register(ListenerSupport<LibraryStatusEvent> listener) {
        listener.addListener(this);
    }

    String getTimeoutUrl() {
        return this.timeoutUpdateLocation;
    }

    List<String> getMaxUrls() {
        return this.maxedUpdateList;
    }

    void setMaxUrls(List<String> urls) {
        this.maxedUpdateList = urls;
    }

    void setSilentPeriodForMaxHttpRequest(int silentPeriodForMaxHttpRequest) {
        this.silentPeriodForMaxHttpRequest = silentPeriodForMaxHttpRequest;
    }

    @Override
    public void start() {
        LOG.trace("Initializing UpdateHandler");
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                UpdateHandlerImpl.this.handleDataInternal(FileUtils.readFileFully(UpdateHandlerImpl.this.getStoredFile()), UpdateType.FROM_DISK, null);
            }
        });
        this.backgroundExecutor.schedule(new Poller(), UpdateSettings.UPDATE_RETRY_DELAY.getValue(), TimeUnit.MILLISECONDS);
    }

    private void tryToDownloadUpdates() {
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                UpdateInformation updateInfo = UpdateHandlerImpl.this._updateInfo;
                if (updateInfo != null && updateInfo.getUpdateURN() != null && UpdateHandlerImpl.this.isMyUpdateDownloaded(updateInfo)) {
                    UpdateHandlerImpl.this.fireUpdate(updateInfo);
                }
                UpdateHandlerImpl.this.downloadUpdates(UpdateHandlerImpl.this._updatesToDownload, null);
            }
        });
    }

    @Override
    public void handleUpdateAvailable(final ReplyHandler rh, final int version) {
        if (version == this._lastId) {
            this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    UpdateHandlerImpl.this.addSourceIfIdMatches(rh, version);
                }
            });
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version from rh: " + rh + ", them: " + version + ", me: " + this._lastId);
        }
    }

    @Override
    public void handleNewData(final byte[] data, final ReplyHandler handler) {
        if (data != null) {
            this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    LOG.trace("Parsing new data...");
                    UpdateHandlerImpl.this.handleDataInternal(data, UpdateType.FROM_NETWORK, handler);
                }
            });
        }
    }

    @Override
    public int getLatestId() {
        return this._lastId;
    }

    @Override
    public byte[] getLatestBytes() {
        return this._lastBytes;
    }

    protected void handleDataInternal(byte[] data, UpdateType updateType, ReplyHandler handler) {
        UpdateCollection uc;
        if (data == null) {
            if (updateType == UpdateType.FROM_NETWORK && handler != null) {
                this.networkUpdateSanityChecker.get().handleInvalidResponse(handler, NetworkUpdateSanityChecker.RequestType.VERSION);
            }
            LOG.warn("No data to handle.");
            return;
        }
        String xml = this.updateMessageVerifier.getVerifiedData(data);
        if (xml == null) {
            if (updateType == UpdateType.FROM_NETWORK && handler != null) {
                this.networkUpdateSanityChecker.get().handleInvalidResponse(handler, NetworkUpdateSanityChecker.RequestType.VERSION);
            }
            LOG.warn("Couldn't verify signature on data.");
            return;
        }
        if (updateType == UpdateType.FROM_NETWORK && handler != null) {
            this.networkUpdateSanityChecker.get().handleValidResponse(handler, NetworkUpdateSanityChecker.RequestType.VERSION);
        }
        this.updateCollection = uc = this.updateCollectionFactory.createUpdateCollection(xml);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got a collection with id: " + uc.getId() + ", from " + (Object)((Object)updateType) + ".  Current id is: " + this._lastId);
        }
        switch (updateType) {
            case FROM_NETWORK: {
                if (uc.getId() == Integer.MAX_VALUE) {
                    if (this._lastId == Integer.MAX_VALUE) break;
                    this.doHttpMaxFailover(uc);
                    break;
                }
                if (uc.getId() <= this._lastId) {
                    this.checkForStaleUpdateAndMaybeDoHttpFailover();
                    this.addSourceIfIdMatches(handler, uc.getId());
                    break;
                }
                this.storeAndUpdate(data, uc, updateType);
                break;
            }
            case FROM_DISK: {
                this.checkForStaleUpdateAndMaybeDoHttpFailover();
                if (uc.getId() <= this._lastId) break;
                this.storeAndUpdate(data, uc, updateType);
                break;
            }
            case FROM_HTTP: {
                if (uc.getId() < this._lastId) break;
                this.storeAndUpdate(data, uc, updateType);
            }
        }
    }

    private void storeAndUpdate(byte[] data, UpdateCollection uc, UpdateType updateType) {
        Version limeV;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Retrieved new data from: " + (Object)((Object)updateType) + ", storing & updating.");
        }
        if (uc.getId() == Integer.MAX_VALUE && updateType == UpdateType.FROM_NETWORK) {
            throw new IllegalStateException("shouldn't be here!");
        }
        if (updateType == UpdateType.FROM_NETWORK && this.httpRequestControl.isRequestPending() && this.httpRequestControl.getRequestReason() == HttpRequestControl.RequestReason.MAX) {
            return;
        }
        this._lastId = uc.getId();
        this._lastTimestamp = uc.getTimestamp();
        UpdateSettings.LAST_UPDATE_TIMESTAMP.setValue(this._lastTimestamp);
        long delay = UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue();
        long random = Math.abs(RANDOM.nextLong() % delay);
        this._nextDownloadTime = this._lastTimestamp + random;
        this._lastBytes = data;
        if (updateType != UpdateType.FROM_DISK) {
            if (this.httpRequestControl.getRequestReason() == HttpRequestControl.RequestReason.TIMEOUT) {
                this.httpRequestControl.cancelRequest();
            }
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(this.clock.now());
            FileUtils.verySafeSave(CommonUtils.getUserSettingsDir(), FILENAME, data);
            this.capabilitiesVMFactory.updateCapabilities();
            this.connectionManager.get().sendUpdatedCapabilities();
        }
        try {
            limeV = new Version(LimeWireUtils.getLimeWireVersion());
        }
        catch (VersionFormatException vfe) {
            LOG.warn("Invalid LimeWire version", vfe);
            return;
        }
        Version javaV = null;
        try {
            javaV = new Version(VersionUtils.getJavaVersion());
        }
        catch (VersionFormatException vfe) {
            LOG.warn("Invalid java version", vfe);
        }
        int style = Math.min(2, UpdateSettings.UPDATE_STYLE.getValue());
        UpdateData updateInfo = uc.getUpdateDataFor(limeV, ApplicationSettings.getLanguage(), LimeWireUtils.isPro(), style, javaV);
        List<DownloadInformation> updatesToDownload = uc.getUpdatesWithDownloadInformation();
        this._killingObsoleteNecessary = true;
        if (updateInfo != null && updateInfo.getUpdateURN() != null) {
            UpdateHandlerImpl.prepareUpdateCommand(updateInfo);
            updatesToDownload = new LinkedList<DownloadInformation>(updatesToDownload);
            updatesToDownload.add(0, updateInfo);
        }
        this._updateInfo = updateInfo;
        this._updatesToDownload = updatesToDownload;
        this.downloadUpdates(updatesToDownload, null);
        if (updateInfo == null) {
            LOG.warn("No relevant update info to notify about.");
            return;
        }
        if (updateInfo.getUpdateURN() == null || UpdateHandlerImpl.isHopeless(updateInfo)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("we have an update, but it doesn't need a download.  or all our updates are hopeles. Scheduling URL notification...");
            }
            updateInfo.setUpdateCommand(null);
            this.backgroundExecutor.schedule(new NotificationFailover(this._lastId), UpdateHandlerImpl.delay(this.clock.now(), uc.getTimestamp()), TimeUnit.MILLISECONDS);
        } else if (this.isMyUpdateDownloaded(updateInfo)) {
            LOG.debug("there is an update for me, but I happen to have it on disk");
            this.fireUpdate(updateInfo);
        } else {
            LOG.debug("we have an update, it needs a download.  Rely on callbacks");
        }
    }

    private void checkForStaleUpdateAndMaybeDoHttpFailover() {
        LOG.debug("checking for timeout http failover");
        long monthAgo = this.clock.now() - 2592000000L;
        if (UpdateSettings.LAST_UPDATE_TIMESTAMP.getValue() < monthAgo && UpdateSettings.LAST_HTTP_FAILOVER.getValue() < monthAgo && !this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.TIMEOUT)) {
            long when = (this.connectionServices.isConnected() ? 1 : 5) * 60 * 1000;
            if (LOG.isDebugEnabled()) {
                LOG.debug("scheduling http failover in " + when);
            }
            this.backgroundExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        UpdateHandlerImpl.this.launchHTTPUpdate(UpdateHandlerImpl.this.timeoutUpdateLocation);
                    }
                    catch (URISyntaxException e) {
                        UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                        UpdateHandlerImpl.this.httpRequestControl.cancelRequest();
                        LOG.warn(e.toString(), e);
                    }
                }
            }, when, TimeUnit.MILLISECONDS);
        }
    }

    private void doHttpMaxFailover(UpdateCollection updateCollection) {
        long maxTimeAgo = this.clock.now() - (long)this.silentPeriodForMaxHttpRequest;
        if (!this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.MAX) && UpdateSettings.LAST_HTTP_FAILOVER.getValue() < maxTimeAgo) {
            LOG.debug("Scheduling http max failover...");
            this.backgroundExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    String url = (String)UpdateHandlerImpl.this.maxedUpdateList.get(RANDOM.nextInt(UpdateHandlerImpl.this.maxedUpdateList.size()));
                    try {
                        UpdateHandlerImpl.this.launchHTTPUpdate(url);
                    }
                    catch (URISyntaxException e) {
                        UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                        UpdateHandlerImpl.this.httpRequestControl.cancelRequest();
                        LOG.warn(e.toString(), e);
                    }
                }
            }, (long)(RANDOM.nextInt(this.maxMaxHttpRequestDelay) + this.minMaxHttpRequestDelay), TimeUnit.MILLISECONDS);
        } else {
            LOG.debug("Ignoring http max failover.");
        }
    }

    private void launchHTTPUpdate(String url) throws URISyntaxException {
        if (!this.httpRequestControl.isRequestPending()) {
            return;
        }
        LOG.debug("about to issue http request method");
        HttpGet get = new HttpGet(LimeWireUtils.addLWInfoToUrl(url, this.applicationServices.getMyGUID()));
        get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        get.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        this.httpRequestControl.requestActive();
        AbstractHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 10000);
        HttpConnectionParams.setSoTimeout(params, 10000);
        params = new DefaultedHttpParams(params, this.defaultParams.get());
        this.httpExecutor.get().execute(get, params, new RequestHandler());
    }

    private static void prepareUpdateCommand(UpdateData info) {
        if (info == null || info.getUpdateCommand() == null) {
            return;
        }
        File path = LibraryUtils.PREFERENCE_SHARE.getAbsoluteFile();
        String name = info.getUpdateFileName();
        try {
            path = FileUtils.getCanonicalFile(path);
        }
        catch (IOException bad) {
            // empty catch block
        }
        String command = info.getUpdateCommand();
        command = StringUtils.replace(command, "$", path.getPath() + File.separator);
        command = StringUtils.replace(command, "%", name);
        info.setUpdateCommand(command);
    }

    private static boolean isHopeless(DownloadInformation info) {
        return UpdateSettings.FAILED_UPDATES.contains(info.getUpdateURN().httpStringValue());
    }

    private void addSourceIfIdMatches(ReplyHandler rh, int version) {
        if (version == this._lastId) {
            this.downloadUpdates(this._updatesToDownload, rh);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version? Me: " + version + ", here: " + this._lastId);
        }
    }

    private void downloadUpdates(List<? extends DownloadInformation> toDownload, ReplyHandler source) {
        if (toDownload == null) {
            toDownload = Collections.emptyList();
        }
        this.killObsoleteUpdates(toDownload);
        for (DownloadInformation next : toDownload) {
            if (UpdateHandlerImpl.isHopeless(next) || !this.downloadManager.get().isSavedDownloadsLoaded() || !this.library.isLoadFinished()) continue;
            ManagedDownloader md = (ManagedDownloader)this.downloadManager.get().getDownloaderForURN(next.getUpdateURN());
            if (this.hasCompleteFile(next.getUpdateURN())) {
                if (md == null) continue;
                md.stop();
                continue;
            }
            if (md == null && !this.downloadManager.get().hasInNetworkDownload() && this.canStartDownload()) {
                LOG.debug("Starting a new InNetwork Download");
                try {
                    md = (ManagedDownloader)this.downloadManager.get().download(next, this.clock.now());
                }
                catch (DownloadException e) {
                    LOG.error("Unable to construct download", e);
                }
            }
            if (md == null) continue;
            if (source != null) {
                md.addDownload(this.rfd(source, next), false);
                continue;
            }
            this.addCurrentDownloadSources(md, next);
        }
    }

    private void killObsoleteUpdates(List<? extends DownloadInformation> toDownload) {
        if (!this.downloadManager.get().isSavedDownloadsLoaded() || !this.library.isLoadFinished()) {
            return;
        }
        if (this._killingObsoleteNecessary) {
            this._killingObsoleteNecessary = false;
            this.downloadManager.get().killDownloadersNotListed(toDownload);
            HashSet<URN> urns = new HashSet<URN>(toDownload.size());
            for (DownloadInformation downloadInformation : toDownload) {
                urns.add(downloadInformation.getUpdateURN());
            }
            List<FileDesc> shared = this.gnutellaFileView.getFilesInDirectory(LibraryUtils.PREFERENCE_SHARE);
            for (FileDesc fd : shared) {
                if (fd.getSHA1Urn() == null || urns.contains(fd.getSHA1Urn())) continue;
                this.library.remove(fd.getFile());
                fd.getFile().delete();
            }
        }
    }

    private void addCurrentDownloadSources(ManagedDownloader md, DownloadInformation info) {
        for (RoutedConnection mc : this.connectionManager.get().getConnections()) {
            if (mc.getConnectionCapabilities().getRemoteHostUpdateVersion() == this._lastId) {
                LOG.debug("Adding source: " + mc);
                md.addDownload(this.rfd(mc, info), false);
                continue;
            }
            LOG.debug("Not adding source because bad id: " + mc.getConnectionCapabilities().getRemoteHostUpdateVersion() + ", us: " + this._lastId);
        }
    }

    private RemoteFileDesc rfd(ReplyHandler rh, DownloadInformation info) {
        UrnSet urns = new UrnSet(info.getUpdateURN());
        return this.remoteFileDescFactory.createRemoteFileDesc(new ConnectableImpl(rh.getInetSocketAddress(), rh instanceof Connectable ? ((Connectable)((Object)rh)).isTLSCapable() : false), Integer.MAX_VALUE, info.getUpdateFileName(), info.getSize(), rh.getClientGUID(), 0, 2, false, null, urns, false, "LIME", -1L);
    }

    private boolean canStartDownload() {
        long now = this.clock.now();
        if (LOG.isDebugEnabled()) {
            LOG.debug("now is " + now + " next time is " + this._nextDownloadTime);
        }
        return now > this._nextDownloadTime;
    }

    private void notifyAboutInfo(int id) {
        if (id != this._lastId) {
            return;
        }
        UpdateInformation update2 = this._updateInfo;
        assert (update2 != null);
        this.fireUpdate(update2);
    }

    private static long delay(long now, long timestamp) {
        if (timestamp - now > 259200000L) {
            return 0L;
        }
        long delay = UpdateSettings.UPDATE_DELAY.getValue();
        long random = Math.abs(new Random().nextLong() % delay);
        long then = timestamp + random;
        if (LOG.isInfoEnabled()) {
            LOG.info("Delaying Update.\nNow    : " + now + " (" + new Date(now) + ")" + "\nStamp  : " + timestamp + " (" + new Date(timestamp) + ")" + "\nDelay  : " + delay + " (" + CommonUtils.seconds2time(delay / 1000L) + ")" + "\nRandom : " + random + " (" + CommonUtils.seconds2time(random / 1000L) + ")" + "\nThen   : " + then + " (" + new Date(then) + ")" + "\nDiff   : " + (then - now) + " (" + CommonUtils.seconds2time((then - now) / 1000L) + ")");
        }
        return Math.max(0L, then - now);
    }

    @Override
    public void inNetworkDownloadFinished(final URN urn, final boolean good) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                UpdateData updateInfo;
                if (!good) {
                    UpdateSettings.FAILED_UPDATES.add(urn.httpStringValue());
                }
                if ((updateInfo = (UpdateData)UpdateHandlerImpl.this._updateInfo) != null && updateInfo.getUpdateURN() != null && updateInfo.getUpdateURN().equals(urn)) {
                    if (!good) {
                        updateInfo.setUpdateCommand(null);
                        long delay = UpdateHandlerImpl.delay(UpdateHandlerImpl.this.clock.now(), UpdateHandlerImpl.this._lastTimestamp);
                        UpdateHandlerImpl.this.backgroundExecutor.schedule(new NotificationFailover(UpdateHandlerImpl.this._lastId), delay, TimeUnit.MILLISECONDS);
                    } else {
                        UpdateHandlerImpl.this.fireUpdate(updateInfo);
                        ((ConnectionManager)UpdateHandlerImpl.this.connectionManager.get()).sendUpdatedCapabilities();
                    }
                }
            }
        };
        this.backgroundExecutor.execute(r);
    }

    private void killHopelessUpdates(List<? extends DownloadInformation> updates) {
        if (updates == null) {
            return;
        }
        if (!this.downloadManager.get().hasInNetworkDownload()) {
            return;
        }
        long now = this.clock.now();
        for (DownloadInformation downloadInformation : updates) {
            InNetworkDownloader iDownloader;
            Downloader downloader = this.downloadManager.get().getDownloaderForURN(downloadInformation.getUpdateURN());
            if (downloader == null || !(downloader instanceof InNetworkDownloader) || !this.isHopeless(iDownloader = (InNetworkDownloader)downloader, now)) continue;
            iDownloader.stop();
        }
    }

    private boolean isHopeless(InNetworkDownloader downloader, long now) {
        if (now - downloader.getStartTime() < (long)UpdateSettings.UPDATE_GIVEUP_FACTOR.getValue() * UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue()) {
            return false;
        }
        return downloader.getDownloadAttempts() >= UpdateSettings.UPDATE_MIN_ATTEMPTS.getValue();
    }

    private boolean isMyUpdateDownloaded(UpdateInformation myInfo) {
        if (!this.library.isLoadFinished()) {
            return false;
        }
        URN myUrn = myInfo.getUpdateURN();
        if (myUrn == null) {
            return true;
        }
        return this.hasCompleteFile(myUrn);
    }

    private boolean hasCompleteFile(URN urn) {
        List<FileDesc> fds = this.library.getFileDescsMatching(urn);
        for (FileDesc fd : fds) {
            if (fd instanceof IncompleteFileDesc) continue;
            return true;
        }
        return false;
    }

    private File getStoredFile() {
        return new File(CommonUtils.getUserSettingsDir(), FILENAME);
    }

    @Override
    public byte[] getOldUpdateResponse() {
        return Base32.decode("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");
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Update Checks");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public void handleEvent(LibraryStatusEvent evt) {
        if (evt.getType() == LibraryStatusEvent.Type.LOAD_COMPLETE) {
            this.tryToDownloadUpdates();
        }
    }

    @Override
    public UpdateCollection getUpdateCollection() {
        return this.updateCollection;
    }

    private void fireUpdate(UpdateInformation update2) {
        this.listeners.broadcast(new UpdateEvent(update2, UpdateEvent.Type.UPDATE));
    }

    @Override
    public void addListener(EventListener<UpdateEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<UpdateEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    private static class HttpRequestControl {
        private final AtomicBoolean requestQueued = new AtomicBoolean(false);
        private final AtomicBoolean requestActive = new AtomicBoolean(false);
        private volatile RequestReason requestReason;

        private HttpRequestControl() {
        }

        boolean isRequestPending() {
            return this.requestActive.get() || this.requestQueued.get();
        }

        boolean requestQueued(RequestReason reason) {
            boolean prior = this.requestQueued.getAndSet(true);
            if (!prior || reason == RequestReason.MAX) {
                this.requestReason = reason;
            }
            return prior || this.requestActive.get();
        }

        void requestActive() {
            this.requestActive.set(true);
            this.requestQueued.set(false);
        }

        RequestReason getRequestReason() {
            return this.requestReason;
        }

        void cancelRequest() {
            this.requestQueued.set(false);
        }

        void requestFinished() {
            this.requestActive.set(false);
        }

        private static enum RequestReason {
            TIMEOUT,
            MAX;

        }
    }

    private class RequestHandler
    implements HttpClientListener {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            byte[] inflated;
            LOG.debug("http request method succeeded");
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(UpdateHandlerImpl.this.clock.now());
            try {
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
                    throw new IOException("bad code " + response.getStatusLine().getStatusCode());
                }
                byte[] resp = null;
                if (response.getEntity() != null) {
                    resp = IOUtils.readFully(response.getEntity().getContent());
                }
                if (resp == null || resp.length == 0) {
                    throw new IOException("bad body");
                }
                inflated = UpdateHandlerImpl.this.updateMessageVerifier.inflateNetworkData(resp);
            }
            catch (IOException failed) {
                UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                LOG.warn("couldn't fetch data ", failed);
                boolean bl = false;
                return bl;
            }
            finally {
                ((HttpExecutor)UpdateHandlerImpl.this.httpExecutor.get()).releaseResources(response);
            }
            UpdateHandlerImpl.this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                    LOG.trace("Parsing new data...");
                    UpdateHandlerImpl.this.handleDataInternal(inflated, UpdateType.FROM_HTTP, null);
                }
            });
            return false;
        }

        @Override
        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
            LOG.warn("http failover failed", exc);
            UpdateHandlerImpl.this.httpRequestControl.requestFinished();
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(UpdateHandlerImpl.this.clock.now());
            ((HttpExecutor)UpdateHandlerImpl.this.httpExecutor.get()).releaseResources(response);
            return false;
        }

        @Override
        public boolean allowRequest(HttpUriRequest request) {
            return true;
        }
    }

    private class NotificationFailover
    implements Runnable {
        private final int id;
        private boolean shown;

        NotificationFailover(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            if (this.shown) {
                return;
            }
            this.shown = true;
            UpdateHandlerImpl.this.notifyAboutInfo(this.id);
        }
    }

    private class Poller
    implements Runnable {
        private Poller() {
        }

        @Override
        public void run() {
            UpdateHandlerImpl.this.downloadUpdates(UpdateHandlerImpl.this._updatesToDownload, null);
            UpdateHandlerImpl.this.killHopelessUpdates(UpdateHandlerImpl.this._updatesToDownload);
        }
    }

    protected static enum UpdateType {
        FROM_NETWORK,
        FROM_DISK,
        FROM_HTTP;

    }
}

