/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree.dime;

import com.limegroup.gnutella.dime.DIMEParser;
import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.tigertree.HashTreeUtils;
import com.limegroup.gnutella.tigertree.dime.TigerDimeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Base32;
import org.limewire.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TigerDimeReadUtils {
    private static final Log LOG = LogFactory.getLog(TigerDimeReadUtils.class);

    public static List<List<byte[]>> read(InputStream is, long fileSize, String root32) throws IOException {
        LOG.trace("creating HashTreeHandler from network");
        DIMEParser parser = new DIMEParser(is);
        return TigerDimeReadUtils.nodesFromRecords(parser, fileSize, root32);
    }

    static List<List<byte[]>> nodesFromRecords(Iterator<DIMERecord> iterator, long fileSize, String root32) throws IOException {
        if (!iterator.hasNext()) {
            throw new IOException("no xml record");
        }
        DIMERecord xmlRecord = iterator.next();
        if (!iterator.hasNext()) {
            throw new IOException("no tree record");
        }
        DIMERecord treeRecord = iterator.next();
        if (LOG.isDebugEnabled()) {
            LOG.debug("xml id: [" + xmlRecord.getIdentifier() + "]");
            LOG.debug("xml type: [" + xmlRecord.getTypeString() + "]");
            LOG.debug("tree id: [" + treeRecord.getIdentifier() + "]");
            LOG.debug("tree type: [" + treeRecord.getTypeString() + "]");
            LOG.debug("xml type num: [" + xmlRecord.getTypeId() + "]");
            LOG.debug("tree type num: [" + treeRecord.getTypeId() + "]");
        }
        while (iterator.hasNext()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("more elements in the dime record.");
            }
            iterator.next();
        }
        String xml = new String(xmlRecord.getData(), "UTF-8");
        byte[] hashTree = treeRecord.getData();
        XMLTreeDescription xtd = new XMLTreeDescription(xml);
        if (!xtd.isValid()) {
            throw new IOException("invalid XMLTreeDescription " + xtd.toString());
        }
        if (xtd.getFileSize() != fileSize) {
            throw new IOException("file size attribute was " + xtd.getFileSize() + " expected " + fileSize);
        }
        HashTreeDescription htr = new HashTreeDescription(hashTree);
        if (!Base32.encode(htr.getRoot()).equals(root32)) {
            throw new IOException("Root hashes do not match");
        }
        return htr.getAllNodes(fileSize);
    }

    private static class HashTreeDescription {
        private final byte[] DATA;

        protected HashTreeDescription(byte[] data) {
            this.DATA = data;
        }

        byte[] getRoot() throws IOException {
            if (this.DATA.length < TigerDimeUtils.HASH_SIZE) {
                throw new IOException("invalid data");
            }
            byte[] ret = new byte[TigerDimeUtils.HASH_SIZE];
            System.arraycopy(this.DATA, 0, ret, 0, TigerDimeUtils.HASH_SIZE);
            return ret;
        }

        List<List<byte[]>> getAllNodes(long fileSize) throws IOException {
            int depth = HashTreeUtils.calculateDepth(fileSize);
            ArrayList<byte[]> hashes = new ArrayList<byte[]>();
            byte[] data = this.DATA;
            if (data.length % TigerDimeUtils.HASH_SIZE != 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("illegal size of data field for HashTree");
                }
                throw new IOException("corrupted hash tree detected");
            }
            int i = 0;
            while (i + TigerDimeUtils.HASH_SIZE <= data.length) {
                byte[] hash = new byte[TigerDimeUtils.HASH_SIZE];
                System.arraycopy(data, i, hash, 0, TigerDimeUtils.HASH_SIZE);
                hashes.add(hash);
                i += TigerDimeUtils.HASH_SIZE;
            }
            Iterator hashIterator = hashes.iterator();
            ArrayList<Object> generation = new ArrayList<byte[]>(1);
            ArrayList<byte[]> parent = null;
            int genIndex = 0;
            boolean verified = false;
            ArrayList<List<byte[]>> allNodes = new ArrayList<List<byte[]>>(depth + 1);
            while (genIndex <= depth && hashIterator.hasNext()) {
                List<byte[]> calculatedParent;
                verified = false;
                byte[] hash = (byte[])hashIterator.next();
                generation.add(hash);
                if (parent == null) {
                    verified = true;
                    ++genIndex;
                    parent = generation;
                    allNodes.add(generation);
                    generation = new ArrayList(2);
                    continue;
                }
                if (generation.size() > parent.size() * 2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("parent");
                        String str = "";
                        for (byte[] b : parent) {
                            str = str + Base32.encode(b) + "; ";
                        }
                        LOG.debug(str);
                        str = "";
                        LOG.debug("newparent");
                        List<byte[]> newparent = HashTreeUtils.createParentGeneration(generation, new Tiger());
                        for (byte[] byArray : newparent) {
                            str = str + Base32.encode(byArray) + "; ";
                        }
                        LOG.debug(str);
                        str = "";
                        LOG.debug("generation");
                        for (byte[] byArray : generation) {
                            str = str + Base32.encode(byArray) + "; ";
                        }
                        LOG.debug(str);
                        str = "";
                    }
                    throw new IOException("corrupted hash tree detected");
                }
                if (generation.size() != parent.size() * 2 - 1 && generation.size() != parent.size() * 2 || !this.isMatching(parent, calculatedParent = HashTreeUtils.createParentGeneration(generation, new Tiger()))) continue;
                parent = generation;
                allNodes.add(Collections.unmodifiableList(generation));
                if (++genIndex <= depth && hashIterator.hasNext()) {
                    generation = new ArrayList(parent.size() * 2);
                }
                verified = true;
            }
            if (!verified) {
                throw new IOException("corrupted hash tree detected");
            }
            LOG.debug("Valid hash tree received.");
            return allNodes;
        }

        private boolean isMatching(List<byte[]> a, List<byte[]> b) {
            if (a.size() == b.size()) {
                for (int i = 0; i < a.size(); ++i) {
                    byte[] two;
                    byte[] one = a.get(i);
                    if (Arrays.equals(one, two = b.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static final class Resolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.equals("http://open-content.net/spec/thex/thex.dtd")) {
                InputSource is = new InputSource(new StringReader("<!ELEMENT hashtree (file,digest,serializedtree)><!ELEMENT file EMPTY><!ATTLIST file size CDATA #REQUIRED><!ATTLIST file segmentsize CDATA #REQUIRED><!ELEMENT digest EMPTY><!ATTLIST digest algorithm CDATA #REQUIRED><!ATTLIST digest outputsize CDATA #REQUIRED><!ELEMENT serializedtree EMPTY><!ATTLIST serializedtree depth CDATA #REQUIRED><!ATTLIST serializedtree type CDATA #REQUIRED><!ATTLIST serializedtree uri CDATA #REQUIRED>"));
                is.setPublicId("-//NET//OPEN-CONTENT//THEX 02//EN");
                is.setSystemId("http://open-content.net/spec/thex/thex.dtd");
                return is;
            }
            if (publicId == null) {
                throw new SAXException("Can't resolve SYSTEM entity at '" + systemId + "'");
            }
            throw new SAXException("Can't resolve PUBLIC entity '" + publicId + "' at '" + systemId + "'");
        }
    }

    private static class XMLTreeDescription {
        private static final int UNKNOWN = 0;
        private static final int VALID = 1;
        private static final int INVALID = 2;
        private int _parsed = 0;
        private long _fileSize = 0L;
        private int _blockSize = 0;
        private String _algorithm = null;
        private int _hashSize = 0;
        private String _serializationType = null;
        private String data;

        protected XMLTreeDescription(String xml) {
            this.data = xml;
        }

        long getFileSize() {
            return this._fileSize;
        }

        boolean isValid() {
            if (this._parsed == 0) {
                int n = this._parsed = this.parse() ? 1 : 2;
            }
            if (this._parsed == 2) {
                return false;
            }
            if (this._blockSize != 1024) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unexpected block size: " + this._blockSize);
                }
                return false;
            }
            if (!"http://open-content.net/spec/digest/tiger".equals(this._algorithm)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unsupported digest algorithm: " + this._algorithm);
                }
                return false;
            }
            if (this._hashSize != TigerDimeUtils.HASH_SIZE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unexpected block size: " + this._blockSize);
                }
                return false;
            }
            if (!"http://open-content.net/spec/thex/breadthfirst".equals(this._serializationType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unexpected serialization type: " + this._serializationType);
                }
                return false;
            }
            return true;
        }

        private boolean parse() {
            int offset = this.data.indexOf("system");
            if (offset > 0 && offset < this.data.indexOf("http://open-content.net/spec/thex/thex.dtd")) {
                this.data = this.data.substring(0, offset) + "SYSTEM" + this.data.substring(offset + "system".length());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XMLTreeDescription read: " + this.data);
            }
            Document doc = null;
            try {
                doc = XMLUtils.getDocument(this.data, new Resolver(), new XMLUtils.LogErrorHandler(LOG));
            }
            catch (IOException ioe) {
                LOG.debug(ioe);
                return false;
            }
            Node treeDesc = doc.getElementsByTagName("hashtree").item(0);
            if (treeDesc == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("couldn't find hashtree element: " + this.data);
                }
                return false;
            }
            NodeList nodes = treeDesc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getTagName().equals("file")) {
                    this.parseFileElement(el);
                    continue;
                }
                if (el.getTagName().equals("digest")) {
                    this.parseDigestElement(el);
                    continue;
                }
                if (!el.getTagName().equals("serializedtree")) continue;
                this.parseSerializedtreeElement(el);
            }
            return true;
        }

        private void parseFileElement(Element e) {
            block5: {
                block4: {
                    try {
                        this._fileSize = Long.parseLong(e.getAttribute("size"));
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOG.isDebugEnabled()) break block4;
                        LOG.debug("couldn't parse file size: " + e.getNodeValue(), nfe);
                    }
                }
                try {
                    this._blockSize = Integer.parseInt(e.getAttribute("segmentsize"));
                }
                catch (NumberFormatException nfe) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("couldn't parse block size: " + e.getNodeValue(), nfe);
                }
            }
        }

        private void parseDigestElement(Element e) {
            block2: {
                this._algorithm = e.getAttribute("algorithm");
                try {
                    this._hashSize = Integer.parseInt(e.getAttribute("outputsize"));
                }
                catch (NumberFormatException nfe) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("couldn't parse hash size: " + e.getNodeValue(), nfe);
                }
            }
        }

        private void parseSerializedtreeElement(Element e) {
            block2: {
                this._serializationType = e.getAttribute("type");
                try {
                    Integer.parseInt(e.getAttribute("depth"));
                }
                catch (NumberFormatException nfe) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("couldn't parse depth: " + e.getNodeValue(), nfe);
                }
            }
        }
    }
}

