/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.spam.RatingTable;
import com.limegroup.gnutella.spam.SpamManager;
import java.util.Locale;
import org.limewire.core.settings.SearchSettings;

@Singleton
class SpamManagerImpl
implements SpamManager {
    private static final float INCOMPLETE_FILE_RATING = 0.8f;
    private final RatingTable ratingTable;

    @Inject
    SpamManagerImpl(RatingTable ratingTable) {
        this.ratingTable = ratingTable;
    }

    @Override
    public RatingTable getRatingTable() {
        return this.ratingTable;
    }

    @Override
    public void startedQuery(QueryRequest qr) {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            this.ratingTable.clear(qr);
        }
    }

    @Override
    public float calculateSpamRating(RemoteFileDesc rfd) {
        if (!SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            return 0.0f;
        }
        float rating = 0.0f;
        if (this.isIncompleteFile(rfd.getFileName().toLowerCase(Locale.US))) {
            rating = 1.0f - (1.0f - rating) * 0.19999999f;
        }
        rating = 1.0f - (1.0f - rating) * (1.0f - this.ratingTable.getRating(rfd));
        rfd.setSpamRating(rating);
        return rating;
    }

    @Override
    public void handleSpamQueryReply(QueryReply qr) {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            this.ratingTable.rate(qr, 1.0f);
        }
    }

    @Override
    public void handleUserMarkedSpam(RemoteFileDesc[] rfds) {
        for (RemoteFileDesc rfd : rfds) {
            rfd.setSpamRating(1.0f);
        }
        this.ratingTable.rate(rfds, 1.0f);
    }

    @Override
    public void handleUserMarkedGood(RemoteFileDesc[] rfds) {
        for (RemoteFileDesc rfd : rfds) {
            rfd.setSpamRating(0.0f);
        }
        this.ratingTable.rate(rfds, 0.0f);
    }

    @Override
    public void clearFilterData() {
        this.ratingTable.clear();
    }

    private boolean isIncompleteFile(String name) {
        int i;
        if (name.startsWith("incomplete_")) {
            return true;
        }
        if (name.startsWith("incomplete~")) {
            return true;
        }
        if (name.startsWith("inacheve_")) {
            return true;
        }
        if (name.startsWith("in_")) {
            return true;
        }
        if (name.startsWith("__incomplete")) {
            return true;
        }
        if (name.startsWith("___incompleted")) {
            return true;
        }
        if (name.startsWith("___arestra")) {
            return true;
        }
        if (name.startsWith("preview-t-")) {
            return true;
        }
        if (name.startsWith("t-")) {
            for (i = 2; i < name.length(); ++i) {
                if (Character.isDigit(name.charAt(i))) continue;
                return name.charAt(i) == '-';
            }
        }
        if (name.startsWith("corrupt-")) {
            for (i = 8; i < name.length(); ++i) {
                if (Character.isDigit(name.charAt(i))) continue;
                return name.charAt(i) == '-';
            }
        }
        return false;
    }
}

