/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileDescChangeEvent;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.IncompleteFiles;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.limewire.core.settings.SearchSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.Inspectable;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

@EagerSingleton
public class QRPUpdater
implements SettingListener,
Service,
Inspectable {
    private static Log LOG = LogFactory.getLog(QRPUpdater.class);
    private static long QRP_DELAY = (LimeWireUtils.isBetaRelease() ? 1 : 60) * 60 * 1000;
    private final FileView gnutellaFileView;
    private final FileView incompleteFileView;
    private final ScheduledExecutorService backgroundExecutor;
    private final ListenerSupport<FileDescChangeEvent> fileDescListenerSupport;
    private ScheduledFuture<?> scheduledSimppRebuildTimer;
    private final Set<String> qrpWords = new HashSet<String>();
    private boolean needRebuild = true;
    private QueryRouteTable queryRouteTable;

    @Inject
    public QRPUpdater(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, ListenerSupport<FileDescChangeEvent> fileDescListenerSupport, @GnutellaFiles FileView gnutellaFileView, @IncompleteFiles FileView incompleteFileView) {
        this.backgroundExecutor = backgroundExecutor;
        this.fileDescListenerSupport = fileDescListenerSupport;
        this.gnutellaFileView = gnutellaFileView;
        this.incompleteFileView = incompleteFileView;
        for (String entry : SearchSettings.LIME_QRP_ENTRIES.get()) {
            this.qrpWords.add(entry);
        }
    }

    @Override
    public synchronized void settingChanged(SettingEvent evt) {
        if (!SearchSettings.PUBLISH_LIME_KEYWORDS.getBoolean()) {
            return;
        }
        HashSet<String> newWords = new HashSet<String>();
        for (String entry : SearchSettings.LIME_QRP_ENTRIES.get()) {
            newWords.add(entry);
        }
        if (newWords.containsAll(this.qrpWords) && this.qrpWords.containsAll(newWords)) {
            return;
        }
        this.qrpWords.clear();
        this.qrpWords.addAll(newWords);
        if (this.needRebuild || this.scheduledSimppRebuildTimer != null && !this.scheduledSimppRebuildTimer.isDone()) {
            return;
        }
        this.scheduledSimppRebuildTimer = this.backgroundExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                QRPUpdater.this.needRebuild = true;
            }
        }, (long)((int)(Math.random() * (double)QRP_DELAY)), TimeUnit.MICROSECONDS);
    }

    public synchronized QueryRouteTable getQRT() {
        LOG.debug("getQRT");
        if (this.needRebuild) {
            if (this.scheduledSimppRebuildTimer != null) {
                this.scheduledSimppRebuildTimer.cancel(true);
            }
            this.buildQRT();
            this.needRebuild = false;
        }
        QueryRouteTable qrt = new QueryRouteTable(this.queryRouteTable.getSize());
        qrt.addAll(this.queryRouteTable);
        return qrt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildQRT() {
        LOG.debug("building QRT");
        this.queryRouteTable = new QueryRouteTable();
        if (SearchSettings.PUBLISH_LIME_KEYWORDS.getBoolean()) {
            for (String entry : SearchSettings.LIME_QRP_ENTRIES.get()) {
                this.queryRouteTable.addIndivisible(entry);
            }
        }
        this.gnutellaFileView.getReadLock().lock();
        try {
            for (FileDesc fd : this.gnutellaFileView) {
                this.queryRouteTable.add(fd.getFileName());
                for (LimeXMLDocument doc : fd.getLimeXMLDocuments()) {
                    for (String word : doc.getKeyWords()) {
                        this.queryRouteTable.add(word);
                    }
                    for (String word : doc.getKeyWordsIndivisible()) {
                        this.queryRouteTable.addIndivisible(word);
                    }
                    String schemaURI = doc.getSchemaURI();
                    this.queryRouteTable.addIndivisible(schemaURI);
                }
            }
        }
        finally {
            this.gnutellaFileView.getReadLock().unlock();
        }
        if (SharingSettings.ALLOW_PARTIAL_SHARING.getValue() && SharingSettings.PUBLISH_PARTIAL_QRP.getValue()) {
            this.incompleteFileView.getReadLock().lock();
            try {
                for (FileDesc fd : this.incompleteFileView) {
                    IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
                    if (!ifd.hasUrnsAndPartialData()) continue;
                    this.queryRouteTable.add(ifd.getFileName());
                }
            }
            finally {
                this.incompleteFileView.getReadLock().unlock();
            }
        }
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("QRP Updater");
    }

    @Override
    public void initialize() {
        SearchSettings.PUBLISH_LIME_KEYWORDS.addSettingListener(this);
        SearchSettings.LIME_QRP_ENTRIES.addSettingListener(this);
        this.gnutellaFileView.addListener(new EventListener<FileViewChangeEvent>(){

            @Override
            public void handleEvent(FileViewChangeEvent event) {
                switch (event.getType()) {
                    case FILE_ADDED: 
                    case FILE_REMOVED: 
                    case FILE_META_CHANGED: 
                    case FILE_CHANGED: 
                    case FILES_CLEARED: {
                        QRPUpdater.this.needRebuild = true;
                    }
                }
            }
        });
        this.incompleteFileView.addListener(new EventListener<FileViewChangeEvent>(){

            @Override
            public void handleEvent(FileViewChangeEvent event) {
                switch (event.getType()) {
                    case FILE_ADDED: 
                    case FILE_REMOVED: 
                    case FILES_CLEARED: {
                        QRPUpdater.this.needRebuild = true;
                    }
                }
            }
        });
        this.fileDescListenerSupport.addListener(new EventListener<FileDescChangeEvent>(){

            @Override
            public void handleEvent(FileDescChangeEvent event) {
                switch ((FileDescChangeEvent.Type)((Object)event.getType())) {
                    case TT_ROOT_ADDED: {
                        QRPUpdater.this.needRebuild = true;
                    }
                }
            }
        });
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        SearchSettings.PUBLISH_LIME_KEYWORDS.removeSettingListener(this);
        SearchSettings.LIME_QRP_ENTRIES.removeSettingListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object inspect() {
        HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
        QRPUpdater qRPUpdater = this;
        synchronized (qRPUpdater) {
            ret.put("qrt", this.getQRT().getRawDump());
        }
        return ret;
    }
}

