/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.google.inject.Singleton;
import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.MetaWriter;
import com.limegroup.gnutella.metadata.audio.reader.AudioDataReader;
import com.limegroup.gnutella.metadata.audio.reader.MP3Reader;
import com.limegroup.gnutella.metadata.audio.reader.WMAReader;
import com.limegroup.gnutella.metadata.audio.writer.AudioDataEditor;
import com.limegroup.gnutella.metadata.audio.writer.MP3DataEditor;
import com.limegroup.gnutella.metadata.bittorrent.TorrentMetaReader;
import com.limegroup.gnutella.metadata.video.reader.MOVMetaData;
import com.limegroup.gnutella.metadata.video.reader.MPEGMetaData;
import com.limegroup.gnutella.metadata.video.reader.OGMMetaData;
import com.limegroup.gnutella.metadata.video.reader.RIFFMetaData;
import com.limegroup.gnutella.metadata.video.reader.WMMetaReader;
import com.limegroup.gnutella.metadata.video.reader.WMVMetaData;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.FileUtils;

@Singleton
public class MetaDataFactoryImpl
implements MetaDataFactory {
    private static final Log LOG = LogFactory.getLog(MetaDataFactory.class);
    private final ConcurrentMap<String, MetaReader> readerByExtension = new ConcurrentHashMap<String, MetaReader>();
    private final Set<String> audioExtensions = new HashSet<String>();
    private final Set<String> videoExtensions = new HashSet<String>();
    private final ConcurrentMap<String, MetaWriter> writerByExtension = new ConcurrentHashMap<String, MetaWriter>();

    public MetaDataFactoryImpl() {
        this.registerAudioReader(new MP3Reader());
        this.registerAudioReader(new AudioDataReader());
        this.registerAudioReader(new WMAReader());
        this.registerVideoReader(new RIFFMetaData());
        this.registerVideoReader(new OGMMetaData());
        this.registerVideoReader(new WMVMetaData());
        this.registerVideoReader(new MPEGMetaData());
        this.registerVideoReader(new MOVMetaData());
        this.registerMultiFormat(new WMMetaReader());
        this.registerEditor(new MP3DataEditor());
        this.registerEditor(new AudioDataEditor());
        this.registerReader(new TorrentMetaReader());
    }

    @Override
    public MetaWriter getEditorForFile(String name) {
        String extension = FileUtils.getFileExtension(name);
        if (!extension.isEmpty()) {
            MetaWriter writer = (MetaWriter)this.writerByExtension.get(extension.toLowerCase(Locale.US));
            return writer;
        }
        return null;
    }

    private void registerMultiFormat(MetaReader reader) {
        for (String extension : reader.getSupportedExtensions()) {
            MetaReader existingReader = this.readerByExtension.put(extension, reader);
            this.audioExtensions.add(extension);
            this.videoExtensions.add(extension);
            if (existingReader == null) continue;
            throw new IllegalArgumentException("factory: " + existingReader.getClass() + " already resistered for: " + extension);
        }
    }

    private void registerAudioReader(MetaReader reader) {
        for (String extension : reader.getSupportedExtensions()) {
            MetaReader existingReader = this.readerByExtension.put(extension, reader);
            this.audioExtensions.add(extension);
            if (existingReader == null) continue;
            throw new IllegalArgumentException("factory: " + existingReader.getClass() + " already resistered for: " + extension);
        }
    }

    private void registerVideoReader(MetaReader reader) {
        for (String extension : reader.getSupportedExtensions()) {
            MetaReader existingReader = this.readerByExtension.put(extension, reader);
            this.videoExtensions.add(extension);
            if (existingReader == null) continue;
            throw new IllegalArgumentException("factory: " + existingReader.getClass() + " already resistered for: " + extension);
        }
    }

    private void registerEditor(MetaWriter writer) {
        for (String extension : writer.getSupportedExtensions()) {
            MetaWriter existingWriter = this.writerByExtension.put(extension, writer);
            if (existingWriter == null) continue;
            throw new IllegalArgumentException("factory: " + existingWriter.getClass() + " already resistered for: " + extension);
        }
    }

    @Override
    public MetaData parse(File file) throws IOException {
        try {
            MetaReader reader = this.getMetaReader(file);
            if (reader != null) {
                return reader.parse(file);
            }
        }
        catch (OutOfMemoryError e) {
            LOG.warn("Ran out of memory while parsing.", e);
            throw (IOException)new IOException().initCause(e);
        }
        catch (Exception e) {
            LOG.warn("Exception parsing file.", e);
            throw (IOException)new IOException().initCause(e);
        }
        return null;
    }

    public MetaReader getMetaReader(File file) {
        String extension = FileUtils.getFileExtension(file);
        if (!extension.isEmpty()) {
            MetaReader reader = (MetaReader)this.readerByExtension.get(extension.toLowerCase(Locale.US));
            return reader;
        }
        return null;
    }

    @Override
    public boolean containsEditor(String name) {
        String extension = FileUtils.getFileExtension(name);
        return !extension.isEmpty() && this.writerByExtension.get(extension.toLowerCase(Locale.US)) != null;
    }

    @Override
    public boolean containsReader(File file) {
        return this.getMetaReader(file) != null;
    }

    @Override
    public boolean containsAudioReader(File file) {
        String extension = FileUtils.getFileExtension(file);
        return !extension.isEmpty() && this.audioExtensions.contains(extension.toLowerCase(Locale.US));
    }

    @Override
    public boolean containsVideoReader(File file) {
        String extension = FileUtils.getFileExtension(file);
        return !extension.isEmpty() && this.videoExtensions.contains(extension.toLowerCase(Locale.US));
    }

    @Override
    public void registerReader(MetaReader reader) {
        for (String extension : reader.getSupportedExtensions()) {
            MetaReader existingReader = this.readerByExtension.put(extension, reader);
            if (existingReader == null) continue;
            throw new IllegalArgumentException("factory: " + existingReader.getClass() + " already resistered for: " + extension);
        }
    }
}

