/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessageFactory;
import org.limewire.io.GUID;

@Singleton
public class ReplyNumberVendorMessageFactoryImpl
implements ReplyNumberVendorMessageFactory {
    private final NetworkManager networkManager;

    @Inject
    public ReplyNumberVendorMessageFactoryImpl(NetworkManager networkManager) {
        this.networkManager = networkManager;
    }

    @Override
    public ReplyNumberVendorMessage createFromNetwork(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        return new ReplyNumberVendorMessage(guid, ttl, hops, version, payload, network);
    }

    @Override
    public ReplyNumberVendorMessage create(GUID replyGUID, int numResults) {
        return new ReplyNumberVendorMessage(replyGUID, 3, numResults, this.networkManager.canReceiveUnsolicited());
    }

    @Override
    public ReplyNumberVendorMessage createV2ReplyNumberVendorMessage(GUID replyGUID, int numResults) {
        return new ReplyNumberVendorMessage(replyGUID, 2, numResults, this.networkManager.canReceiveUnsolicited());
    }

    @Override
    public ReplyNumberVendorMessage createV3ReplyNumberVendorMessage(GUID replyGUID, int numResults) {
        return new ReplyNumberVendorMessage(replyGUID, 3, numResults, this.networkManager.canReceiveUnsolicited());
    }
}

