/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.hashing.AudioHashingUtils;
import com.limegroup.gnutella.library.AbstractFileCollection;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.library.LibraryFileData;
import com.limegroup.gnutella.library.LibraryImpl;
import com.limegroup.gnutella.library.SharedFileCollection;
import com.limegroup.gnutella.library.SharedFileCollectionChangeEvent;
import com.limegroup.gnutella.library.UrnCache;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.core.settings.URNSettings;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.SourcedEventMulticaster;
import org.limewire.util.StringUtils;

class SharedFileCollectionImpl
extends AbstractFileCollection
implements SharedFileCollection {
    private final int collectionId;
    private final Provider<LibraryFileData> data;
    private final HashTreeCache treeCache;
    private final EventBroadcaster<SharedFileCollectionChangeEvent> sharedBroadcaster;
    private final List<String> defaultFriendIds;
    private final boolean publicCollection;
    private final CategoryManager categoryManager;
    private final UrnCache urnCache;

    @Inject
    public SharedFileCollectionImpl(Provider<LibraryFileData> data, LibraryImpl managedList, SourcedEventMulticaster<FileViewChangeEvent, FileView> multicaster, EventBroadcaster<SharedFileCollectionChangeEvent> sharedCollectionBroadcaster, CategoryManager categoryManager, UrnCache urnCache, @Assisted int id, HashTreeCache treeCache, @Assisted boolean publicCollection, String ... defaultFriendIds) {
        super(managedList, multicaster);
        this.collectionId = id;
        this.data = data;
        this.treeCache = treeCache;
        this.sharedBroadcaster = sharedCollectionBroadcaster;
        this.publicCollection = publicCollection;
        this.categoryManager = categoryManager;
        this.urnCache = urnCache;
        this.defaultFriendIds = defaultFriendIds.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(defaultFriendIds));
    }

    @Override
    public int getId() {
        return this.collectionId;
    }

    @Override
    public String getName() {
        return this.data.get().getNameForCollection(this.collectionId);
    }

    @Override
    public void setName(String name) {
        if (this.data.get().setNameForCollection(this.collectionId, name)) {
            this.sharedBroadcaster.broadcast(new SharedFileCollectionChangeEvent(SharedFileCollectionChangeEvent.Type.NAME_CHANGED, this, name));
        }
    }

    @Override
    public void addFriend(String id) {
        if (this.data.get().addFriendToCollection(this.collectionId, id)) {
            this.sharedBroadcaster.broadcast(new SharedFileCollectionChangeEvent(SharedFileCollectionChangeEvent.Type.FRIEND_ADDED, this, id));
        }
    }

    @Override
    public boolean removeFriend(String id) {
        if (this.data.get().removeFriendFromCollection(this.collectionId, id)) {
            this.sharedBroadcaster.broadcast(new SharedFileCollectionChangeEvent(SharedFileCollectionChangeEvent.Type.FRIEND_REMOVED, this, id));
            return true;
        }
        return false;
    }

    @Override
    public List<String> getFriendList() {
        List<String> cached = this.data.get().getFriendsForCollection(this.collectionId);
        if (this.defaultFriendIds.isEmpty()) {
            return cached;
        }
        if (cached.isEmpty()) {
            return this.defaultFriendIds;
        }
        ArrayList<String> friends = new ArrayList<String>(cached.size() + this.defaultFriendIds.size());
        friends.addAll(this.defaultFriendIds);
        friends.addAll(cached);
        return friends;
    }

    @Override
    public void setFriendList(List<String> ids) {
        List<String> oldIds = this.data.get().setFriendsForCollection(this.collectionId, ids);
        if (oldIds != null) {
            this.sharedBroadcaster.broadcast(new SharedFileCollectionChangeEvent(SharedFileCollectionChangeEvent.Type.FRIEND_IDS_CHANGED, this, oldIds, ids));
        }
    }

    public String toString() {
        return StringUtils.toString(this, new Object[0]) + ", name: " + this.getName();
    }

    @Override
    protected boolean addFileDescImpl(FileDesc fileDesc) {
        if (super.addFileDescImpl(fileDesc)) {
            URN root;
            if (fileDesc.getTTROOTUrn() == null && (root = this.treeCache.getOrScheduleHashTreeRoot(fileDesc)) != null) {
                for (FileDesc fd : this.library.getFileDescsMatching(fileDesc.getSHA1Urn())) {
                    fd.addUrn(root);
                }
            }
            if (fileDesc.getSHA1Urn() != null) {
                this.calculateNonMetaDataHash(fileDesc);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void fileMetaChanged(FileDesc fileDesc) {
        super.fileMetaChanged(fileDesc);
        if (this.contains(fileDesc)) {
            this.calculateNonMetaDataHash(fileDesc);
        }
    }

    private void calculateNonMetaDataHash(final FileDesc fileDesc) {
        if (((Boolean)URNSettings.USE_NON_METADATA_HASH.get()).booleanValue() && fileDesc.getNMS1Urn() == null && AudioHashingUtils.canCreateNonMetaDataSHA1(fileDesc.getFile())) {
            ListeningFuture<URN> urnFuture = this.urnCache.calculateAndCacheNMS1(fileDesc.getFile());
            urnFuture.addFutureListener(new EventListener<FutureEvent<URN>>(){

                @Override
                public void handleEvent(FutureEvent<URN> event) {
                    URN urn = event.getResult();
                    if (urn != null && urn.isNMS1()) {
                        for (FileDesc fd : SharedFileCollectionImpl.this.library.getFileDescsMatching(fileDesc.getSHA1Urn())) {
                            fd.addUrn(urn);
                        }
                    }
                }
            });
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addPendingManagedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPendingManagedFiles() {
        this.library.getReadLock().lock();
        try {
            for (FileDesc fd : this.library) {
                if (!this.isPending(fd.getFile(), fd)) continue;
                this.add(fd);
            }
        }
        finally {
            this.library.getReadLock().unlock();
        }
    }

    @Override
    protected boolean isFileDescAllowed(FileDesc fileDesc) {
        if (fileDesc instanceof IncompleteFileDesc) {
            return false;
        }
        return this.isFileAllowed(fileDesc.getFile());
    }

    @Override
    protected boolean isPending(File file, FileDesc fd) {
        return this.data.get().isFileInCollection(file, this.collectionId);
    }

    @Override
    protected void saveChange(File file, boolean added) {
        this.data.get().setFileInCollection(file, this.collectionId, added);
    }

    @Override
    protected boolean clearImpl() {
        this.data.get().setFilesInCollection(this, this.collectionId, false);
        return super.clearImpl();
    }

    @Override
    void dispose() {
        super.dispose();
        this.data.get().removeCollection(this.collectionId);
    }

    @Override
    protected void fireAddEvent(FileDesc fileDesc) {
        super.fireAddEvent(fileDesc);
    }

    @Override
    protected void fireRemoveEvent(FileDesc fileDesc) {
        super.fireRemoveEvent(fileDesc);
    }

    @Override
    protected void fireChangeEvent(FileDesc oldFileDesc, FileDesc newFileDesc) {
        super.fireChangeEvent(oldFileDesc, newFileDesc);
    }

    @Override
    public boolean isFileAllowed(File file) {
        Category category;
        if (!this.library.isFileAllowed(file)) {
            return false;
        }
        return !this.isPublic() || (category = this.categoryManager.getCategoryForFile(file)) != Category.DOCUMENT || LibrarySettings.ALLOW_DOCUMENT_GNUTELLA_SHARING.getValue();
    }

    @Override
    public boolean isDirectoryAllowed(File folder) {
        return this.library.isDirectoryAllowed(folder);
    }

    @Override
    public boolean isPublic() {
        return this.publicCollection;
    }
}

