/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.limewire.util.StringUtils;

public final class HTTPUtils {
    private static final String CRLF = "\r\n";
    private static final String COLON_SPACE = ": ";
    public static final String COLON = ":";
    private static final String SLASH = "/";

    private HTTPUtils() {
    }

    public static String createHeader(String name, String value) {
        StringBuilder sb = new StringBuilder(name.length() + value.length() + 4);
        return sb.append(name).append(COLON_SPACE).append(value).append(CRLF).toString();
    }

    public static float parseFeatureToken(String token) throws ProblemReadingHeaderException {
        int slashIndex = token.indexOf(SLASH);
        if (slashIndex == -1 || slashIndex >= token.length() - 1) {
            throw new ProblemReadingHeaderException("invalid feature token");
        }
        String versionS = token.substring(slashIndex + 1);
        try {
            return Float.parseFloat(versionS);
        }
        catch (NumberFormatException bad) {
            throw new ProblemReadingHeaderException(bad);
        }
    }

    public static String parseValue(String keyValuePair) throws IOException {
        int equalIndex = keyValuePair.indexOf("=");
        if (equalIndex == -1 || equalIndex >= keyValuePair.length() - 1) {
            throw new IOException("invalid keyValuePair: " + keyValuePair);
        }
        return keyValuePair.substring(equalIndex + 1).trim();
    }

    public static String getDateValue() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(new Date());
    }

    public static String encode(String name, String encoding) throws IOException {
        return StringUtils.replace(URLEncoder.encode(name, encoding), "+", "%20");
    }
}

