/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.bittorrent.TorrentDHTScheduler;
import com.limegroup.bittorrent.TorrentResumeDataScheduler;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.GnutellaFiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.limewire.bittorrent.BTData;
import org.limewire.bittorrent.BTDataImpl;
import org.limewire.bittorrent.ProxySetting;
import org.limewire.bittorrent.ProxySettingType;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentEvent;
import org.limewire.bittorrent.TorrentEventType;
import org.limewire.bittorrent.TorrentIpFilter;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentManagerSettings;
import org.limewire.bittorrent.TorrentParams;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.bittorrent.bencoding.Token;
import org.limewire.core.settings.BittorrentSettings;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IP;
import org.limewire.libtorrent.LibTorrentSession;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.FileUtils;

@EagerSingleton
public class LimeWireTorrentManager
implements TorrentManager,
Service {
    private static final Log LOG = LogFactory.getLog(LimeWireTorrentManager.class);
    private final FileCollection gnutellaFileList;
    private final Provider<LibTorrentSession> torrentManager;
    private final EventListener<TorrentEvent> torrentListener = new EventListener<TorrentEvent>(){

        @Override
        public void handleEvent(TorrentEvent event) {
            LimeWireTorrentManager.this.handleTorrentEvent(event);
        }
    };
    private volatile boolean initialized = false;
    private final IpFilterPredicate ipFilterPredicate;
    @InspectionPoint(value="torrent manager status")
    private final Inspectable torrentManagerStatus = new TorrentManagerStatus();

    @Inject
    public LimeWireTorrentManager(Provider<LibTorrentSession> torrentManager, @GnutellaFiles FileCollection gnutellaFileList, IPFilter ipFilter) {
        this.torrentManager = torrentManager;
        this.ipFilterPredicate = new IpFilterPredicate(ipFilter);
        this.gnutellaFileList = gnutellaFileList;
    }

    private void handleTorrentEvent(TorrentEvent event) {
        if (event.getType() == TorrentEventType.COMPLETED) {
            this.limitSeedingTorrents();
        } else if (event.getType() == TorrentEventType.STOPPED) {
            event.getTorrent().removeListener(this.torrentListener);
        }
    }

    @Inject
    public void register(ServiceRegistry serviceRegistry) {
        serviceRegistry.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTorrentManager() {
        if (!this.initialized) {
            LimeWireTorrentManager limeWireTorrentManager = this;
            synchronized (limeWireTorrentManager) {
                if (!this.initialized) {
                    try {
                        this.torrentManager.get().initialize();
                        if (this.torrentManager.get().isValid()) {
                            this.updateProxies();
                            this.torrentManager.get().setIpFilter(this.ipFilterPredicate);
                            if (BittorrentSettings.TORRENT_USE_UPNP.getValue()) {
                                this.torrentManager.get().startUPnP();
                            } else {
                                this.torrentManager.get().stopUPnP();
                            }
                            this.torrentManager.get().start();
                            this.torrentManager.get().scheduleWithFixedDelay(new TorrentDHTScheduler(this), 1000L, 60000L, TimeUnit.MILLISECONDS);
                            this.torrentManager.get().scheduleWithFixedDelay(new TorrentResumeDataScheduler(this), 10000L, 10000L, TimeUnit.MILLISECONDS);
                        }
                    }
                    finally {
                        this.initialized = true;
                    }
                }
            }
        }
    }

    @Override
    public String getServiceName() {
        return "TorrentManager";
    }

    @Override
    public TorrentManagerSettings getTorrentManagerSettings() {
        return this.torrentManager.get().getTorrentManagerSettings();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setIpFilter(TorrentIpFilter ipFilterPredicate) {
        this.setupTorrentManager();
        this.torrentManager.get().setIpFilter(ipFilterPredicate);
    }

    @Override
    public boolean isDownloadingTorrent(File torrentFile) {
        if (!this.initialized) {
            return false;
        }
        this.setupTorrentManager();
        return this.torrentManager.get().isDownloadingTorrent(torrentFile);
    }

    @Override
    public Torrent getTorrent(File torrentFile) {
        if (!this.initialized) {
            return null;
        }
        this.setupTorrentManager();
        return this.torrentManager.get().getTorrent(torrentFile);
    }

    @Override
    public Torrent getTorrent(String sha1) {
        if (!this.initialized) {
            return null;
        }
        this.setupTorrentManager();
        return this.torrentManager.get().getTorrent(sha1);
    }

    @Override
    public boolean isValid() {
        this.setupTorrentManager();
        return this.torrentManager.get().isValid();
    }

    @Override
    public Torrent addTorrent(TorrentParams params) throws IOException {
        if (!this.isValid()) {
            return null;
        }
        params.fill();
        this.shareTorrent(params.getTorrentFile());
        return this.addTorrentInternal(params);
    }

    private Torrent addTorrentInternal(TorrentParams params) throws IOException {
        File torrentFile = params.getTorrentFile();
        File torrentParent = torrentFile.getParentFile();
        File torrentDownloadFolder = SharingSettings.INCOMPLETE_DIRECTORY.get();
        File torrentUploadFolder = BittorrentSettings.TORRENT_UPLOADS_FOLDER.get();
        if (!torrentParent.equals(torrentDownloadFolder) && !torrentParent.equals(torrentUploadFolder)) {
            torrentDownloadFolder.mkdirs();
            File newTorrentFile = new File(torrentDownloadFolder, params.getName() + ".torrent");
            FileUtils.copy(torrentFile, newTorrentFile);
            params.setTorrentFile(newTorrentFile);
        }
        return this.torrentManager.get().addTorrent(params);
    }

    public Torrent seedTorrent(TorrentParams params) throws IOException {
        if (!this.isValid()) {
            return null;
        }
        params.fill();
        return this.addTorrentInternal(params);
    }

    @Override
    public void removeTorrent(Torrent torrent) {
        this.setupTorrentManager();
        this.torrentManager.get().removeTorrent(torrent);
        torrent.removeListener(this.torrentListener);
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LimeWireTorrentManager limeWireTorrentManager = this;
        synchronized (limeWireTorrentManager) {
            try {
                if (this.initialized && this.torrentManager.get().isValid()) {
                    this.torrentManager.get().stop();
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    @Override
    public void setTorrentManagerSettings(TorrentManagerSettings settings) {
        this.setupTorrentManager();
        this.torrentManager.get().setTorrentManagerSettings(settings);
        this.updateProxies();
        this.limitSeedingTorrents();
    }

    private void updateProxies() {
        ProxySetting proxy = this.buildProxySetting();
        this.torrentManager.get().setPeerProxy(proxy);
        this.torrentManager.get().setTrackerProxy(proxy);
        this.torrentManager.get().setWebSeedProxy(proxy);
        this.torrentManager.get().setDHTProxy(proxy);
    }

    private ProxySetting buildProxySetting() {
        return new ProxySetting(){

            @Override
            public String getHostname() {
                return ConnectionSettings.PROXY_HOST.get();
            }

            @Override
            public int getPort() {
                return ConnectionSettings.PROXY_PORT.getValue();
            }

            @Override
            public String getUsername() {
                return ConnectionSettings.PROXY_USERNAME.get();
            }

            @Override
            public String getPassword() {
                switch (ConnectionSettings.CONNECTION_METHOD.getValue()) {
                    case 4: {
                        return "";
                    }
                }
                return ConnectionSettings.PROXY_PASS.get();
            }

            @Override
            public ProxySettingType getType() {
                boolean authenticate = ConnectionSettings.PROXY_AUTHENTICATE.getValue();
                switch (ConnectionSettings.CONNECTION_METHOD.getValue()) {
                    case 4: {
                        return ProxySettingType.SOCKS4;
                    }
                    case 5: {
                        if (authenticate) {
                            return ProxySettingType.SOCKS5_PW;
                        }
                        return ProxySettingType.SOCKS5;
                    }
                    case 1: {
                        if (authenticate) {
                            return ProxySettingType.HTTP_PW;
                        }
                        return ProxySettingType.HTTP;
                    }
                }
                return null;
            }
        };
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public List<Torrent> getTorrents() {
        if (!this.initialized) {
            return Collections.emptyList();
        }
        this.setupTorrentManager();
        return this.torrentManager.get().getTorrents();
    }

    @Override
    public Lock getLock() {
        this.setupTorrentManager();
        return this.torrentManager.get().getLock();
    }

    @Override
    public boolean isDHTStarted() {
        if (!this.initialized) {
            return false;
        }
        this.setupTorrentManager();
        return this.torrentManager.get().isDHTStarted();
    }

    @Override
    public void startDHT(File dhtStateFile) {
        this.setupTorrentManager();
        this.torrentManager.get().startDHT(dhtStateFile);
    }

    @Override
    public void stopDHT() {
        this.setupTorrentManager();
        this.torrentManager.get().stopDHT();
    }

    @Override
    public void saveDHTState(File dhtStateFile) {
        if (!this.initialized) {
            return;
        }
        this.setupTorrentManager();
        this.torrentManager.get().saveDHTState(dhtStateFile);
    }

    @Override
    public boolean isUPnPStarted() {
        if (!this.initialized) {
            return false;
        }
        this.setupTorrentManager();
        return this.torrentManager.get().isUPnPStarted();
    }

    @Override
    public void startUPnP() {
        this.setupTorrentManager();
        this.torrentManager.get().startUPnP();
    }

    @Override
    public void stopUPnP() {
        this.setupTorrentManager();
        this.torrentManager.get().stopUPnP();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void limitSeedingTorrents() {
        this.torrentManager.get().getLock().lock();
        try {
            int seedingTorrents = 0;
            int maxSeedingTorrents = BittorrentSettings.TORRENT_SEEDING_LIMIT.getValue();
            if (BittorrentSettings.UPLOAD_TORRENTS_FOREVER.getValue()) {
                maxSeedingTorrents = Integer.MAX_VALUE;
            }
            if (maxSeedingTorrents == Integer.MAX_VALUE) {
                return;
            }
            for (Torrent torrent : this.torrentManager.get().getTorrents()) {
                if (!torrent.isFinished()) continue;
                ++seedingTorrents;
            }
            if (seedingTorrents <= maxSeedingTorrents) {
                return;
            }
            ArrayList<Torrent> ratioSortedTorrents = new ArrayList<Torrent>(this.torrentManager.get().getTorrents());
            Collections.sort(ratioSortedTorrents, new Comparator<Torrent>(){

                @Override
                public int compare(Torrent o1, Torrent o2) {
                    int compare = Double.compare(o2.getSeedRatio(), o1.getSeedRatio());
                    if (compare == 0) {
                        TorrentStatus status1 = o1.getStatus();
                        TorrentStatus status2 = o2.getStatus();
                        if (status1 != null && status2 != null) {
                            int time2;
                            int time1 = status1.getSeedingTime();
                            if (time1 > (time2 = status2.getSeedingTime())) {
                                return -1;
                            }
                            if (time2 > time1) {
                                return 1;
                            }
                            return 0;
                        }
                    }
                    return compare;
                }
            });
            int i = 0;
            while (i < seedingTorrents - maxSeedingTorrents && ratioSortedTorrents.size() > 0) {
                Torrent torrent = (Torrent)ratioSortedTorrents.remove(0);
                if (!torrent.isFinished()) continue;
                torrent.stop();
                ++i;
            }
        }
        finally {
            this.torrentManager.get().getLock().unlock();
        }
    }

    @Override
    public void setPeerProxy(ProxySetting proxy) {
        this.setupTorrentManager();
        this.torrentManager.get().setPeerProxy(proxy);
    }

    @Override
    public void setDHTProxy(ProxySetting proxy) {
        this.setupTorrentManager();
        this.torrentManager.get().setDHTProxy(proxy);
    }

    @Override
    public void setTrackerProxy(ProxySetting proxy) {
        this.setupTorrentManager();
        this.torrentManager.get().setTrackerProxy(proxy);
    }

    @Override
    public void setWebSeedProxy(ProxySetting proxy) {
        this.setupTorrentManager();
        this.torrentManager.get().setWebSeedProxy(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shareTorrent(File torrentFile) {
        if (torrentFile == null || !torrentFile.exists() || this.isDownloadingTorrent(torrentFile)) {
            return true;
        }
        if (!SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue()) {
            return true;
        }
        BTDataImpl btData = null;
        FileInputStream torrentInputStream = null;
        try {
            torrentInputStream = new FileInputStream(torrentFile);
            Map torrentFileMap = (Map)Token.parse(torrentInputStream.getChannel());
            btData = new BTDataImpl(torrentFileMap);
        }
        catch (IOException e) {
            boolean bl;
            try {
                LOG.error("Error reading torrent file: " + torrentFile, e);
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.close(torrentInputStream);
                throw throwable;
            }
            FileUtils.close(torrentInputStream);
            return bl;
        }
        FileUtils.close(torrentInputStream);
        if (btData.isPrivate()) {
            this.gnutellaFileList.remove(torrentFile);
            return true;
        }
        File saveDir = SharingSettings.getSaveDirectory();
        File torrentParent = torrentFile.getParentFile();
        if (torrentParent.equals(saveDir)) {
            this.gnutellaFileList.add(torrentFile);
            return true;
        }
        File tFile = this.getSharedTorrentMetaDataFile(btData);
        if (tFile.equals(torrentFile)) {
            this.gnutellaFileList.add(tFile);
            return true;
        }
        if (tFile.exists()) {
            this.gnutellaFileList.add(tFile);
            return true;
        }
        if (FileUtils.copy(torrentFile, tFile)) {
            this.gnutellaFileList.add(tFile);
        }
        return true;
    }

    private File getSharedTorrentMetaDataFile(BTData btData) {
        String fileName = btData.getName().concat(".torrent");
        File f = new File(SharingSettings.getSaveDirectory(), fileName);
        return f;
    }

    private class TorrentManagerStatus
    implements Inspectable {
        private TorrentManagerStatus() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object inspect() {
            LimeWireTorrentManager limeWireTorrentManager = LimeWireTorrentManager.this;
            synchronized (limeWireTorrentManager) {
                return LimeWireTorrentManager.this.initialized ? (((LibTorrentSession)LimeWireTorrentManager.this.torrentManager.get()).isValid() ? Status.LOADED.toString() : Status.FAILED.toString()) : Status.NOT_INITIALIZED.toString();
            }
        }
    }

    private static class IpFilterPredicate
    implements TorrentIpFilter {
        private final IPFilter ipFilter;

        IpFilterPredicate(IPFilter ipFilter) {
            this.ipFilter = ipFilter;
        }

        @Override
        public boolean allow(int ipAddress) {
            return this.ipFilter.allow(new IP(ipAddress, -1));
        }
    }

    private static enum Status {
        NOT_INITIALIZED,
        LOADED,
        FAILED;

    }

    @InspectableContainer
    private class LazyInspectableContainer {
        @InspectionPoint(value="torrent manager", category=DataCategory.USAGE)
        private final Inspectable inspectable = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                HashMap<String, Integer> data = new HashMap<String, Integer>();
                int active = 0;
                int seeding = 0;
                int starting = 0;
                if (LimeWireTorrentManager.this.isInitialized() && LimeWireTorrentManager.this.isValid()) {
                    LimeWireTorrentManager.this.getLock().lock();
                    try {
                        for (Torrent torrent : LimeWireTorrentManager.this.getTorrents()) {
                            if (!torrent.isStarted()) {
                                ++starting;
                                continue;
                            }
                            if (torrent.isFinished()) {
                                ++seeding;
                                continue;
                            }
                            ++active;
                        }
                    }
                    finally {
                        LimeWireTorrentManager.this.getLock().unlock();
                    }
                }
                data.put("active", active);
                data.put("seeding", seeding);
                data.put("starting", starting);
                return data;
            }
        };

        private LazyInspectableContainer() {
        }
    }
}

