/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.xmind.core.ISheet;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.style.IStyle;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.views.CategorizedThemeViewer;
import org.xmind.ui.internal.views.ThemeUICore;
import org.xmind.ui.mindmap.MindMapUI;

public class ThemesView
extends ViewPart
implements IContributedContentsView,
IPartListener,
IPageChangedListener,
ICoreEventListener {
    private static final String GROUP_FILE = "group.file";
    private static final String GROUP_OPEN = "group.open";
    private static final String GROUP_SHOW_IN = "group.showIn";
    private static final String GROUP_EDIT = "group.edit";
    private static final String GROUP_REORGANIZE = "group.reorganize";
    private static final String GROUP_GENERATE = "group.generate";
    private static final String GROUP_PROPERTIES = "group.properties";
    private static final String KEY_LINK_TO_EDITOR = "LINK_TO_EDITOR";
    private IGraphicalEditor activeEditor;
    private ICoreEventRegistration currentSheetEventReg;
    private CategorizedThemeViewer viewer;
    private IDialogSettings dialogSettings;
    private boolean linkingToEditor;
    private ICoreEventRegister register = null;
    private SetDefaultThemeAction setDefaultThemeAction;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public CategorizedThemeViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.setDefaultThemeAction = new SetDefaultThemeAction();
        this.dialogSettings = MindMapUIPlugin.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings.get(KEY_LINK_TO_EDITOR) == null) {
            this.dialogSettings.put(KEY_LINK_TO_EDITOR, true);
        }
        this.linkingToEditor = this.dialogSettings != null && this.dialogSettings.getBoolean(KEY_LINK_TO_EDITOR);
        parent.setLayout((Layout)new FillLayout());
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        parent.setLayout((Layout)new FillLayout());
        MenuManager contextMenu = new MenuManager("#PopupMenu");
        contextMenu.add((IAction)this.setDefaultThemeAction);
        contextMenu.add((IContributionItem)new Separator(GROUP_FILE));
        contextMenu.add((IContributionItem)new Separator(GROUP_OPEN));
        contextMenu.add((IContributionItem)new GroupMarker(GROUP_SHOW_IN));
        contextMenu.add((IContributionItem)new Separator(GROUP_EDIT));
        contextMenu.add((IContributionItem)new Separator(GROUP_REORGANIZE));
        contextMenu.add((IContributionItem)new Separator(GROUP_GENERATE));
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.add((IContributionItem)new Separator(GROUP_PROPERTIES));
        container.setMenu(contextMenu.createContextMenu((Control)container));
        this.viewer = new CategorizedThemeViewer(container);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (ThemesView.this.setDefaultThemeAction != null) {
                    ThemesView.this.setDefaultThemeAction.setEnabled(!selection.isEmpty());
                }
            }
        });
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof IGraphicalEditor) {
            this.setActiveEditor((IGraphicalEditor)editor);
        }
        ToggleLinkEditorAction toggleLinkingAction = new ToggleLinkEditorAction();
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        menu.add((IAction)this.setDefaultThemeAction);
        menu.add((IAction)toggleLinkingAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator(GROUP_EDIT));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addPartListener((IPartListener)this);
        ICoreEventSupport ces = (ICoreEventSupport)MindMapUI.getResourceManager().getUserThemeSheet().getAdapter(ICoreEventSupport.class);
        this.register = new CoreEventRegister((ICoreEventListener)this);
        this.register.setNextSupport(ces);
        this.register.register("styleAdd");
        this.register.register("styleRemove");
        this.register.register("name");
    }

    public void dispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.getSite().setSelectionProvider(null);
        this.setActiveEditor(null);
        super.dispose();
        this.viewer = null;
        this.dialogSettings = null;
        this.setDefaultThemeAction = null;
    }

    public void setFocus() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public IWorkbenchPart getContributingPart() {
        return this.getSite().getPage().getActiveEditor();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private boolean isLinkingToEditor() {
        return this.linkingToEditor;
    }

    private void setLinkingToEditor(boolean linking) {
        if (linking == this.linkingToEditor) {
            return;
        }
        this.linkingToEditor = linking;
        if (this.dialogSettings != null) {
            this.dialogSettings.put(KEY_LINK_TO_EDITOR, linking);
        }
        if (linking) {
            this.updateSelection();
        }
    }

    private Object getViewerInput() {
        return ThemeUICore.getInstance();
    }

    private void updateSelection() {
        if (!this.isLinkingToEditor()) {
            return;
        }
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        String themeId = this.getCurrentThemeId();
        IStyle theme = MindMapUI.getResourceManager().getBlankTheme();
        if (themeId != null && !theme.getId().equals(themeId) && (theme = MindMapUI.getResourceManager().getSystemThemeSheet().findStyle(themeId)) == null) {
            theme = MindMapUI.getResourceManager().getUserThemeSheet().findStyle(themeId);
        }
        this.viewer.setSelection((ISelection)(theme == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)theme)));
    }

    private String getCurrentThemeId() {
        if (this.activeEditor == null) {
            return null;
        }
        IGraphicalEditorPage page = this.activeEditor.getActivePageInstance();
        if (page == null) {
            return null;
        }
        ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
        if (sheet == null) {
            return null;
        }
        String themeId = sheet.getThemeId();
        return themeId;
    }

    public void partActivated(IWorkbenchPart part) {
        if (!(part instanceof IGraphicalEditor)) {
            return;
        }
        this.setActiveEditor((IGraphicalEditor)part);
    }

    private void setActiveEditor(IGraphicalEditor editor) {
        if (editor == this.activeEditor) {
            return;
        }
        if (this.activeEditor != null) {
            this.unhook(this.activeEditor);
        }
        this.activeEditor = editor;
        if (editor != null) {
            this.hook(editor);
        }
        this.setCurrentSheet(this.findCurrentSheet());
        this.updateSelection();
    }

    private void setCurrentSheet(ISheet sheet) {
        if (this.currentSheetEventReg != null) {
            this.currentSheetEventReg.unregister();
            this.currentSheetEventReg = null;
        }
        if (sheet != null) {
            this.hookSheet(sheet);
        }
    }

    private void hookSheet(ISheet sheet) {
        ICoreEventSupport ces = (ICoreEventSupport)sheet.getAdapter(ICoreEventSupport.class);
        if (ces != null) {
            this.currentSheetEventReg = ces.registerCoreEventListener((ICoreEventSource)sheet, "themeId", (ICoreEventListener)this);
        }
    }

    private ISheet findCurrentSheet() {
        if (this.activeEditor == null) {
            return null;
        }
        IGraphicalEditorPage page = this.activeEditor.getActivePageInstance();
        if (page == null) {
            return null;
        }
        ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
        return sheet;
    }

    private void hook(IGraphicalEditor editor) {
        editor.addPageChangedListener((IPageChangedListener)this);
    }

    private void unhook(IGraphicalEditor editor) {
        editor.removePageChangedListener((IPageChangedListener)this);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.activeEditor) {
            this.setActiveEditor(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void pageChanged(PageChangedEvent event) {
        this.setCurrentSheet(this.findCurrentSheet());
        this.viewer.refresh(true);
        this.updateSelection();
    }

    public void handleCoreEvent(final CoreEvent event) {
        if (this.viewer == null) {
            return;
        }
        Control c = this.viewer.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if ("themeId".equals(event.getType())) {
                    ThemesView.this.updateSelection();
                } else if ("name".equals(event.getType())) {
                    ThemesView.this.viewer.update(new Object[]{event.getSource()});
                } else {
                    ThemesView.this.viewer.setInput(ThemesView.this.getViewerInput());
                    ThemesView.this.viewer.setSelection((ISelection)new StructuredSelection(event.getSource()), true);
                }
            }
        });
    }

    protected class SetDefaultThemeAction
    extends Action {
        public SetDefaultThemeAction() {
            super(MindMapMessages.DefaultThemeAction_text, 1);
            this.setToolTipText(MindMapMessages.DefaultThemeAction_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("defaultTheme.gif", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("defaultTheme.gif", false));
            this.setEnabled(this.getSelectionStyle() != null);
        }

        public void run() {
            IStyle style = this.getSelectionStyle();
            if (style == null) {
                return;
            }
            MindMapUI.getResourceManager().setDefaultTheme(style.getId());
            ThemesView.this.viewer.setInput(ThemeUICore.getInstance());
        }

        private IStyle getSelectionStyle() {
            if (ThemesView.this.viewer == null) {
                return null;
            }
            ISelection selection = ThemesView.this.viewer.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IStyle) {
                return (IStyle)obj;
            }
            return null;
        }
    }

    private class ToggleLinkEditorAction
    extends Action {
        public ToggleLinkEditorAction() {
            super(MindMapMessages.ThemesView_LinkWithEditor_text, 2);
            this.setToolTipText(MindMapMessages.ThemesView_LinkWithEditor_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("synced.gif", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("synced.gif", false));
            this.setChecked(ThemesView.this.isLinkingToEditor());
        }

        public void run() {
            ThemesView.this.setLinkingToEditor(this.isChecked());
        }
    }
}

