/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.CategorizedGalleryViewer;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.views.ThemeLabelProvider;
import org.xmind.ui.internal.views.ThemeOverrideDialog;
import org.xmind.ui.internal.views.ThemeUICore;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.util.MindMapUtils;

public class CategorizedThemeViewer
extends CategorizedGalleryViewer {
    private static final int FRAME_WIDTH = 200;
    private static final int FRAME_HEIGHT = 100;

    public CategorizedThemeViewer(Composite container) {
        this.setContentProvider((IContentProvider)new CategorizedThemeContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new CategorizedThemeLabelProvider());
        EditDomain domain = new EditDomain();
        domain.installTool("select tool", (ITool)new GallerySelectTool());
        this.setEditDomain(domain);
        this.initProperties();
        this.postInit();
        this.createControl(container, 64);
        this.setInput(ThemeUICore.getInstance());
    }

    protected void postInit() {
        this.addOpenListener(new ChangeThemeListener());
    }

    private void initProperties() {
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(200, 100));
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.FALSE);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout().align(1, 1));
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
    }

    protected void configureNestedViewer(GalleryViewer viewer, Object category) {
        super.configureNestedViewer(viewer, category);
        this.initGalleryViewer(viewer);
    }

    protected void initGalleryViewer(GalleryViewer galleryViewerer) {
        galleryViewerer.setLabelProvider((IBaseLabelProvider)new ThemeLabelProvider());
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new ThemeSelectTool());
        editDomain.installTool("edit tool", (ITool)new ThemeNameEditTool());
        galleryViewerer.setEditDomain(editDomain);
        Properties properties = galleryViewerer.getProperties();
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.hideTitle", false);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("constrained", true);
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
    }

    protected GalleryViewer createNestedViewer() {
        return new ThemeGalleryViewer();
    }

    public void update(Object[] elements) {
        Object[] themeGroupList;
        Object[] objectArray = themeGroupList = ((CategorizedThemeContentProvider)this.getContentProvider()).getElements(this.getInput());
        int n = themeGroupList.length;
        int n2 = 0;
        while (n2 < n) {
            Object tg = objectArray[n2];
            ThemeUICore.ThemeUIGroup themeGroup = (ThemeUICore.ThemeUIGroup)tg;
            GalleryViewer galleryViewer = this.getNestedViewer(themeGroup);
            galleryViewer.update(elements);
            ++n2;
        }
    }

    public void startEditing(IStyle theme) {
        List<ThemeUICore.ThemeUIGroup> themeGroups = ThemeUICore.getInstance().getThemeGroups();
        for (ThemeUICore.ThemeUIGroup themeGroup : themeGroups) {
            IStyle[] styles;
            IStyle[] iStyleArray = styles = themeGroup.getItems();
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                IStyle style = iStyleArray[n2];
                if (style.equals(theme)) {
                    GalleryViewer galleryViewer = this.getNestedViewer(themeGroup);
                    EditDomain domain = galleryViewer.getEditDomain();
                    ITool tool = domain.getDefaultTool();
                    ((GallerySelectTool)tool).getStatus().setStatus(1, true);
                    domain.handleRequest("edit", (IViewer)galleryViewer);
                    return;
                }
                ++n2;
            }
        }
    }

    public void selectDefault() {
        List categories = this.getCategories();
        if (categories == null || categories.isEmpty() || !(categories.get(0) instanceof ThemeUICore.ThemeUIGroup)) {
            return;
        }
        Object defaultCategory = null;
        for (Object category : this.getCategories()) {
            if ("default".equals(((ThemeUICore.ThemeUIGroup)category).getId())) {
                defaultCategory = category;
                this.setSelectionToCategory(category, (ISelection)new StructuredSelection((Object)MindMapUI.getResourceManager().getDefaultTheme()), true);
                continue;
            }
            this.setSelectionToCategory(category, (ISelection)StructuredSelection.EMPTY, false);
        }
        this.reveal(defaultCategory);
    }

    private class CategorizedThemeContentProvider
    implements ITreeContentProvider {
        private CategorizedThemeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((ThemeUICore)inputElement).getThemeGroups().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ThemeUICore.ThemeUIGroup) {
                return ((ThemeUICore.ThemeUIGroup)parentElement).getItems();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ThemeUICore.ThemeUIGroup) {
                return ThemeUICore.getInstance();
            }
            if (element instanceof IStyle) {
                List<ThemeUICore.ThemeUIGroup> themeGroups = ThemeUICore.getInstance().getThemeGroups();
                for (ThemeUICore.ThemeUIGroup themeGroup : themeGroups) {
                    IStyle[] styles;
                    IStyle[] iStyleArray = styles = themeGroup.getItems();
                    int n = styles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStyle style = iStyleArray[n2];
                        if (element.equals(style)) {
                            return themeGroup;
                        }
                        ++n2;
                    }
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ThemeUICore || element instanceof ThemeUICore.ThemeUIGroup;
        }
    }

    private class CategorizedThemeLabelProvider
    extends ThemeLabelProvider {
        private CategorizedThemeLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof ThemeUICore.ThemeUIGroup) {
                return ((ThemeUICore.ThemeUIGroup)element).getName();
            }
            if (element instanceof IStyle && "theme".equals(((IStyle)element).getType())) {
                return ((IStyle)element).getName();
            }
            return super.getText(element);
        }
    }

    private class ChangeThemeListener
    implements IOpenListener {
        private ChangeThemeListener() {
        }

        public void open(OpenEvent event) {
            Object o;
            IPreferenceStore pref = MindMapUIPlugin.getDefault().getPreferenceStore();
            String themeApply = pref.getString("Theme_Apply");
            if (this.isThemeModified() && ("ASK_USER".equals(themeApply) || "".equals(themeApply))) {
                int code = this.openCoverDialog();
                if (1 == code) {
                    return;
                }
                if (code == 0) {
                    themeApply = "THEME_OVERRIDE";
                } else if (3 == code) {
                    themeApply = "THEME_KEEP";
                }
            }
            if ((o = ((IStructuredSelection)event.getSelection()).getFirstElement()) != null && o instanceof IStyle) {
                this.changeTheme((IStyle)o, themeApply);
            }
        }

        private int openCoverDialog() {
            Shell shell = CategorizedThemeViewer.this.getControl().getShell();
            if (shell != null) {
                return new ThemeOverrideDialog(shell).open();
            }
            return 3;
        }

        private boolean isThemeModified() {
            ISheet sheet = this.getCurrentSheet();
            if (sheet == null) {
                return false;
            }
            if (sheet.getStyleId() != null) {
                return true;
            }
            List<ITopic> topics = MindMapUtils.getAllTopics(sheet, true, true);
            for (ITopic topic : topics) {
                if (topic.getStyleId() != null) {
                    return true;
                }
                Set boundaries = topic.getBoundaries();
                for (IBoundary boundary : boundaries) {
                    if (boundary.getStyleId() == null) continue;
                    return true;
                }
                Set summaries = topic.getSummaries();
                for (ISummary summary : summaries) {
                    if (summary.getStyleId() == null) continue;
                    return true;
                }
            }
            Set relationships = sheet.getRelationships();
            for (IRelationship relationship : relationships) {
                if (relationship.getStyleId() == null) continue;
                return true;
            }
            return false;
        }

        private ISheet getCurrentSheet() {
            IGraphicalEditorPage page = this.getCurrentPage();
            if (page == null) {
                return null;
            }
            ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
            return sheet;
        }

        private IGraphicalEditorPage getCurrentPage() {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            IEditorPart activeEditor = window.getActivePage().getActiveEditor();
            if (!(activeEditor instanceof IGraphicalEditor)) {
                return null;
            }
            return ((IGraphicalEditor)activeEditor).getActivePageInstance();
        }

        private void changeTheme(IStyle theme, String apply) {
            IGraphicalEditorPage page;
            MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ChangeThemeCount");
            if (theme != null) {
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase(String.format("Theme/UseCount/%s", theme.getName().replaceAll(" ", "_")));
            }
            if ((page = this.getCurrentPage()) == null) {
                return;
            }
            IGraphicalViewer viewer = page.getViewer();
            if (viewer == null) {
                return;
            }
            ISheetPart sheetPart = (ISheetPart)viewer.getAdapter(ISheetPart.class);
            if (sheetPart == null) {
                return;
            }
            EditDomain domain = page.getEditDomain();
            if (domain == null) {
                return;
            }
            domain.handleRequest(new Request("modify_theme").setViewer((IViewer)viewer).setPrimaryTarget((IPart)sheetPart).setParameter("resource", (Object)theme).setParameter("override", (Object)apply));
            Control control = viewer.getControl();
            if (control != null && !control.isDisposed()) {
                control.forceFocus();
            }
        }
    }

    private class ThemeGalleryViewer
    extends GalleryViewer {
        private ThemeGalleryViewer() {
        }

        protected boolean isTitleEditable(IPart p) {
            IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserThemeSheet();
            return styleSheet == null ? false : styleSheet.getAllStyles().contains(p.getModel());
        }
    }

    private class ThemeNameEditTool
    extends GalleryEditTool {
        private ThemeNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((IStyle)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            ((IStyle)source.getModel()).setName(document.get());
            MindMapUI.getResourceManager().saveUserThemeSheet();
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            this.getHelper().setPrefWidth(200);
        }
    }

    private class ThemeSelectTool
    extends GallerySelectTool {
        private ThemeSelectTool() {
        }

        protected boolean handleMouseDown(MouseEvent me) {
            FramePart targetFrame = this.findFrame(me.target);
            if (targetFrame != null && targetFrame.getFigure().isSelected()) {
                return super.handleMouseDown(me);
            }
            return this.handleSelectionOnMouseDown(me);
        }

        private FramePart findFrame(IPart part) {
            while (part != null) {
                if (part instanceof FramePart) {
                    return (FramePart)part;
                }
                part = part.getParent();
            }
            return null;
        }
    }
}

