/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print.multipage;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class PrintDialogLayout
extends Layout {
    private IDialogSettings settings;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 0;
    public int verticalSpacing = 0;

    public PrintDialogLayout(IDialogSettings settings) {
        this.settings = settings;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        Control settingsControl = children[0];
        Point size1 = settingsControl.computeSize(-1, -1, flushCache);
        Control previewControl = children[1];
        Point size2 = previewControl.computeSize(-1, -1, flushCache);
        boolean hideDetails = this.settings.getBoolean("hideDetails");
        if (!hideDetails) {
            int width = size1.x + size2.x + this.horizontalSpacing;
            int height = size1.y > size2.y ? size1.y : size2.y;
            return new Point(width + this.marginWidth * 2 + this.marginLeft + this.marginRight, height + this.marginHeight * 2 + this.marginTop + this.marginBottom);
        }
        int width = size1.x > size2.x ? size1.x : size2.x;
        int height = size1.y + size2.y + this.verticalSpacing;
        return new Point(width + this.marginWidth * 2 + this.marginLeft + this.marginRight, height + this.marginHeight * 2 + this.marginTop + this.marginBottom);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getBounds();
        Control[] children = composite.getChildren();
        Control settingsControl = children[0];
        Point settingsSize = settingsControl.computeSize(-1, -1, flushCache);
        Control previewControl = children[1];
        Point previewSize = previewControl.computeSize(-1, -1, flushCache);
        boolean hideDetails = this.settings.getBoolean("hideDetails");
        if (!hideDetails) {
            previewControl.setBounds(new Rectangle(clientArea.x + this.marginWidth + this.marginLeft, clientArea.y + this.marginHeight + this.marginTop, previewSize.x, previewSize.y));
            settingsControl.setBounds(new Rectangle(clientArea.x + this.horizontalSpacing + previewSize.x + this.marginWidth + this.marginLeft, clientArea.y + this.marginHeight + this.marginTop, settingsSize.x, settingsSize.y));
        } else {
            settingsControl.setBounds(new Rectangle(clientArea.x + (clientArea.width - settingsSize.x) / 2, clientArea.y + this.marginHeight + this.marginTop, settingsSize.x, settingsSize.y));
            previewControl.setBounds(new Rectangle(clientArea.x + (clientArea.width - previewSize.x) / 2, clientArea.y + this.verticalSpacing + settingsSize.y + this.marginHeight + this.marginTop, previewSize.x, previewSize.y));
        }
    }
}

