/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dnd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.IFileEntry;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.dnd.MindMapDNDClientBase;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.Logger;
import org.xmind.ui.viewers.FileUtils;

public class FileDndClient
extends MindMapDNDClientBase {
    private static final String CREATE_IMAGE = "CREATE_IMAGE";
    private static final String ADD_EXTERNAL_FILE = "dndConfirm.ExternalFile";
    private FileTransfer transfer = FileTransfer.getInstance();
    private IPreferenceStore pref = null;

    public Object getData(Transfer transfer, TransferData data) {
        if (transfer == this.transfer) {
            return this.transfer.nativeToJava(data);
        }
        return null;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public Object toTransferData(Object[] viewerElements, IViewer viewer) {
        return null;
    }

    @Override
    protected Object[] toViewerElements(Object transferData, Request request, IWorkbook workbook, ITopic targetParent, boolean dropInParent) {
        if (transferData instanceof String[]) {
            List<FileDropHandler> handlers;
            String[] paths = (String[])transferData;
            if (workbook != null && (handlers = this.createFileDropHandlers(paths, request.getIntParameter("dropOperation", 16), dropInParent, request.getTargetViewer().getControl().getShell())) != null) {
                ArrayList<Object> elements = new ArrayList<Object>(handlers.size());
                for (FileDropHandler handler : handlers) {
                    handler.createViewerElements(workbook, targetParent, elements);
                }
                return elements.toArray();
            }
        }
        return null;
    }

    private List<FileDropHandler> createFileDropHandlers(String[] paths, int operation, boolean dropInParent, Shell shell) {
        ArrayList<FileDropHandler> handlers = new ArrayList<FileDropHandler>(paths.length);
        if (FileDndClient.isSingleImage(paths) && dropInParent) {
            this.createImageFileDropHandler(paths[0], operation, handlers);
        } else if (FileDndClient.isSingleFolder(paths)) {
            this.createSingleFolderDropHandler(paths[0], operation, handlers, shell);
        } else if (FileDndClient.isSingleFile(paths)) {
            this.createSingleFileDropHandler(paths[0], operation, handlers, shell);
        } else {
            this.createMultipleFilesDropHandler(paths, operation, handlers, shell);
        }
        return handlers;
    }

    private void createImageFileDropHandler(String imagePath, int operation, List<FileDropHandler> handlers) {
        if (operation == 4) {
            this.createFileDropHandlers(handlers, "CREATE_HYPERLINK", imagePath);
        } else {
            this.createFileDropHandlers(handlers, CREATE_IMAGE, imagePath);
        }
    }

    private void createSingleFolderDropHandler(String path, int operation, List<FileDropHandler> handlers, Shell shell) {
        if (operation == 4) {
            this.createFileDropHandlers(handlers, "CREATE_HYPERLINK", path);
        } else if (operation == 1) {
            this.createFileDropHandlers(handlers, "CREATE_ATTACHMENT", path);
        } else {
            this.askForConfirmation(shell, DialogMessages.DND_ExternalFolder, ADD_EXTERNAL_FILE, NLS.bind((String)DialogMessages.DND_ExternalFolder_confirmation_with_path, (Object)path), handlers, path);
        }
    }

    private void createSingleFileDropHandler(String path, int operation, List<FileDropHandler> handlers, Shell shell) {
        if (operation == 4) {
            this.createFileDropHandlers(handlers, "CREATE_HYPERLINK", path);
        } else if (operation == 1) {
            this.createFileDropHandlers(handlers, "CREATE_ATTACHMENT", path);
        } else {
            this.askForConfirmation(shell, DialogMessages.DND_ExternalFile, ADD_EXTERNAL_FILE, NLS.bind((String)DialogMessages.DND_ExternalFile_confirmation_with_path_size, (Object)path, (Object)FileUtils.fileLengthToString((long)new File(path).length())), handlers, path);
        }
    }

    private void createMultipleFilesDropHandler(String[] paths, int operation, List<FileDropHandler> handlers, Shell shell) {
        if (operation == 4) {
            this.createFileDropHandlers(handlers, "CREATE_HYPERLINK", paths);
        } else if (operation == 1) {
            this.createFileDropHandlers(handlers, "CREATE_ATTACHMENT", paths);
        } else {
            StringBuffer sb = new StringBuffer(paths.length * 30);
            int i = 0;
            while (i < paths.length) {
                File file = new File(paths[i]);
                if (i < 3) {
                    if (i > 0) {
                        sb.append('\r');
                        sb.append('\n');
                    }
                    sb.append(paths[i]);
                    if (!file.isDirectory()) {
                        sb.append(' ');
                        sb.append('(');
                        long size = file.length();
                        sb.append(FileUtils.fileLengthToString((long)size));
                        sb.append(')');
                    }
                } else {
                    sb.append('\r');
                    sb.append('\n');
                    sb.append(NLS.bind((String)DialogMessages.DND_MultipleExternalFiles_moreFiles_with_number, (Object)(paths.length - 3)));
                    break;
                }
                ++i;
            }
            this.askForConfirmation(shell, DialogMessages.DND_MultipleExternalFiles, ADD_EXTERNAL_FILE, NLS.bind((String)DialogMessages.DND_MultipleExternalFiles_confirmation_with_fileList, (Object)sb.toString()), handlers, paths);
        }
    }

    private void askForConfirmation(Shell shell, String itemName, String prefKey, String dialogMessage, List<FileDropHandler> handlers, String ... paths) {
        String active = this.getPref().getString(prefKey);
        if ("".equals(active) || "ASK_USER".equals(active)) {
            active = null;
        }
        if (active == null) {
            shell.forceActive();
            MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, NLS.bind((String)DialogMessages.DND_ConfirmDroppingFileDialog_title_with_type, (Object)itemName), null, dialogMessage, 4, new String[]{DialogMessages.DND_ConfirmDroppingFileDialog_LinkButton_text, DialogMessages.DND_ConfirmDroppingFileDialog_CopyButton_text, IDialogConstants.CANCEL_LABEL}, 0, NLS.bind((String)DialogMessages.DND_ConfirmDroppingFileDialog_RememberCheck_text_with_type, (Object)itemName), false);
            int ret = dialog.open();
            if (ret == 256) {
                active = "CREATE_HYPERLINK";
            } else if (ret == 257) {
                active = "CREATE_ATTACHMENT";
            }
            if (dialog.getToggleState() && active != null) {
                this.getPref().setValue(prefKey, active);
            }
        }
        if (active != null) {
            this.createFileDropHandlers(handlers, active, paths);
        }
    }

    private void createFileDropHandlers(List<FileDropHandler> handlers, String action, String ... paths) {
        int i = 0;
        while (i < paths.length) {
            handlers.add(new FileDropHandler(paths[i], action));
            ++i;
        }
    }

    private IPreferenceStore getPref() {
        if (this.pref == null) {
            this.pref = MindMapUIPlugin.getDefault().getPreferenceStore();
        }
        return this.pref;
    }

    private static boolean isSingleImage(String[] paths) {
        return paths.length == 1 && FileDndClient.isImagePath(paths[0]);
    }

    private static boolean isImagePath(String path) {
        String ext = org.xmind.core.util.FileUtils.getExtension((String)path);
        return ImageFormat.findByExtension((String)ext, null) != null;
    }

    private static boolean isSingleFolder(String[] paths) {
        return paths.length == 1 && new File(paths[0]).isDirectory();
    }

    private static boolean isSingleFile(String[] paths) {
        return paths.length == 1;
    }

    private static Dimension getImageSize(String path) {
        try {
            Image tempImage = new Image((Device)Display.getCurrent(), path);
            Rectangle imageBounds = tempImage.getBounds();
            tempImage.dispose();
            boolean needZoom = DPIUtil.getDeviceZoom() > 100;
            int width = needZoom ? imageBounds.width / 2 : imageBounds.width;
            int height = needZoom ? imageBounds.height / 2 : imageBounds.height;
            return Geometry.getScaledConstrainedSize((int)width, (int)height, (int)400, (int)400);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public boolean canLink(TransferData data, IViewer viewer, Point location, IPart target) {
        return true;
    }

    private class FileDropHandler {
        private String path;
        private String active;

        public FileDropHandler(String path, String action) {
            this.path = path;
            this.active = action;
        }

        public void createViewerElements(IWorkbook workbook, ITopic targetParent, List<Object> elements) {
            File file = new File(this.path);
            if ("CREATE_HYPERLINK".equals(this.active)) {
                elements.add(this.createFileHyperlinkTopic(workbook, file));
            } else if ("CREATE_ATTACHMENT".equals(this.active)) {
                elements.add(this.createAttachmentTopic(workbook, file, null));
            } else if (FileDndClient.CREATE_IMAGE.equals(this.active) && targetParent != null) {
                elements.add(this.createImageOnTopic(workbook, targetParent, file));
            }
        }

        private ITopic createFileHyperlinkTopic(IWorkbook workbook, File file) {
            ITopic topic = workbook.createTopic();
            topic.setTitleText(file.getName());
            topic.setHyperlink(FilePathParser.toURI(file.getAbsolutePath(), false));
            return topic;
        }

        private ITopic createAttachmentTopic(IWorkbook workbook, File file, ITopic parent) {
            ITopic topic = workbook.createTopic();
            topic.setTitleText(file.getName());
            if (file.isDirectory()) {
                String[] subfiles = file.list();
                int i = 0;
                while (i < subfiles.length) {
                    File subfile = new File(file, subfiles[i]);
                    ITopic subtopic = this.createAttachmentTopic(workbook, subfile, topic);
                    topic.add(subtopic, "attached");
                    ++i;
                }
            } else {
                try {
                    IFileEntry entry = workbook.getManifest().createAttachmentFromFilePath(file.getAbsolutePath());
                    entry.decreaseReference();
                    entry.increaseReference();
                    if (FileDndClient.isImagePath(file.getAbsolutePath())) {
                        Dimension size = FileDndClient.getImageSize(file.getAbsolutePath());
                        if (size != null) {
                            topic.getImage().setSource(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
                            topic.getImage().setSize(size.width, size.height);
                            topic.setTitleText("");
                        }
                        topic.setHyperlink(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
                    }
                    topic.setHyperlink(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
                }
                catch (IOException e) {
                    Logger.log(e, "Error occurred when transfering file: " + file.getAbsolutePath());
                }
            }
            return topic;
        }

        private Object createImageOnTopic(IWorkbook workbook, ITopic topic, File file) {
            try {
                IFileEntry entry = workbook.getManifest().createAttachmentFromFilePath(file.getAbsolutePath());
                entry.decreaseReference();
                entry.increaseReference();
                Dimension size = FileDndClient.getImageSize(file.getAbsolutePath());
                if (size != null) {
                    return FileDndClient.this.createModifyImageCommand(topic, HyperlinkUtils.toAttachmentURL((String)entry.getPath()), size.width, size.height, null);
                }
                Logger.log("[FileDndClient] Failed to open invalid image file: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                Logger.log(e, "Error occurred when transfering file: " + file.getAbsolutePath());
            }
            return null;
        }
    }
}

