/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.PageBook;
import org.xmind.core.IRevision;
import org.xmind.core.ISheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.tool.BrowsingTool;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.gallery.NavigationViewer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.mindmap.MindMapRevealService;
import org.xmind.ui.internal.mindmap.MindMapViewer;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Cancelable;
import org.xmind.ui.util.ICancelable;
import org.xmind.ui.viewers.SWTUtils;

public class RevisionPreviewDialog
extends Dialog {
    private static final String USE_STORED_SIZE = "USE_STORED_SIZE";
    private static final IShellProvider NO_PARENT_SHELL = new IShellProvider(){

        public Shell getShell() {
            return null;
        }
    };
    private Shell parentShell;
    private ISheet sourceSheet;
    private List<IRevision> revisions;
    private int index;
    private PageBook pageBook;
    private NavigationViewer navBar = null;
    private Map<Object, MindMapViewer> viewers = new HashMap<Object, MindMapViewer>();
    private MindMapViewer viewer = null;
    private Control corruptionWarning = null;
    private Rectangle actualBounds = null;
    private Listener widgetListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 31 && event.detail == 2 || event.type == 1 && (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)27) || SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)32))) {
                RevisionPreviewDialog.this.close();
            }
        }
    };

    public RevisionPreviewDialog(Shell parentShell, ISheet sourceSheet, List<IRevision> revisions, int index) {
        super(NO_PARENT_SHELL);
        this.parentShell = parentShell;
        this.sourceSheet = sourceSheet;
        this.revisions = revisions;
        this.index = index;
        this.setShellStyle(0xCF0 | RevisionPreviewDialog.getDefaultOrientation());
        this.setBlockOnOpen(false);
    }

    protected boolean isResizable() {
        return true;
    }

    public void update() {
        Object selection = this.getSelection();
        this.updateShellTitle(selection);
        this.showPreviewViewer(selection);
        this.updateNavBar(selection);
    }

    private void updateNavBar(Object selection) {
        this.navBar.setSelection((ISelection)new StructuredSelection(selection));
        this.navBar.getControl().setFocus();
        this.hookWidget(this.navBar.getControl());
    }

    private Object getSelection() {
        if (this.index < 0) {
            return null;
        }
        if (this.index >= this.revisions.size()) {
            return this.sourceSheet;
        }
        return this.revisions.get(this.index);
    }

    private void updateShellTitle(Object selection) {
        String sheetTitle = String.format("\"%s - %s\"", this.sourceSheet.getTitleText(), this.sourceSheet.getRootTopic().getTitleText());
        String title = selection instanceof IRevision ? NLS.bind((String)DialogMessages.RevisionPreviewDialog_Revision_titlePattern, (Object)String.valueOf(((IRevision)selection).getRevisionNumber()), (Object)sheetTitle) : NLS.bind((String)DialogMessages.RevisionPreviewDialog_CurrentRevision_title, (Object)sheetTitle);
        this.getShell().setText(title);
    }

    protected Control createContents(Composite parent) {
        Color background = parent.getDisplay().getSystemColor(25);
        parent.setBackground(background);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new ContainerLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setBackground(background);
        this.pageBook = new PageBook(container, 0);
        this.pageBook.setBackground(background);
        this.hookWidget((Control)this.pageBook);
        this.createNavigationBar(container);
        return this.pageBook;
    }

    private void hookWidget(Control control) {
        control.addListener(31, this.widgetListener);
        control.addListener(1, this.widgetListener);
    }

    private void createNavigationBar(Composite parent) {
        this.navBar = new NavigationViewer();
        this.navBar.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.navBar.setLabelProvider((IBaseLabelProvider)new NavigationLabelProvider());
        this.navBar.createControl(parent);
        Object[] elements = new Object[this.revisions.size() + 1];
        this.revisions.toArray(elements);
        elements[elements.length - 1] = this.sourceSheet;
        this.navBar.setInput((Object)elements);
        this.navBar.addSelectionChangedListener((ISelectionChangedListener)new NavigationSelectionChangedListener());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 0;
        gridData.verticalAlignment = 0;
        gridData.verticalIndent = 0;
        gridData.verticalSpan = 0;
        this.navBar.getControl();
        this.hookWidget(this.navBar.getControl());
    }

    private void showPreviewViewer(Object selection) {
        if (selection instanceof IRevision) {
            IRevision revision = (IRevision)selection;
            ISheet sheet = (ISheet)revision.getContent();
            if (sheet == null) {
                this.pageBook.showPage(this.getCorruptionWarning());
            } else {
                this.viewer = this.getRevisionViewer(revision, sheet);
                this.pageBook.showPage(this.viewer.getControl());
            }
        } else {
            this.viewer = this.getRevisionViewer(this.sourceSheet, this.sourceSheet);
            this.pageBook.showPage(this.viewer.getControl());
        }
    }

    private Control getCorruptionWarning() {
        if (this.corruptionWarning == null) {
            this.corruptionWarning = this.createCorruptionWarning();
        }
        return this.corruptionWarning;
    }

    private Control createCorruptionWarning() {
        Composite composite = new Composite((Composite)this.pageBook, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        label.setText(DialogMessages.RevisionPreviewDialog_CorruptedRevision_message);
        return composite;
    }

    private MindMapViewer getRevisionViewer(Object selection, ISheet sheet) {
        MindMapViewer viewer = this.viewers.get(selection);
        if (viewer == null) {
            viewer = this.createViewer((Composite)this.pageBook, sheet);
            this.viewers.put(selection, viewer);
        }
        return viewer;
    }

    public MindMapViewer createViewer(Composite parent, ISheet sheet) {
        RevisionMindMapViewer viewer = new RevisionMindMapViewer();
        this.initViewer(viewer);
        viewer.createControl(parent);
        viewer.getCanvas().setScrollBarVisibility(FigureCanvas.AUTOMATIC);
        this.hookWidget(viewer.getControl());
        viewer.setInput(new MindMap(sheet));
        return viewer;
    }

    public void initViewer(MindMapViewer viewer) {
        viewer.getProperties().set("centered", true);
        viewer.getProperties().set("margin", 50);
        viewer.getProperties().set("cornered", true);
        MindMapRevealService revealService = new MindMapRevealService(viewer);
        viewer.installService(IRevealService.class, (IViewerService)revealService);
        revealService.setActive(true);
        DefaultPreviewTool tool = new DefaultPreviewTool();
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("default tool", (ITool)tool);
        editDomain.setDefaultTool("default tool");
        viewer.setEditDomain(editDomain);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return MindMapUIPlugin.getDefault().getDialogSettings("org.xmind.ui.RevisionsDialog");
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings.getBoolean(USE_STORED_SIZE)) {
            return super.getInitialSize();
        }
        settings.put(USE_STORED_SIZE, true);
        return new Point(720, 620);
    }

    private void setIndex(int index) {
        index = Math.max(0, Math.min(this.revisions.size(), index));
        if (index == this.index) {
            return;
        }
        this.index = index;
        this.update();
    }

    private void asyncExec(final Runnable job) {
        this.parentShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RevisionPreviewDialog.this.getShell() == null || RevisionPreviewDialog.this.getShell().isDisposed()) {
                    return;
                }
                job.run();
            }
        });
    }

    public int open() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.create();
        }
        this.constrainShellSize();
        this.update();
        this.getShell().open();
        return 0;
    }

    public void open(Rectangle sourceBounds) {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.create();
        }
        this.constrainShellSize();
        Shell shell = this.getShell();
        this.actualBounds = shell.getBounds();
        shell.setRedraw(false);
        shell.setBounds(sourceBounds);
        shell.setAlpha(0);
        shell.setVisible(true);
        shell.setActive();
        shell.setFocus();
        long start = System.currentTimeMillis();
        long end = start + 200L;
        this.animateOpening(shell, sourceBounds, start, end);
    }

    private void animateOpening(final Shell shell, final Rectangle r1, final long start, final long end) {
        if (shell.isDisposed() || this.actualBounds == null) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time > end) {
            this.finishOpening(shell);
        } else {
            double percent = (double)(time - start) / (double)(end - start);
            int alpha = (int)(255.0 * percent);
            Rectangle r2 = this.actualBounds;
            int x = (int)((double)(r2.x - r1.x) * percent + (double)r1.x);
            int y = (int)((double)(r2.y - r1.y) * percent + (double)r1.y);
            int width = (int)((double)(r2.width - r1.width) * percent + (double)r1.width);
            int height = (int)((double)(r2.height - r1.height) * percent + (double)r1.height);
            shell.setAlpha(alpha);
            shell.setBounds(x, y, width, height);
            shell.getDisplay().timerExec(5, new Runnable(){

                @Override
                public void run() {
                    RevisionPreviewDialog.this.animateOpening(shell, r1, start, end);
                }
            });
        }
    }

    private void finishOpening(Shell shell) {
        if (shell.isDisposed() || this.actualBounds == null) {
            return;
        }
        shell.setBounds(this.actualBounds);
        shell.setAlpha(255);
        shell.setVisible(true);
        shell.setActive();
        shell.setFocus();
        this.update();
        shell.setRedraw(true);
        this.actualBounds = null;
    }

    public boolean close() {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed() && this.actualBounds != null) {
            shell.setBounds(this.actualBounds);
            this.actualBounds = null;
        }
        return super.close();
    }

    private class ContainerLayout
    extends Layout {
        private ContainerLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint < 0 || hHint < 0) {
                Control[] children = composite.getChildren();
                int w = Math.max(0, wHint);
                int h = Math.max(0, hHint);
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    Point childSize = child.getSize();
                    w = Math.max(w, childSize.x);
                    h = Math.max(h, childSize.y);
                    ++i;
                }
                return new Point(w, h);
            }
            return new Point(wHint, hHint);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle area = composite.getClientArea();
            int h = 90;
            RevisionPreviewDialog.this.pageBook.setBounds(area.x, area.y, area.width, area.height - h);
            RevisionPreviewDialog.this.navBar.getControl().setBounds(area.x, area.y + area.height - h, area.width, h);
        }
    }

    private class DefaultPreviewTool
    extends BrowsingTool {
        private DefaultPreviewTool() {
        }

        protected boolean handleKeyDown(KeyEvent ke) {
            if (SWTUtils.matchKey((int)ke.getState(), (int)ke.keyCode, (int)0, (int)0x1000003)) {
                RevisionPreviewDialog.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RevisionPreviewDialog.this.setIndex(RevisionPreviewDialog.this.index - 1);
                    }
                });
            } else if (SWTUtils.matchKey((int)ke.getState(), (int)ke.keyCode, (int)0, (int)0x1000004)) {
                RevisionPreviewDialog.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RevisionPreviewDialog.this.setIndex(RevisionPreviewDialog.this.index + 1);
                    }
                });
            }
            return super.handleKeyDown(ke);
        }
    }

    private static class NavigationLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private Font font = FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)32);
        private Image image = null;

        public String getText(Object element) {
            if (element instanceof IRevision) {
                IRevision revision = (IRevision)element;
                return String.valueOf(revision.getRevisionNumber());
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof ISheet) {
                return this.getSheetImage();
            }
            return super.getImage(element);
        }

        private Image getSheetImage() {
            if (this.image == null) {
                this.image = MindMapUI.getImages().get("icons/misc/default_thumbnail.jpg").createImage();
            }
            return this.image;
        }

        public Font getFont(Object element) {
            return this.font;
        }

        public void dispose() {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
            super.dispose();
        }
    }

    private class NavigationSelectionChangedListener
    implements ISelectionChangedListener {
        private ICancelable updater = null;

        private NavigationSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (this.updater != null) {
                this.updater.cancel();
            }
            if ((selection = event.getSelection()).isEmpty()) {
                return;
            }
            this.updater = new Cancelable(){

                protected void doJob() {
                    NavigationSelectionChangedListener.this.updateSelection(selection);
                }
            };
            Display.getCurrent().timerExec(150, (Runnable)this.updater);
        }

        private void updateSelection(ISelection selection) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (sel == RevisionPreviewDialog.this.sourceSheet) {
                RevisionPreviewDialog.this.setIndex(RevisionPreviewDialog.this.revisions.size());
            } else {
                RevisionPreviewDialog.this.setIndex(RevisionPreviewDialog.this.revisions.indexOf(sel));
            }
        }
    }

    private class RevisionMindMapViewer
    extends MindMapViewer {
        private RevisionMindMapViewer() {
        }

        @Override
        protected Control internalCreateControl(Composite parent, int style) {
            FigureCanvas canvas = new FigureCanvas(parent, style, this.getLightweightSystem());
            canvas.setViewport(this.getViewport());
            return canvas;
        }
    }
}

