/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractSummaryDecoration;

public class SquareSummaryDecoration
extends AbstractSummaryDecoration {
    private static PrecisionPoint se = new PrecisionPoint();
    private static PrecisionPoint te = new PrecisionPoint();
    private static PrecisionPoint ce = new PrecisionPoint();

    public SquareSummaryDecoration() {
    }

    public SquareSummaryDecoration(String id) {
        super(id);
    }

    protected void route(IFigure figure, Path shape) {
        PrecisionPoint sp = this.getSourcePosition(figure);
        PrecisionPoint tp = this.getTargetPosition(figure);
        PrecisionPoint cp = this.getConclusionPoint(figure);
        boolean horizontal = this.isHorizontal();
        if (horizontal) {
            double x = this.calculateCenterX(sp, tp, cp);
            se.setLocation(x, sp.y);
            te.setLocation(x, tp.y);
            ce.setLocation(x, cp.y);
        } else {
            double y = this.calculateCenterY(sp, tp, cp);
            se.setLocation(sp.x, y);
            te.setLocation(tp.x, y);
            ce.setLocation(cp.x, y);
        }
        shape.moveTo(sp);
        shape.lineTo(se);
        shape.lineTo(te);
        shape.lineTo(tp);
        shape.moveTo(ce);
        shape.lineTo(cp);
    }

    private double calculateCenterX(PrecisionPoint sp, PrecisionPoint tp, PrecisionPoint cp) {
        double x1 = (sp.x + cp.x) / 2.0;
        double x2 = (tp.x + cp.x) / 2.0;
        return Math.abs(x1 - cp.x) < Math.abs(x2 - cp.x) ? x1 : x2;
    }

    private double calculateCenterY(PrecisionPoint sp, PrecisionPoint tp, PrecisionPoint cp) {
        double y1 = (sp.y + cp.y) / 2.0;
        double y2 = (tp.y + cp.y) / 2.0;
        return Math.abs(y1 - cp.y) < Math.abs(y2 - cp.y) ? y1 : y2;
    }
}

