/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.List;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.ui.gallery.NavigationItemPart;

public class NavigationItemNavigablePolicy
implements IEditPolicy {
    public static final NavigationItemNavigablePolicy DEFAULT = new NavigationItemNavigablePolicy();

    public boolean understands(String requestType) {
        return "navigate_left".equals(requestType) || "navigate_right".equals(requestType) || "navigate_previous".equals(requestType) || "navigate_next".equals(requestType) || "navigate_beginning".equals(requestType) || "navigate_end".equals(requestType);
    }

    public void handle(Request request) {
        NavigationItemPart item = this.findItem(request);
        if (item == null) {
            return;
        }
        IPart parent = item.getParent();
        if (parent == null) {
            return;
        }
        List items = parent.getChildren();
        int index = items.indexOf((Object)item);
        if (index < 0) {
            return;
        }
        String requestType = request.getType();
        if ("navigate_beginning".equals(requestType)) {
            this.handleNavFirst(request, items);
        } else if ("navigate_end".equals(requestType)) {
            this.handleNavLast(request, items);
        } else if ("navigate_left".equals(requestType) || "navigate_previous".equals(requestType)) {
            this.handleNavPrev(request, items, index);
        } else if ("navigate_right".equals(requestType) || "navigate_next".equals(requestType)) {
            this.handleNavNext(request, items, index);
        }
    }

    private void handleNavFirst(Request request, List<IPart> items) {
        if (items.size() > 0) {
            this.setResult(request, items.get(0));
        }
    }

    private void handleNavLast(Request request, List<IPart> items) {
        if (items.size() > 0) {
            this.setResult(request, items.get(items.size() - 1));
        }
    }

    private void handleNavPrev(Request request, List<IPart> items, int index) {
        index = Math.max(0, Math.min(items.size() - 1, index - 1));
        this.setResult(request, items.get(index));
    }

    private void handleNavNext(Request request, List<IPart> items, int index) {
        index = Math.max(0, Math.min(items.size() - 1, index + 1));
        this.setResult(request, items.get(index));
    }

    private void setResult(Request request, IPart part) {
        request.setResult("navigationResult", (Object)new IPart[]{part});
    }

    private NavigationItemPart findItem(Request request) {
        for (IPart part : request.getTargets()) {
            if (!(part instanceof NavigationItemPart)) continue;
            return (NavigationItemPart)part;
        }
        return null;
    }
}

