/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.imports.document;

import com.aspose.words.BookmarkEnd;
import com.aspose.words.Cell;
import com.aspose.words.ControlChar;
import com.aspose.words.CustomDocumentProperties;
import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentProperty;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageData;
import com.aspose.words.License;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.Paragraph;
import com.aspose.words.Row;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.Table;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.Point;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.aspose.AsposeConstants;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.imports.Messages;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.wizards.MindMapImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordImporter
extends MindMapImporter
implements AsposeConstants {
    private static final String TEMP_PATH = "import/word/";
    private final String UNDERLINE = "_";
    private final String RELATIONSHIP_TO = "to";
    private final String RELATIONSHIP_FROM = "from";
    private static int imageIndex = 0;
    private static ISheet sheet;
    private DocumentBuilder builder;
    private Map<String, String> idMap = new HashMap<String, String>();
    private Map<ITopic, String> topicHyperMap = null;
    private List<ITopic> floatingTopics = null;
    private List<RelationshipMap> relationshipList = null;
    private static String cachedTopicTitle;

    static {
        cachedTopicTitle = null;
    }

    public WordImporter(String sourcePath, IWorkbook targetWorkbook) {
        super(sourcePath, targetWorkbook);
    }

    public void build() throws InvocationTargetException, InterruptedException {
        block5: {
            this.setLicense();
            MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ImportFromWordCount");
            this.getMonitor().beginTask(null, 100);
            try {
                try {
                    this.getMonitor().subTask(Messages.WordImport_CreateBuilder);
                    this.builder = new DocumentBuilder(new Document(this.getSourcePath()));
                    this.getMonitor().worked(10);
                    this.checkInterrupted();
                    this.getMonitor().subTask(Messages.WordImport_ReadingNode);
                    Paragraph para = this.builder.getCurrentParagraph();
                    this.getMonitor().worked(10);
                    this.load(para);
                    this.loadDocumentProperties();
                    this.loadFloatingTopicPosition();
                    this.dealTopicHyperlinks();
                    this.dealTopicRelationship();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.idMap = null;
                    this.topicHyperMap = null;
                    this.relationshipList = null;
                    this.floatingTopics = null;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.idMap = null;
                this.topicHyperMap = null;
                this.relationshipList = null;
                this.floatingTopics = null;
                throw throwable;
            }
            this.idMap = null;
            this.topicHyperMap = null;
            this.relationshipList = null;
            this.floatingTopics = null;
        }
        this.postBuilded();
    }

    private void load(Paragraph para) throws InterruptedException {
        this.checkInterrupted();
        sheet = this.getTargetWorkbook().createSheet();
        sheet.setTitleText(this.getSuggestedSheetTitle());
        this.getMonitor().subTask(Messages.WordImport_ReadingCentralTopic);
        ITopic rootTopic = sheet.getRootTopic();
        if (para != null && this.isTitle(para)) {
            this.setTopicTitle(para, rootTopic);
            this.builder.moveToDocumentStart();
            Section section = (Section)this.builder.getCurrentSection().getNextSibling();
            if (section != null) {
                para = section.getBody().getParagraphs().get(0);
            }
        } else {
            sheet.getRootTopic().setTitleText(Messages.Importer_CentralTopic);
        }
        this.getMonitor().worked(20);
        this.checkInterrupted();
        this.getMonitor().subTask(Messages.WordImport_ReadingContent);
        if (para != null) {
            this.loadTopic(rootTopic, para);
        }
        this.getMonitor().worked(50);
        this.addTargetSheet(sheet);
        this.getMonitor().worked(10);
        this.getMonitor().done();
    }

    private void loadTopic(ITopic topic, Paragraph para) throws InterruptedException {
        this.checkInterrupted();
        if (this.isHeading(para)) {
            ITopic subTopic = this.getTargetWorkbook().createTopic();
            int apart = this.getParagraphApart(para, this.getPreviousNode(para));
            if ((topic = this.getParenTopic(topic, apart)) != null) {
                if (this.isFloatingTopic(para) && topic.getParent() == null) {
                    topic.add(subTopic, "detached");
                    if (this.floatingTopics == null) {
                        this.floatingTopics = new ArrayList<ITopic>();
                    }
                    this.floatingTopics.add(subTopic);
                } else {
                    topic.add(subTopic);
                }
                this.setTopicTitle(para, subTopic);
                para = this.getNextParagraph(subTopic, para);
                if (para != null) {
                    this.loadTopic(subTopic, para);
                }
            }
        } else {
            this.loadContent(topic, para);
            para = this.getNextParagraph(topic, para);
            if (para != null) {
                this.loadTopic(topic, para);
            }
        }
    }

    private void loadTopic(ITopic topic, Table next) throws InterruptedException {
        this.checkInterrupted();
        ITopic subTopic = this.getTargetWorkbook().createTopic();
        topic.add(subTopic);
        subTopic.setStructureClass("org.xmind.ui.spreadsheet");
        subTopic.setTitleText("Table");
        if (next.hasChildNodes()) {
            for (Row row : next.getRows()) {
                ITopic rowTopic = this.getTargetWorkbook().createTopic();
                rowTopic.setTitleText("Row " + (next.getRows().indexOf((Node)row) + 1));
                subTopic.add(rowTopic);
                if (!row.hasChildNodes()) continue;
                for (Cell cell : row.getCells()) {
                    ITopic cellTopic = this.getTargetWorkbook().createTopic();
                    rowTopic.add(cellTopic);
                    cellTopic.setTitleText(cell.getText());
                    cellTopic.addLabel("Column " + (row.getCells().indexOf((Node)cell) + 1));
                }
            }
        }
    }

    private void setTopicTitle(Paragraph para, ITopic subTopic) {
        boolean isHyperlink = this.isHyperlink((NodeCollection<Node>)para.getChildNodes());
        if (isHyperlink) {
            this.setTopicHyperlink(subTopic, para);
        } else {
            subTopic.setTitleText(this.getMultiLineText(para.getText()));
        }
        this.putIdMap(subTopic);
    }

    private void loadContent(ITopic topic, Paragraph para) throws InterruptedException {
        this.checkInterrupted();
        if (this.hasImage((Node)para)) {
            ImageData img = this.getImageShape((Node)para).getImageData();
            String imgType = img.getTitle();
            if (imgType.equals("overview")) {
                return;
            }
            if (imgType.contains("marker")) {
                this.loadMarker(topic, para);
                return;
            }
            if (!imgType.equals("overview")) {
                this.loadImage(topic, img);
                return;
            }
        }
        if (this.isRelationship(para)) {
            this.loadRelationship(topic, para);
            return;
        }
        if (this.isNormal(para)) {
            this.loadNotes(topic, (Node)para);
            return;
        }
    }

    private void loadImage(ITopic topic, ImageData img) {
        String savePath = this.getImagePath(img);
        if (savePath != null) {
            try {
                img.save(savePath);
                IImage topicImg = topic.getImage();
                topicImg.setSource(this.loadUri(savePath));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadMarker(ITopic topic, Paragraph para) {
        if (para.getCount() == 1) {
            ImageData image = this.getImageShape((Node)para).getImageData();
            String markerId = this.cutMarkerId(image.getTitle());
            if (markerId != null && !markerId.equals("")) {
                topic.addMarker(markerId);
            }
        } else {
            this.loadMoreMarker(topic, para);
        }
    }

    private void loadMoreMarker(ITopic topic, Paragraph para) {
        Node node = para.getFirstChild();
        int index = 0;
        while (node != null) {
            ImageData image;
            String markerId;
            Shape shape;
            if (node.getNodeType() == 12 && (shape = (Shape)node).getShapeType() == 75 && (markerId = this.cutMarkerId((image = this.getImageShape((Node)para, index).getImageData()).getTitle())) != null && !markerId.equals("")) {
                topic.addMarker(markerId);
            }
            node = node.getNextSibling();
            ++index;
        }
    }

    private void loadFloatingTopicPosition() {
        if (this.floatingTopics == null) {
            return;
        }
        for (ITopic floating : this.floatingTopics) {
            DocumentProperty property = this.getDocumentProperties(floating.getTitleText());
            if (property == null) continue;
            String position = (String)property.getValue();
            if (position == null || position.length() == 0) break;
            int positionX = Integer.parseInt(position.substring(position.indexOf(40) + 1, position.indexOf(44)));
            int positionY = Integer.parseInt(position.substring(position.indexOf(44) + 1, position.indexOf(41)));
            floating.setPosition(new Point(positionX, positionY));
        }
    }

    private String cutMarkerId(String imgTitle) {
        return imgTitle.substring("marker".length());
    }

    private void loadNotes(ITopic topic, Node node) {
        NodeCollection nodes = ((Paragraph)node).getChildNodes();
        IHtmlNotesContent content = (IHtmlNotesContent)topic.getNotes().getContent("html");
        if (content == null) {
            content = (IHtmlNotesContent)this.getTargetWorkbook().createNotesContent("html");
            topic.getNotes().setContent("html", (INotesContent)content);
        }
        IParagraph para = content.createParagraph();
        content.addParagraph(para);
        int nodeCount = nodes.getCount();
        int i = 0;
        while (i < nodeCount) {
            ImageData img;
            Node n = nodes.get(i);
            if (n.getNodeType() == 15) {
                ITextSpan span = content.createTextSpan(n.getText());
                para.addSpan((ISpan)span);
            }
            if (n.getNodeType() == 12 && (img = ((Shape)n).getImageData()) != null) {
                String savePath = this.getImagePath(img);
                try {
                    img.save(savePath);
                    IImageSpan span = content.createImageSpan(this.loadUri(savePath));
                    para.addSpan((ISpan)span);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void loadRelationship(ITopic topic, Paragraph para) {
        NodeCollection allNodes = para.getChildNodes();
        NodeCollection startNodes = para.getChildNodes(16, false);
        int pos = 0;
        for (Node startNode : startNodes) {
            int startnodeIndex = allNodes.indexOf(startNode);
            String relationshipTitle = null;
            if (para.getText().indexOf(21, pos) != -1) {
                int startTag = para.getText().indexOf(40, pos);
                int endTag = para.getText().indexOf(41, pos);
                pos = para.getText().indexOf(21, pos) + 1;
                if (startTag < endTag && endTag < pos) {
                    relationshipTitle = para.getText().substring(startTag + 1, endTag);
                }
            }
            if (!(allNodes.get(startnodeIndex - 1) instanceof BookmarkEnd)) continue;
            BookmarkEnd bookmark = (BookmarkEnd)allNodes.get(startnodeIndex - 1);
            String bookmarkName = bookmark.getName().replaceAll("_", " ").trim();
            if (-1 != bookmarkName.indexOf(",")) {
                bookmarkName = bookmarkName.substring(0, bookmarkName.indexOf(","));
            }
            String bookmarkPrefix = bookmarkName.substring(0, 5);
            String targetTopicTitle = bookmarkName.substring(bookmarkName.indexOf(" ") + 1);
            cachedTopicTitle = targetTopicTitle.replaceAll("_", " ").trim();
            if (bookmarkPrefix.contains("to")) {
                this.putRelationshipMap(topic, cachedTopicTitle, "to", relationshipTitle);
            }
            if (!bookmarkPrefix.contains("from")) continue;
            this.putRelationshipMap(topic, cachedTopicTitle, "from", relationshipTitle);
        }
    }

    private boolean isRelationship(Paragraph para) {
        String paraText = para.getText();
        return paraText.contains(WizardMessages.Export_SeeAlso);
    }

    private void setLicense() {
        try {
            new License().setLicense((InputStream)new ByteArrayInputStream(AsposePlugin.getAsposeLicense()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (this.getMonitor().isCanceled()) {
            throw new InterruptedException();
        }
    }

    private boolean isParagraph(Node node) {
        return node.getNodeType() == 8;
    }

    private boolean hasImage(Node node) {
        Shape s = this.getImageShape(node);
        if (s != null) {
            return s.getShapeType() == 75;
        }
        return false;
    }

    private Shape getImageShape(Node node) {
        int DEFAULT_INDEX = 0;
        return this.getImageShape(node, DEFAULT_INDEX);
    }

    private Shape getImageShape(Node node, int index) {
        if (!this.isParagraph(node)) {
            return null;
        }
        NodeCollection nodes = ((Paragraph)node).getChildNodes();
        Node n = nodes.get(index);
        if (n != null && n.getNodeType() == 12) {
            return (Shape)n;
        }
        return null;
    }

    private int getStyleIdentifier(Paragraph para) {
        return para.getParagraphFormat().getStyleIdentifier();
    }

    private boolean isTitle(Paragraph para) {
        int style = this.getStyleIdentifier(para);
        if (style >= 0) {
            return style == 62;
        }
        return false;
    }

    private boolean isHeading(Paragraph para) {
        if (!this.isParagraph((Node)para)) {
            return false;
        }
        int style = this.getStyleIdentifier(para);
        return style >= 0 && style >= 1 && style <= 9;
    }

    private boolean isFloatingTopic(Paragraph para) {
        return !para.getListFormat().isListItem();
    }

    private int getParagraphApart(Paragraph currentPara, Paragraph previousPara) {
        if (previousPara == null) {
            return -1;
        }
        int currentStyle = this.getStyleIdentifier(currentPara);
        int previousStyle = this.getStyleIdentifier(previousPara);
        if (previousStyle == 62) {
            return -1;
        }
        return previousStyle - currentStyle;
    }

    private ITopic getParenTopic(ITopic topic, int apart) {
        if (apart == 0) {
            return topic.getParent();
        }
        if (apart > 0) {
            ITopic tempTopic = topic;
            int i = 0;
            while (i < apart + 1) {
                tempTopic = tempTopic.getParent();
                ++i;
            }
            return tempTopic;
        }
        return topic;
    }

    private Paragraph getPreviousNode(Paragraph para) {
        Paragraph previousPara = this.getPreviousParagraph(para);
        while (previousPara != null) {
            if (this.isHeading(previousPara)) {
                return previousPara;
            }
            previousPara = this.getPreviousParagraph(previousPara);
        }
        return null;
    }

    private File getTempDir() {
        return FileUtils.ensureDirectory((File)this.createTempDir());
    }

    private File createTempDir() {
        String id = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", System.currentTimeMillis());
        return new File(this.getTempPath(id));
    }

    private String getTempPath(String id) {
        return String.valueOf(Core.getWorkspace().getTempDir(TEMP_PATH)) + "/" + id;
    }

    private IFileEntry loadAttachment(String path) throws InterruptedException {
        this.checkInterrupted();
        try {
            IFileEntry entry = this.getTargetWorkbook().getManifest().createAttachmentFromFilePath(path);
            return entry;
        }
        catch (IOException e) {
            this.log(e, "failed to create attachment from: " + path);
            return null;
        }
    }

    private String getImagePath(ImageData img) {
        try {
            String imgName = String.valueOf(img.getTitle()) + imageIndex + FileFormatUtil.imageTypeToExtension((int)img.getImageType());
            String tempPath = this.getTempDir().getAbsolutePath();
            return String.valueOf(tempPath) + "\\" + imgName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String loadUri(String path) throws InterruptedException {
        return HyperlinkUtils.toAttachmentURL((String)this.loadAttachment(path).getPath());
    }

    private void putIdMap(ITopic topic) {
        String topicTitle = topic.getTitleText();
        String topicId = topic.getId();
        if (topicTitle != null && topicId != null) {
            int index = 1;
            if (this.idMap.containsKey(topicTitle)) {
                for (String key : this.idMap.keySet()) {
                    if (!this.isContainSameTitle(key, topicTitle)) continue;
                    ++index;
                }
            }
            if (1 == index) {
                this.idMap.put(topicTitle, topicId);
            } else {
                this.idMap.put(String.valueOf(topicTitle) + " " + index, topicId);
            }
        }
    }

    private boolean isContainSameTitle(String key, String topicTitle) {
        if (-1 == key.indexOf(topicTitle)) {
            return false;
        }
        if (key.equals(topicTitle)) {
            return true;
        }
        String tailStr = key.substring(topicTitle.length(), key.length());
        String regEx = "^ [0-9]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(tailStr);
        return matcher.matches();
    }

    private void putRelationshipMap(ITopic topic, String linkTopicTitle, String direction, String relationshipTitle) {
        if (this.relationshipList == null) {
            this.relationshipList = new ArrayList<RelationshipMap>();
        }
        RelationshipMap map = new RelationshipMap(topic, linkTopicTitle, direction);
        map.setRelationshipTitle(relationshipTitle);
        this.relationshipList.add(map);
    }

    private void putHyperMap(ITopic topic, String linkTopicTitle) {
        String link = linkTopicTitle;
        link = linkTopicTitle.replace("_", " ").trim();
        if (this.topicHyperMap == null) {
            this.topicHyperMap = new HashMap<ITopic, String>();
        }
        this.topicHyperMap.put(topic, link);
    }

    private boolean isHyperlink(NodeCollection<Node> nodes) {
        int index = 0;
        if (nodes.getCount() < index + 5) {
            return false;
        }
        Node node = nodes.get(index);
        while (node != null) {
            if (node.getNodeType() == 16) {
                return this.isHyperlink(nodes, index);
            }
            ++index;
            node = node.getNextSibling();
        }
        return false;
    }

    private boolean isHyperlink(NodeCollection<Node> nodes, int index) {
        if (nodes.getCount() < index + 5) {
            return false;
        }
        Node startNode = nodes.get(index);
        if (startNode.getNodeType() == 16) {
            int separatorNodeType = nodes.get(index + 2).getNodeType();
            int endNodeType = nodes.get(index + 4).getNodeType();
            if (separatorNodeType == 17 && endNodeType == 18) {
                return true;
            }
        }
        return false;
    }

    private boolean isNormal(Paragraph para) {
        return this.getStyleIdentifier(para) == 0;
    }

    private Paragraph getNextParagraph(ITopic topic, Paragraph para) {
        Node next = para.getNextSibling();
        while (next != null && !(next instanceof Paragraph)) {
            if (next instanceof Table) {
                try {
                    this.loadTopic(topic, (Table)next);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            next = next.getNextSibling();
        }
        return (Paragraph)next;
    }

    private Paragraph getPreviousParagraph(Paragraph para) {
        Node pre = para.getPreviousSibling();
        while (pre != null && !(pre instanceof Paragraph)) {
            pre = pre.getPreviousSibling();
        }
        return (Paragraph)pre;
    }

    private void setTopicHyperlink(ITopic topic, Paragraph para) {
        Node startNode = para.getChildNodes(16, true).get(0);
        NodeCollection nodes = para.getChildNodes();
        int beginIndex = nodes.indexOf(startNode);
        Node hyperlinkNode = nodes.get(beginIndex + 1);
        String hyperlink = this.cutHyperlink(hyperlinkNode.getText());
        String title = nodes.get(beginIndex + 3).getText();
        topic.setTitleText(title);
        if (hyperlink.contains("http:") || hyperlink.contains("https:")) {
            topic.setHyperlink(hyperlink);
        } else {
            this.putHyperMap(topic, this.cutXMindLink(hyperlink));
        }
    }

    private String cutHyperlink(String nodeText) {
        int beginIndex = nodeText.indexOf("\"") + 1;
        int endIndex = nodeText.lastIndexOf("\"");
        return nodeText.substring(beginIndex, endIndex);
    }

    private String cutXMindLink(String hyperlink) {
        int beginIndex = hyperlink.indexOf("#") + 1;
        return hyperlink.substring(beginIndex);
    }

    private void dealTopicHyperlinks() {
        if (this.topicHyperMap == null || this.topicHyperMap.isEmpty()) {
            return;
        }
        for (Map.Entry<ITopic, String> entry : this.topicHyperMap.entrySet()) {
            ITopic topic = entry.getKey();
            String linkTopicTitle = entry.getValue();
            if (this.idMap == null || this.idMap.isEmpty()) break;
            String linkTopicId = this.idMap.get(linkTopicTitle);
            if (linkTopicId == null) continue;
            topic.setHyperlink("xmind:#" + linkTopicId);
        }
    }

    private void dealTopicRelationship() {
        if (this.relationshipList == null || this.relationshipList.isEmpty()) {
            return;
        }
        for (RelationshipMap rel : this.relationshipList) {
            ITopic targetTopic;
            if (this.idMap == null || this.idMap.isEmpty()) break;
            String targetId = this.idMap.get(rel.getTargetTopicId());
            if (targetId == null || (targetTopic = this.getTargetWorkbook().findTopic(targetId)) == null) continue;
            ITopic sorceTopic = rel.getSourceTopic();
            if (!rel.getDirection().equals("to")) continue;
            IRelationship relationship = this.getTargetWorkbook().createRelationship((IRelationshipEnd)sorceTopic, (IRelationshipEnd)targetTopic);
            relationship.setEnd1Id(sorceTopic.getId());
            relationship.setEnd2Id(targetTopic.getId());
            relationship.setTitleText(rel.getRelationshipTitle());
        }
    }

    private DocumentProperty getDocumentProperties(String property) {
        CustomDocumentProperties properties = this.builder.getDocument().getCustomDocumentProperties();
        return properties.get(property);
    }

    private void loadDocumentProperties() {
        this.loadTheme(this.getDocumentProperties("theme"));
    }

    private void loadTheme(DocumentProperty prop) {
        if (prop != null) {
            String theme = (String)prop.getValue();
            StyleUtils.setTheme((ISheet)sheet, (IStyle)this.findTheme(theme));
        }
    }

    private String getMultiLineText(String text) {
        int breakPos = text.indexOf("\u0013TOC \\o \"1-3\" \\h \\z \\u");
        if (breakPos > 0) {
            return text.trim().replaceAll(ControlChar.LINE_BREAK, ControlChar.CR_LF).substring(0, breakPos);
        }
        return text.trim().replaceAll(ControlChar.LINE_BREAK, ControlChar.CR_LF);
    }

    private IStyle findTheme(String themeId) {
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        if ("blank".equals(themeId)) {
            return resourceManager.getBlankTheme();
        }
        IStyleSheet systemThemeSheet = resourceManager.getSystemThemeSheet();
        IStyle style = systemThemeSheet.findStyle(themeId);
        if (style != null) {
            return style;
        }
        IStyleSheet userThemeSheet = resourceManager.getUserThemeSheet();
        return userThemeSheet.findStyle(themeId);
    }

    private class RelationshipMap {
        private ITopic sourceTopic;
        private String targetTopicId;
        private String direction;
        private String relationshipTitle;

        public RelationshipMap(ITopic sourceTopic, String targetTopicId, String direction) {
            this.sourceTopic = sourceTopic;
            this.targetTopicId = targetTopicId;
            this.direction = direction;
        }

        public ITopic getSourceTopic() {
            return this.sourceTopic;
        }

        public String getTargetTopicId() {
            return this.targetTopicId;
        }

        public String getDirection() {
            return this.direction;
        }

        public String getRelationshipTitle() {
            return this.relationshipTitle;
        }

        public void setRelationshipTitle(String relationshipTitle) {
            this.relationshipTitle = relationshipTitle == null || relationshipTitle.trim().equals("") ? null : relationshipTitle;
        }
    }
}

