/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.slide;

import com.aspose.slides.AsposeLicenseException;
import com.aspose.slides.FontEntity;
import com.aspose.slides.License;
import com.aspose.slides.Link;
import com.aspose.slides.Paragraph;
import com.aspose.slides.ParagraphCollection;
import com.aspose.slides.Picture;
import com.aspose.slides.Portion;
import com.aspose.slides.PortionCollection;
import com.aspose.slides.Presentation;
import com.aspose.slides.PresentationEx;
import com.aspose.slides.Slide;
import com.aspose.slides.TextHolder;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.ILegend;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ISummary;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.style.IStyle;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.wizards.ExportPart;
import org.xmind.ui.wizards.ExportUtils;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;
import org.xmind.ui.wizards.IExporter;

public class PPTExporter
extends Exporter {
    public static final int PPT_97_2003 = 1;
    public static final int PPT_2007 = 2;
    public static final int ODP = 3;
    private static final Rectangle PP_IMAGE_BOUNDS = new Rectangle(60, 210, 600, 270);
    private static final String DELIMITER = "\n";
    private static final String TEMP_PATH = "export/ppt/";
    private static final String PPT_FILE_NAME = ".ppt";
    private String targetPath;
    private int version;
    private File scriptDir = null;
    private Map<String, String> tempPaths = null;
    private Presentation pres;
    private PresentationEx presx;
    private int slideCount = 0;
    private static final int LAYOUT_TITLE = 1;
    private static final int LAYOUT_TEXT = 2;

    public PPTExporter(ISheet sheet, ITopic centralTopic, String targetPath, int version) {
        super(sheet, centralTopic);
        this.targetPath = targetPath;
        this.version = version;
    }

    public void init() {
        this.appendTopic(this.getCentralTopic(), 0);
    }

    private void appendTopic(ITopic topic, int level) {
        boolean hasOverview;
        IImage image;
        boolean hasImage;
        boolean hasTags;
        SlidePart slide = level == 0 ? this.appendSlide(topic, 1) : this.appendSlide(topic, 2);
        this.append((IExportPart)new TitlePart(this, topic, slide));
        Set markers = topic.getMarkerRefs();
        Set labels = topic.getLabels();
        boolean hasMarker = this.getBoolean("includeMarkers") && !markers.isEmpty();
        boolean hasLabel = this.getBoolean("includeLabels") && !labels.isEmpty();
        boolean bl = hasTags = hasMarker || hasLabel;
        if (hasTags) {
            this.append((IExportPart)new TagsPart(this, topic, slide, markers, labels));
        }
        boolean bl2 = hasImage = (image = topic.getImage()).getSource() != null;
        if (hasImage) {
            if (level == 0 || hasTags) {
                slide = this.appendSlide(topic, 2);
                this.append((IExportPart)new TitlePart(this, topic, slide));
            }
            this.append((IExportPart)new ImagePart(this, image, slide));
        }
        boolean hasContentsSlide = (hasOverview = this.hasOverview(topic)) || topic.hasChildren("attached");
        boolean hasCoverSlide = hasTags || hasImage || level == 0;
        boolean hasNotesSlide = false;
        if (hasContentsSlide) {
            if (hasCoverSlide || hasNotesSlide) {
                slide = this.appendSlide(topic, 2);
                this.append((IExportPart)new TitlePart(this, topic, slide));
            }
            if (hasOverview) {
                this.append((IExportPart)new OverviewPart(this, topic, slide));
            } else {
                this.append((IExportPart)new SubtopicsPart(this, topic, slide));
            }
        }
        INotes notes = topic.getNotes();
        if (this.getBoolean("includeNotes") && !notes.isEmpty()) {
            INotesContent content = notes.getContent("html");
            if (content == null) {
                content = notes.getContent("plain");
            }
            if (content != null) {
                hasNotesSlide = true;
                if (hasCoverSlide) {
                    slide = this.appendSlide(topic, 2);
                    this.append((IExportPart)new TitlePart(this, topic, slide));
                }
                this.append((IExportPart)new NotesPart(this, content, slide));
            }
        }
        int nextLevel = level + 1;
        for (ITopic subTopic : topic.getChildren("attached")) {
            this.appendTopic(subTopic, nextLevel);
        }
        for (ISummary summary : topic.getSummaries()) {
            ITopic summaryTopic = summary.getTopic();
            if (summaryTopic == null) continue;
            this.appendTopic(summaryTopic, nextLevel);
        }
        for (ITopic floatingTopic : topic.getChildren("detached")) {
            this.appendTopic(floatingTopic, nextLevel);
        }
    }

    private SlidePart appendSlide(Object element, int layout) {
        SlidePart slide = new SlidePart(this, element, ++this.slideCount, layout);
        this.append((IExportPart)slide);
        return slide;
    }

    public void start(Display display, Shell shell) throws InvocationTargetException {
        super.start(display, shell);
        this.setLicense();
        try {
            this.pres = new Presentation();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Locale.setDefault(new Locale("en"));
            this.pres = new Presentation();
        }
        this.removeFristSlide();
    }

    private void setLicense() {
        try {
            new License().setLicense((InputStream)new ByteArrayInputStream(AsposePlugin.getAsposeLicense()));
        }
        catch (AsposeLicenseException e) {
            e.printStackTrace();
        }
    }

    private void removeFristSlide() {
        if (this.pres != null) {
            Slide slide = this.pres.getSlides().get_Item(0);
            this.pres.getSlides().remove(slide);
        }
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        if (part instanceof PPTExportPart) {
            ((PPTExportPart)part).write(this.pres);
        }
    }

    public void end() throws InvocationTargetException {
        if (this.version == 2) {
            String id = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", System.currentTimeMillis());
            String tempDir = String.valueOf(PPTExporter.getTempPath(id)) + PPT_FILE_NAME;
            this.pres.write(tempDir);
            this.presx = new PresentationEx(tempDir);
            try {
                this.presx.write(this.targetPath);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        } else {
            this.pres.write(this.targetPath);
        }
        super.end();
    }

    public String getAttPath(String entryPath) {
        String path;
        if (this.tempPaths == null) {
            this.tempPaths = new HashMap<String, String>();
        }
        if ((path = this.tempPaths.get(entryPath)) == null) {
            path = this.createAttPath(entryPath);
            this.tempPaths.put(entryPath, path);
        }
        return path;
    }

    private String createAttPath(String entryPath) {
        IFileEntry entry = this.getFileEntry(entryPath);
        if (entry != null && entry.canRead()) {
            try {
                File tempFile;
                InputStream is = entry.openInputStream();
                if (is != null && (tempFile = this.getScriptFile(entryPath)) != null) {
                    FileOutputStream os = new FileOutputStream(tempFile);
                    FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
                    return tempFile.getAbsolutePath();
                }
            }
            catch (IOException e) {
                this.log(e, NLS.bind((String)Message_FailedToCopyAttachment, (Object)entryPath));
            }
        }
        return null;
    }

    public String createOverviewPath(ITopic topic, ImageFormat format) {
        File file = new File(this.getScriptDir(), "images/" + topic.getId() + (String)format.getExtensions().get(0));
        FileUtils.ensureFileParent((File)file);
        final MindMapImageExporter exporter = this.createOverviewExporter(topic);
        exporter.setTargetFile(file);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                exporter.export();
            }
        });
        return file.getAbsolutePath();
    }

    private File getScriptFile(String pathName) {
        return FileUtils.ensureFileParent((File)new File(this.getScriptDir(), pathName));
    }

    public File getScriptDir() {
        if (this.scriptDir == null) {
            this.scriptDir = this.createScriptDir();
            FileUtils.ensureDirectory((File)this.scriptDir);
        }
        return this.scriptDir;
    }

    private File createScriptDir() {
        String path = this.getString("saveScriptPath", null);
        if (path != null) {
            File dir = new File(path);
            return dir;
        }
        String id = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", System.currentTimeMillis());
        return new File(PPTExporter.getTempPath(id));
    }

    private static String getTempPath(String id) {
        return String.valueOf(Core.getWorkspace().getTempDir(TEMP_PATH)) + id;
    }

    protected static String trim(String text) {
        return text.replaceAll("\"", "\"\"");
    }

    protected static String getMultiLines(String text, boolean hardBreak) {
        return text;
    }

    public static String getTitleText(ITopic topic, ITopic centralTopic) {
        String titleText = topic.getTitleText();
        String num = ExportUtils.getNumberingText((ITopic)topic, (ITopic)centralTopic);
        if (num != null) {
            titleText = String.valueOf(num) + " " + titleText;
        }
        return titleText;
    }

    public Dimension getImageSize(String path) {
        try {
            Image image = new Image((Device)this.getDisplay(), path);
            Dimension size = new Dimension(image);
            image.dispose();
            size = Geometry.getScaledConstrainedSize((Dimension)size, (Dimension)PP_IMAGE_BOUNDS.getSize());
            return size;
        }
        catch (Throwable e) {
            this.log(e, "Failed to get image size.");
            return new Dimension(320, 240);
        }
    }

    private static String formatHyperlink(String hyperlink) {
        if (PPTExporter.isLinkToWeb(hyperlink) && !hyperlink.contains("http://") && !hyperlink.contains("https://")) {
            return "http://" + hyperlink;
        }
        return hyperlink;
    }

    private static boolean isLinkToWeb(String urlOrBookmark) {
        return urlOrBookmark.contains("www.") || urlOrBookmark.contains(".com") || urlOrBookmark.contains(".cn") || urlOrBookmark.contains(".org") || urlOrBookmark.contains(".cc") || urlOrBookmark.contains(".net");
    }

    private static class ImagePart
    extends PPTExportPart {
        private SlidePart slide;

        public ImagePart(PPTExporter exporter, IImage element, SlidePart slide) {
            super(exporter, element);
            this.slide = slide;
        }

        protected void write() {
            IImage image = (IImage)this.getElement();
            String source = image.getSource();
            if (source != null && HyperlinkUtils.isAttachmentURL((String)source)) {
                String entryPath = HyperlinkUtils.toAttachmentPath((String)source);
                String path = this.getExporter().getAttPath(entryPath);
                if (path != null) {
                    Dimension size = this.getExporter().getImageSize(path);
                    this.picture(this.slide.getSlide(), path, 1, size);
                }
            }
        }
    }

    private static class NotesPart
    extends ShapePart {
        private static final int COLOR_AUTOMATIC = -16777216;
        private SlidePart slide;

        public NotesPart(PPTExporter exporter, INotesContent content, SlidePart slide) {
            super(exporter, content, slide, 2);
            this.slide = slide;
        }

        protected void write() {
            if (this.getElement() instanceof IPlainNotesContent) {
                String text = ((IPlainNotesContent)this.getElement()).getTextContent();
                this.setText(PPTExporter.getMultiLines(text, true), 1);
            } else {
                IHtmlNotesContent content = (IHtmlNotesContent)this.getElement();
                int paraIndex = 0;
                int portIndex = 0;
                Portion port = null;
                TextHolder holder = this.getTextHolder(1);
                int defaultHeight = holder.getHeight();
                holder.setWrapText(true);
                holder.setFitShapeToText(true);
                List paras = content.getParagraphs();
                for (IParagraph p : paras) {
                    if (p.getSpans().size() == 0) continue;
                    Paragraph para = this.writeParagraphStyle(p, holder, paraIndex);
                    portIndex = 0;
                    for (ISpan span : p.getSpans()) {
                        if (span instanceof IImageSpan) continue;
                        if (span instanceof ITextSpan) {
                            port = this.writeTextSpan((ITextSpan)span, para, paraIndex, portIndex);
                            ++portIndex;
                            continue;
                        }
                        if (!(span instanceof IHyperlinkSpan)) continue;
                        List spans = ((IHyperlinkSpan)span).getSpans();
                        String href = ((IHyperlinkSpan)span).getHref();
                        for (ISpan s : spans) {
                            if (s instanceof IImageSpan || !(s instanceof ITextSpan)) continue;
                            port = this.writeTextSpan((ITextSpan)s, para, paraIndex, portIndex);
                            ++portIndex;
                            this.setHyperlink(holder, port.getText(), href);
                        }
                    }
                    ++paraIndex;
                }
                this.fitShapeToText(holder, defaultHeight);
            }
        }

        private int getAlignment(IParagraph p) {
            IStyle style;
            String styleId = p.getStyleId();
            if (styleId != null && (style = this.getExporter().getStyle(styleId)) != null) {
                String value = style.getProperty("fo:text-align");
                if ("center".equals(value)) {
                    return 1;
                }
                if ("right".equals(value)) {
                    return 2;
                }
            }
            return 3;
        }

        private Portion writeTextSpan(ITextSpan span, Paragraph para, int paraIndex, int portIndex) {
            if (paraIndex != 0 || portIndex != 0) {
                para.getPortions().add(new Portion());
            }
            Portion port = para.getPortions().get_Item(portIndex);
            this.writeText(span.getTextContent(), this.getExporter().getStyle(span.getStyleId()), para, port);
            return port;
        }

        private void writeText(String text, IStyle style, Paragraph para, Portion port) {
            if (style != null) {
                port = this.writeTextStyle(style, para, port);
            }
            if (!text.equals("")) {
                port.setText(text);
            }
        }

        private Portion writeTextStyle(IStyle style, Paragraph para, Portion port) {
            String textColor;
            String fontName = style == null ? null : style.getProperty("fo:font-family");
            String availableFontName = FontUtils.getAAvailableFontNameFor((String)fontName);
            fontName = availableFontName != null ? availableFontName : fontName;
            boolean bold = StyleUtils.isBold((IStyle)style);
            boolean italic = StyleUtils.isItalic((IStyle)style);
            boolean underline = StyleUtils.isUnderline((IStyle)style);
            String string = textColor = style == null ? null : style.getProperty("fo:color");
            if (fontName != null) {
                FontEntity font = new FontEntity(this.pres, this.pres.getFonts().get_Item(port.getFontIndex()));
                font.setFontName(fontName);
                port.setFontIndex(font.getFontId());
            }
            port.setFontBold(bold);
            port.setFontItalic(italic);
            port.setFontUnderline(underline);
            int color = this.getColor(textColor);
            port.setFontColor(new Color(color));
            return port;
        }

        private int getColor(String textColor) {
            if (textColor != null) {
                if (textColor.startsWith("#")) {
                    textColor = textColor.substring(1);
                }
                if (textColor.length() == 6) {
                    try {
                        int value = Integer.parseInt(textColor, 16);
                        int r = value >> 16 & 0xFF;
                        int g = value >> 8 & 0xFF;
                        int b = value & 0xFF;
                        return r << 16 | g << 8 | b;
                    }
                    catch (Throwable throwable) {}
                }
            }
            return -16777216;
        }

        private void writeImageSpan(IImageSpan span) {
            String source = span.getSource();
            if (source != null && HyperlinkUtils.isAttachmentURL((String)source)) {
                String entryPath = HyperlinkUtils.toAttachmentPath((String)source);
                String attPath = this.getExporter().getAttPath(entryPath);
                if (attPath != null) {
                    Dimension size = this.getExporter().getImageSize(attPath);
                    this.picture(this.slide.getSlide(), attPath, 1, size);
                }
            }
        }

        private Paragraph writeParagraphStyle(IParagraph p, TextHolder holder, int paraIndex) {
            Paragraph para;
            if (paraIndex == 0) {
                para = holder.getParagraphs().get_Item(0);
            } else {
                holder.getParagraphs().add(new Paragraph());
                para = holder.getParagraphs().get_Item(paraIndex);
            }
            para.setAlignment(this.getAlignment(p));
            return para;
        }
    }

    private static class OverviewPart
    extends PPTExportPart {
        private static final ImageFormat FORMAT = ImageFormat.PNG;
        private SlidePart slide;

        public OverviewPart(PPTExporter exporter, ITopic topic, SlidePart slide) {
            super(exporter, topic);
            this.slide = slide;
        }

        protected void write() {
            String path = this.getExporter().createOverviewPath(this.getTopic(), FORMAT);
            if (path != null) {
                Dimension size = this.getExporter().getImageSize(path);
                this.picture(this.slide.getSlide(), path, 1, size);
            }
        }

        public ITopic getTopic() {
            return (ITopic)this.getElement();
        }
    }

    private static abstract class PPTExportPart
    extends ExportPart {
        protected Presentation pres;
        protected static final int SHAPE_TITLE_POSITION = 0;
        protected static final int SHAPE_BODY_POSITION = 1;

        public PPTExportPart(PPTExporter exporter, Object element) {
            super((IExporter)exporter, element);
        }

        public PPTExporter getExporter() {
            return (PPTExporter)super.getExporter();
        }

        public void write(Presentation pres) {
            this.pres = pres;
            this.write();
        }

        protected abstract void write();

        protected void setHyperlink(TextHolder holder, String text, String hyperlink) {
            Link link = holder.getLinks().addLink();
            link.setBegin(holder.getText().indexOf(text));
            link.setEnd(link.getBegin() + text.length());
            link.setExternalHyperlink(hyperlink);
        }

        protected void picture(Slide slide, String imagePath, int position, Dimension dimen) {
            Picture pic = null;
            try {
                pic = new Picture(this.pres, imagePath);
            }
            catch (Exception exception) {
                return;
            }
            int picId = this.pres.getPictures().add(pic);
            TextHolder holder = (TextHolder)slide.getPlaceholders().get_Item(position);
            dimen = this.pictureFillShape(holder, dimen);
            int slideWidth = slide.getBackground().getWidth();
            int picFrameWidth = slideWidth / 2 - dimen.width / 2;
            int picFrameHeight = holder.getY() + holder.getHeight() / 2 - dimen.height / 2;
            slide.getShapes().addPictureFrame(picId, picFrameWidth, picFrameHeight, dimen.width, dimen.height);
        }

        private Dimension pictureFillShape(TextHolder holder, Dimension dimen) {
            int dimenWidth = dimen.width;
            int dimenHeight = dimen.height;
            int holderWidth = holder.getWidth();
            int holderHeight = holder.getHeight();
            double scale = dimenWidth > dimenHeight ? this.getpictureScale(holderWidth, dimenWidth) : this.getpictureScale(holderHeight, dimenHeight);
            dimen.setWidth((int)((double)dimenWidth * scale));
            dimen.setHeight((int)((double)dimenHeight * scale));
            this.pictureResize(holder, dimen);
            return dimen;
        }

        private double getpictureScale(int shapeSize, int imgSize) {
            return this.getDivide(shapeSize, imgSize);
        }

        private Dimension pictureResize(TextHolder holder, Dimension dimen) {
            double scale;
            if (dimen.width() > holder.getWidth()) {
                scale = this.getDivide(holder.getWidth(), dimen.width());
                dimen.setWidth((int)((double)dimen.width() * scale));
                dimen.setHeight((int)((double)dimen.height() * scale));
            }
            if (dimen.height() > holder.getHeight()) {
                scale = this.getDivide(holder.getHeight(), dimen.height());
                dimen.setWidth((int)((double)dimen.width() * scale));
                dimen.setHeight((int)((double)dimen.height() * scale));
            }
            return dimen;
        }

        private double getDivide(int value01, int value02) {
            BigDecimal val01 = new BigDecimal(value01);
            BigDecimal val02 = new BigDecimal(value02);
            return val01.divide(val02, 10, 1).doubleValue();
        }
    }

    protected static abstract class ShapePart
    extends PPTExportPart {
        private SlidePart slide;
        private TextHolder textHolder;

        public ShapePart(PPTExporter exporter, Object element, SlidePart slide, int shapeIndex) {
            super(exporter, element);
            this.slide = slide;
        }

        protected TextHolder getTextHolder(int position) {
            TextHolder holder = (TextHolder)this.pres.getSlideByPosition(this.slide.getSlideIndex()).getPlaceholders().get_Item(position);
            return holder;
        }

        protected void fitShapeToText(TextHolder holder, int defaultHeight) {
            double aveFontSize = 0.0;
            ParagraphCollection paras = holder.getParagraphs();
            try {
                while (defaultHeight < holder.getHeight()) {
                    int paraIndex = paras.getCount();
                    int i = 0;
                    while (i < paraIndex) {
                        Paragraph para = holder.getParagraphs().get_Item(i);
                        PortionCollection ports = para.getPortions();
                        int portIndex = ports.getCount();
                        int j = 0;
                        while (j < portIndex) {
                            Portion port = ports.get_Item(j);
                            short fontSize = port.getFontHeight();
                            fontSize = (short)(fontSize - 1);
                            port.setFontHeight(fontSize);
                            aveFontSize = this.averageFontSize(fontSize, aveFontSize);
                            holder.fitTextToShape();
                            ++j;
                        }
                        ++i;
                    }
                    if (!(aveFontSize < 8.0)) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected void setText(String text, int position) {
            try {
                this.textHolder = this.getTextHolder(position);
                int defaultHeight = this.textHolder.getHeight();
                this.textHolder.setText(text);
                this.fitShapeToText(defaultHeight);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void fitShapeToText(int defaultHeight) {
            this.textHolder.setWrapText(true);
            this.textHolder.setFitShapeToText(true);
            if (defaultHeight < this.textHolder.getHeight()) {
                this.fitShapeToText(this.textHolder, defaultHeight);
            }
        }

        private double averageFontSize(int fontSize, double aveFontSize) {
            if (aveFontSize == 0.0) {
                return fontSize;
            }
            return (aveFontSize + (double)fontSize) / 2.0;
        }
    }

    protected static class SlidePart
    extends PPTExportPart {
        private int slideIndex;
        private int layout;

        public SlidePart(PPTExporter exporter, Object element, int slideIndex, int layout) {
            super(exporter, element);
            this.slideIndex = slideIndex;
            this.layout = layout;
        }

        public int getSlideIndex() {
            return this.slideIndex;
        }

        protected void write() {
            if (this.layout == 1) {
                this.pres.addTitleSlide();
                Slide slide = this.pres.getSlides().get_Item(0);
                TextHolder holder01 = (TextHolder)slide.getPlaceholders().get_Item(0);
                TextHolder holder02 = (TextHolder)slide.getPlaceholders().get_Item(1);
                holder01.setX(432);
                holder01.setY(1342);
                holder01.setWidth(4896);
                holder01.setHeight(926);
                holder02.setX(864);
                holder02.setY(2448);
                holder02.setWidth(4032);
                holder02.setHeight(1104);
            }
            if (this.layout == 2) {
                this.pres.addBodySlide();
            }
        }

        public Slide getSlide() {
            return this.pres.getSlideByPosition(this.slideIndex);
        }
    }

    private static class SubtopicsPart
    extends ShapePart {
        public SubtopicsPart(PPTExporter exporter, ITopic topic, SlidePart slide) {
            super(exporter, topic, slide, 2);
        }

        public ITopic getTopic() {
            return (ITopic)this.getElement();
        }

        protected void write() {
            StringBuilder sb = new StringBuilder();
            List children = this.getTopic().getChildren("attached");
            Iterator it = children.iterator();
            while (it.hasNext()) {
                ITopic subTopic = (ITopic)it.next();
                String titleText = PPTExporter.getTitleText(subTopic, this.getExporter().getCentralTopic());
                sb.append(titleText);
                if (!it.hasNext()) continue;
                sb.append('\r');
            }
            String text = sb.toString();
            if (!"".equals(text)) {
                this.setText(PPTExporter.getMultiLines(text, true), 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagsPart
    extends ShapePart {
        private Set<IMarkerRef> markers;
        private Set<String> labels;

        public TagsPart(PPTExporter exporter, ITopic topic, SlidePart slide, Set<IMarkerRef> markers, Set<String> labels) {
            super(exporter, topic, slide, 2);
            this.markers = markers;
            this.labels = labels;
        }

        @Override
        protected void write() {
            boolean hasLabel;
            boolean hasMarker;
            ITopic topic = (ITopic)this.getElement();
            String sep = this.isCentralTopic(topic) ? ", " : PPTExporter.DELIMITER;
            ILegend legend = null;
            StringBuilder sb = new StringBuilder();
            boolean bl = hasMarker = this.markers != null && !this.markers.isEmpty();
            if (hasMarker) {
                Iterator<IMarkerRef> it = this.markers.iterator();
                while (it.hasNext()) {
                    String markerId = it.next().getMarkerId();
                    if (legend == null) {
                        legend = topic.getOwnedSheet().getLegend();
                    }
                    String name = legend.getMarkerDescription(markerId);
                    sb.append(PPTExporter.trim(name));
                    if (!it.hasNext()) continue;
                    sb.append(sep);
                }
            }
            boolean bl2 = hasLabel = this.labels != null && !this.labels.isEmpty();
            if (hasLabel && hasMarker) {
                sb.append(sep);
            }
            if (hasLabel) {
                Iterator<String> it = this.labels.iterator();
                while (it.hasNext()) {
                    sb.append(PPTExporter.trim(it.next()));
                    if (!it.hasNext()) continue;
                    sb.append(sep);
                }
            }
            this.setText(PPTExporter.getMultiLines(sb.toString(), true), 1);
        }
    }

    private static class TitlePart
    extends ShapePart {
        public TitlePart(PPTExporter exporter, ITopic topic, SlidePart slide) {
            super(exporter, topic, slide, 1);
        }

        public ITopic getTopic() {
            return (ITopic)this.getElement();
        }

        protected void write() {
            String hyperlink;
            ITopic topic = this.getTopic();
            ITopic centralTopic = this.getExporter().getCentralTopic();
            String titleText = PPTExporter.getMultiLines(PPTExporter.getTitleText(topic, centralTopic), false);
            this.setText(titleText, 0);
            if (this.getExporter().getBoolean("includeHyperlink") && (hyperlink = topic.getHyperlink()) != null) {
                this.setHyperlink(this.getTextHolder(0), titleText, PPTExporter.formatHyperlink(hyperlink));
            }
        }
    }
}

