/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.part.IPageSite;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyled;
import org.xmind.gef.ui.properties.PropertySectionPart;
import org.xmind.ui.internal.meggy.Messages;
import org.xmind.ui.internal.properties.IStyleEditingDelegate;
import org.xmind.ui.internal.properties.IStyleEditingSectionPart;
import org.xmind.ui.internal.styleeditor.StyleEditorDialog;
import org.xmind.ui.mindmap.MindMapUI;

public class StyleEditingSectionPart
extends PropertySectionPart
implements IStyleEditingSectionPart,
IActivityManagerListener {
    private IActivityManager activityManager;
    private Button editButton;
    private IStyleEditingDelegate delegate;

    public void createControl(Composite parent) {
        IWorkbench workbench;
        Assert.isTrue((this.getContainer() != null ? 1 : 0) != 0);
        IPageSite site = this.getContainer().getContainerSite();
        IWorkbench iWorkbench = workbench = site == null ? PlatformUI.getWorkbench() : (IWorkbench)site.getService(IWorkbench.class);
        if (workbench != null) {
            this.activityManager = workbench.getActivitySupport().getActivityManager();
            this.activityManager.addActivityManagerListener((IActivityManagerListener)this);
        } else {
            this.activityManager = null;
        }
        GridLayout bottomLayout = new GridLayout();
        bottomLayout.marginWidth = 0;
        bottomLayout.marginHeight = 0;
        parent.setLayout((Layout)bottomLayout);
        this.editButton = new Button(parent, 8);
        this.editButton.setText(Messages.StyleEidtor_add_edit_label);
        this.editButton.setLayoutData((Object)new GridData(2, 2, true, false));
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        StyleEditingSectionPart.this.showStyleEditorDialog();
                    }
                });
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StyleEditingSectionPart.this.handleDispose();
            }
        });
        this.updateEditButton();
    }

    public void setFocus() {
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection);
        this.updateEditButton();
    }

    private void showStyleEditorDialog() {
        IWorkbenchWindow window;
        if (this.getContainer() == null) {
            return;
        }
        IPageSite site = this.getContainer().getContainerSite();
        IWorkbenchWindow iWorkbenchWindow = window = site == null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow() : site.getWorkbenchWindow();
        if (window == null) {
            return;
        }
        String type = this.getCurrentStyleType();
        if (type == null) {
            return;
        }
        final IStyle dummyStyle = MindMapUI.getResourceManager().getSystemStyleSheet().createStyle(type);
        VerifyUI20141031.runAction20141031((String)"EditStyles", (String)Messages.StyleEditor_title, (int)7, (Runnable)new Runnable(){

            public void run() {
                new StyleEditorDialog(window, dummyStyle).open();
            }
        }, null);
        if (this.delegate != null) {
            this.delegate.styleEditingFinished();
        }
    }

    private String getCurrentStyleType() {
        ISelection selection = this.getCurrentSelection();
        String type = null;
        if (selection instanceof IStructuredSelection) {
            for (Object obj : ((IStructuredSelection)selection).toList()) {
                String t = null;
                if (obj instanceof IStyled) {
                    t = ((IStyled)obj).getStyleType();
                }
                if (t == null || type != null && !t.equals(type)) {
                    return null;
                }
                if (type != null) continue;
                type = t;
            }
        }
        return type;
    }

    private void handleDispose() {
        if (this.activityManager != null) {
            this.activityManager.removeActivityManagerListener((IActivityManagerListener)this);
        }
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        this.updateEditButton();
    }

    private void updateEditButton() {
        boolean enabled;
        if (this.editButton == null || this.editButton.isDisposed()) {
            return;
        }
        String type = this.getCurrentStyleType();
        boolean bl = enabled = type != null;
        if (enabled && this.activityManager != null) {
            enabled &= this.activityManager.getEnabledActivityIds().contains("org.xmind.ui.activities.proFeatures");
        }
        this.editButton.setEnabled(enabled);
        this.editButton.setVisible(enabled);
        ((GridData)this.editButton.getLayoutData()).exclude = !enabled;
        this.editButton.getShell().layout(true, true);
    }

    public void setDelegate(IStyleEditingDelegate delegate) {
        this.delegate = delegate;
    }
}

