/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelProposalProvider
implements IContentProposalProvider {
    private String[] usedAssigees;

    public LabelProposalProvider(List<String> list) {
        this.usedAssigees = list.toArray(new String[0]);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<String> labelsBefore = new ArrayList<String>();
        int prevSepIndex = contents.lastIndexOf(",", position - 1);
        if (prevSepIndex > 0) {
            this.fillLabelList(labelsBefore, prevSepIndex < 0 ? "" : contents.substring(0, prevSepIndex));
        }
        ArrayList<String> labelsAfter = new ArrayList<String>();
        int nextSepIndex = contents.indexOf(",", position);
        if (nextSepIndex > 0) {
            this.fillLabelList(labelsAfter, contents.substring(nextSepIndex + 1, contents.length()));
        }
        ArrayList<String> propTexts = new ArrayList<String>();
        int i = 0;
        while (i < this.usedAssigees.length) {
            String prop = this.usedAssigees[i];
            if (!labelsBefore.contains(prop) && !labelsAfter.contains(prop)) {
                propTexts.add(prop);
            }
            ++i;
        }
        String prefix = this.makeLabelText(labelsBefore);
        String suffix = this.makeLabelText(labelsAfter);
        IFilter filter = this.makeFilter(contents.substring(prevSepIndex + 1, position).trim());
        ArrayList<IContentProposal> props = new ArrayList<IContentProposal>(propTexts.size());
        for (String propText : propTexts) {
            if (!filter.select((Object)propText)) continue;
            props.add(this.makeContentProposal(prefix, suffix, propText));
        }
        if (!props.isEmpty()) {
            props.add(0, this.makeContentProposal(prefix, suffix, this.getCurrentLabel(contents, prevSepIndex, nextSepIndex)));
        }
        return props.toArray(new IContentProposal[props.size()]);
    }

    private String getCurrentLabel(String contents, int prevSepIndex, int nextSepIndex) {
        if (nextSepIndex < 0) {
            nextSepIndex = contents.length();
        }
        return contents.substring(prevSepIndex + 1, nextSepIndex).trim();
    }

    private IFilter makeFilter(final String filterText) {
        return new IFilter(){
            int filterLength;
            {
                this.filterLength = string.length();
            }

            public boolean select(Object toTest) {
                if (toTest instanceof String) {
                    String propText = (String)toTest;
                    return propText.length() > this.filterLength && propText.substring(0, this.filterLength).equalsIgnoreCase(filterText);
                }
                return false;
            }
        };
    }

    private String makeLabelText(Collection<String> labels) {
        StringBuffer sb = new StringBuffer(labels.size() * 10);
        for (String label : labels) {
            if (sb.length() > 0) {
                sb.append(",");
                sb.append(' ');
            }
            sb.append(label);
        }
        return sb.toString();
    }

    private void fillLabelList(Collection<String> labelList, String contents) {
        String[] labels = contents.split(",");
        int i = 0;
        while (i < labels.length) {
            labelList.add(labels[i].trim());
            ++i;
        }
    }

    private IContentProposal makeContentProposal(final String prefix, final String suffix, final String proposal) {
        return new IContentProposal(){
            String content = null;
            int preLength;
            int sufLength;
            int propLength;
            int cursorPosition;
            {
                this.preLength = string.length();
                this.sufLength = string2.length();
                this.propLength = string3.length();
                this.cursorPosition = -1;
            }

            public String getContent() {
                if (this.content == null) {
                    StringBuffer sb = new StringBuffer(this.preLength + this.sufLength + this.propLength + 4);
                    if (this.preLength > 0) {
                        sb.append(prefix);
                        sb.append(",");
                        sb.append(' ');
                    }
                    sb.append(proposal);
                    if (this.sufLength > 0) {
                        sb.append(",");
                        sb.append(' ');
                        sb.append(suffix);
                    }
                    if (this.propLength > 0 || this.sufLength > 0) {
                        sb.append(",");
                        sb.append(' ');
                    }
                    this.content = sb.toString();
                }
                return this.content;
            }

            public String getDescription() {
                return null;
            }

            public String getLabel() {
                return this.getContent();
            }

            public int getCursorPosition() {
                if (this.cursorPosition < 0) {
                    this.cursorPosition = this.propLength;
                    if (this.preLength > 0) {
                        this.cursorPosition += this.preLength + 2;
                    }
                    if (this.propLength > 0 || this.sufLength > 0) {
                        this.cursorPosition += 2;
                    }
                }
                return this.cursorPosition;
            }

            public String toString() {
                return this.getContent();
            }
        };
    }
}

